/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.ParseRules;
import uk.ac.cam.ch.wwmm.opsin.ParseRulesResults;
import uk.ac.cam.ch.wwmm.opsin.ParseTokens;
import uk.ac.cam.ch.wwmm.opsin.ParsingException;
import uk.ac.cam.ch.wwmm.opsin.StringTools;
import uk.ac.cam.ch.wwmm.opsin.WordTools;
import uk.ac.cam.ch.wwmm.opsin.WordType;

class CASTools {
    private static final Pattern matchCasCollectiveIndex = Pattern.compile("([\\[\\(\\{]([1-9][0-9]?[cC][iI][, ]?)+[\\]\\)\\}])+|[1-9][0-9]?[cC][iI]", 2);
    private static final Pattern matchAcid = Pattern.compile("acid[\\]\\)\\}]*");
    private static final Pattern matchCommaSpace = Pattern.compile(", ");
    private static final Pattern matchCompoundWithPhrase = Pattern.compile("(compd\\. with|compound with|and) ", 2);

    CASTools() {
    }

    static String uninvertCASName(String name, ParseRules parseRules) throws ParsingException {
        ArrayList<String> nameComponents = new ArrayList<String>(Arrays.asList(matchCommaSpace.split(name)));
        ArrayList<String> substituents = new ArrayList<String>();
        ArrayList<String> seperateWordSubstituents = new ArrayList<String>();
        ArrayList<String> functionalTerms = new ArrayList<String>();
        String parent = (String)nameComponents.get(0);
        String[] parentNameParts = OpsinTools.MATCH_SPACE.split(parent);
        if (parentNameParts.length != 1) {
            if (matchCasCollectiveIndex.matcher(parentNameParts[parentNameParts.length - 1]).matches()) {
                StringBuilder parentSB = new StringBuilder();
                for (int i = 0; i < parentNameParts.length - 1; ++i) {
                    parentSB.append(parentNameParts[i]);
                }
                parent = parentSB.toString();
                parentNameParts = OpsinTools.MATCH_SPACE.split(parent);
            }
            for (int i = 1; i < parentNameParts.length; ++i) {
                ParseRulesResults results;
                List<ParseTokens> parseTokens;
                if (matchAcid.matcher(parentNameParts[i]).matches() || !(parseTokens = (results = parseRules.getParses(parentNameParts[i])).getParseTokensList()).isEmpty()) continue;
                throw new ParsingException("Invalid CAS name. Parent compound was followed by an unexpected term");
            }
        }
        boolean addedBracket = false;
        boolean esterEncountered = false;
        for (int i = 1; i < nameComponents.size(); ++i) {
            String[] components;
            String nameComponent = (String)nameComponents.get(i);
            Matcher m = matchCompoundWithPhrase.matcher(nameComponent);
            boolean compoundWithcomponent = false;
            if (m.lookingAt()) {
                nameComponent = nameComponent.substring(m.group().length());
                compoundWithcomponent = true;
            }
            for (String component : components = OpsinTools.MATCH_SPACE.split((CharSequence)nameComponents.get(i))) {
                if (compoundWithcomponent) {
                    functionalTerms.add(component);
                    continue;
                }
                if (component.endsWith("-")) {
                    Character missingCloseBracket = CASTools.missingCloseBracketCharIfApplicable(component);
                    if (missingCloseBracket != null) {
                        if (addedBracket) {
                            throw new ParsingException("Close bracket appears to be missing");
                        }
                        parent = parent + missingCloseBracket;
                        addedBracket = true;
                    }
                    substituents.add(component);
                    continue;
                }
                ParseRulesResults results = parseRules.getParses(component);
                List<ParseTokens> parseTokens = results.getParseTokensList();
                if (parseTokens.size() > 0) {
                    if (WordTools.splitIntoParseWords(parseTokens, component).size() > 1) {
                        throw new ParsingException("Missing space found in name prevents interpetation as CAS index name");
                    }
                    WordType wordType = OpsinTools.determineWordType(parseTokens.get(0).getAnnotations());
                    for (int j = 1; j < parseTokens.size(); ++j) {
                        if (wordType.equals((Object)OpsinTools.determineWordType(parseTokens.get(j).getAnnotations()))) continue;
                        throw new ParsingException(component + "can be interpeted in multiple ways. For the sake of precision OPSIN has decided not to process this as a CAS name");
                    }
                    if (wordType.equals((Object)WordType.functionalTerm)) {
                        if (component.equalsIgnoreCase("ester")) {
                            if (esterEncountered) {
                                throw new ParsingException("ester formation was mentioned more than once in CAS name!");
                            }
                            parent = CASTools.uninvertEster(parent);
                            esterEncountered = true;
                            continue;
                        }
                        functionalTerms.add(component);
                        continue;
                    }
                    if (wordType.equals((Object)WordType.substituent)) {
                        seperateWordSubstituents.add(component);
                        continue;
                    }
                    if (!wordType.equals((Object)WordType.full)) continue;
                    if (StringTools.endsWithCaseInsensitive(component, "ate") || StringTools.endsWithCaseInsensitive(component, "ite") || component.equalsIgnoreCase("hydrofluoride") || component.equalsIgnoreCase("hydrochloride") || component.equalsIgnoreCase("hydrobromide") || component.equalsIgnoreCase("hydroiodide")) {
                        functionalTerms.add(component);
                        continue;
                    }
                    throw new ParsingException("Unable to interpret: " + component + " (as part of a CAS index name)- A full word was encountered where a substituent or functionalTerm was expected");
                }
                if (matchCasCollectiveIndex.matcher(component).matches()) continue;
                throw new ParsingException("Unable to interpret: " + component + " (as part of a CAS index name)");
            }
        }
        StringBuilder casName = new StringBuilder();
        for (String prefixFunctionalTerm : seperateWordSubstituents) {
            casName.append(prefixFunctionalTerm);
            casName.append(" ");
        }
        for (String substituent : substituents) {
            casName.append(substituent);
        }
        casName.append(parent);
        for (String functionalTerm : functionalTerms) {
            casName.append(" ");
            casName.append(functionalTerm);
        }
        return casName.toString();
    }

    private static Character missingCloseBracketCharIfApplicable(String component) {
        char[] characters2 = component.toCharArray();
        int bracketLevel = 0;
        Character missingCloseBracket = null;
        for (int i = 0; i < characters2.length; ++i) {
            char character = characters2[i];
            if ((character == '(' || character == '[' || character == '{') && ++bracketLevel == 1) {
                missingCloseBracket = Character.valueOf(character);
            }
            if (character != ')' && character != ']' && character != '}' || --bracketLevel >= 0) continue;
            return null;
        }
        if (bracketLevel == 1) {
            if (missingCloseBracket.charValue() == '(') {
                return Character.valueOf(')');
            }
            if (missingCloseBracket.charValue() == '[') {
                return Character.valueOf(']');
            }
            if (missingCloseBracket.charValue() == '{') {
                return Character.valueOf('}');
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String uninvertEster(String parent) throws ParsingException {
        int len = parent.length();
        if (len < 9) {
            throw new ParsingException("Failed to uninvert CAS ester");
        }
        char lastChar = parent.charAt(len - 1);
        if (lastChar == ')' || lastChar == ']' || lastChar == '}') {
            if (parent.substring(parent.length() - 8).equalsIgnoreCase("ic acid)")) {
                return parent.substring(0, parent.length() - 8) + "ate)";
            }
            if (!parent.substring(parent.length() - 9).equalsIgnoreCase("ous acid)")) throw new ParsingException("Failed to uninvert CAS ester");
            return parent.substring(0, parent.length() - 9) + "ite)";
        }
        if (parent.substring(parent.length() - 7).equalsIgnoreCase("ic acid")) {
            return parent.substring(0, parent.length() - 7) + "ate";
        }
        if (!parent.substring(parent.length() - 8).equalsIgnoreCase("ous acid")) throw new ParsingException("Failed to uninvert CAS ester");
        return parent.substring(0, parent.length() - 8) + "ite";
    }
}

