/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import nu.xom.Element;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.BuildState;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.FunctionalAtom;
import uk.ac.cam.ch.wwmm.opsin.OutAtom;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingException;
import uk.ac.cam.ch.wwmm.opsin.XOMTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BuildResults {
    private final LinkedList<OutAtom> outAtoms = new LinkedList();
    private final LinkedList<FunctionalAtom> functionalAtoms = new LinkedList();
    private final LinkedHashSet<Fragment> fragments = new LinkedHashSet();

    BuildResults(BuildState state, Element wordSubOrBracket) {
        List<Element> groups = XOMTools.getDescendantElementsWithTagName(wordSubOrBracket, "group");
        for (Element group : groups) {
            Fragment frag = state.xmlFragmentMap.get(group);
            this.fragments.add(frag);
            this.outAtoms.addAll(frag.getOutAtoms());
            this.functionalAtoms.addAll(frag.getFunctionalAtoms());
        }
    }

    BuildResults() {
    }

    Set<Fragment> getFragments() {
        return Collections.unmodifiableSet(this.fragments);
    }

    int getFragmentCount() {
        return this.fragments.size();
    }

    Atom getOutAtomTakingIntoAccountWhetherSetExplicitly(int i) throws StructureBuildingException {
        OutAtom outAtom = this.outAtoms.get(i);
        if (outAtom.isSetExplicitly()) {
            return outAtom.getAtom();
        }
        return outAtom.getAtom().getFrag().getAtomOrNextSuitableAtomOrThrow(outAtom.getAtom(), outAtom.getValency(), false);
    }

    OutAtom getOutAtom(int i) {
        return this.outAtoms.get(i);
    }

    int getOutAtomCount() {
        return this.outAtoms.size();
    }

    OutAtom removeOutAtom(int i) {
        OutAtom outAtom = this.outAtoms.get(i);
        outAtom.getAtom().getFrag().removeOutAtom(outAtom);
        return this.outAtoms.remove(i);
    }

    void removeAllOutAtoms() {
        for (int i = this.outAtoms.size() - 1; i >= 0; --i) {
            this.removeOutAtom(i);
        }
    }

    Atom getFunctionalAtom(int i) {
        return this.functionalAtoms.get(i).getAtom();
    }

    FunctionalAtom removeFunctionalAtom(int i) {
        FunctionalAtom functionalAtom = this.functionalAtoms.get(i);
        functionalAtom.getAtom().getFrag().removeFunctionalAtom(functionalAtom);
        return this.functionalAtoms.remove(i);
    }

    int getFunctionalAtomCount() {
        return this.functionalAtoms.size();
    }

    OutAtom getFirstOutAtom() {
        return this.outAtoms.get(0);
    }

    Atom getAtomByIdOrThrow(int id) throws StructureBuildingException {
        for (Fragment fragment : this.fragments) {
            Atom outAtom = fragment.getAtomByID(id);
            if (outAtom == null) continue;
            return outAtom;
        }
        throw new StructureBuildingException("No fragment contained this id: " + id);
    }

    void mergeBuildResults(BuildResults otherBR) {
        this.outAtoms.addAll(otherBR.outAtoms);
        this.functionalAtoms.addAll(otherBR.functionalAtoms);
        this.fragments.addAll(otherBR.fragments);
    }

    int getCharge() {
        int totalCharge = 0;
        for (Fragment frag : this.fragments) {
            totalCharge += frag.getCharge();
        }
        return totalCharge;
    }
}

