/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import nu.xom.Attribute;
import nu.xom.Element;
import uk.ac.cam.ch.wwmm.opsin.Atom;

class BondStereo {
    private Atom[] atomRefs4;
    private BondStereoValue bondStereoValue;

    BondStereo(Atom[] atomRefs4, BondStereoValue cOrT) {
        if (atomRefs4.length != 4) {
            throw new IllegalArgumentException("atomRefs4 must contain references to 4 atoms");
        }
        this.atomRefs4 = atomRefs4;
        this.bondStereoValue = cOrT;
    }

    Element toCML() {
        Element bondStereoElement = new Element("bondStereo", "http://www.xml-cml.org/schema");
        StringBuilder atomRefsSb = new StringBuilder();
        for (int i = 0; i < this.atomRefs4.length - 1; ++i) {
            atomRefsSb.append('a');
            atomRefsSb.append(this.atomRefs4[i].getID());
            atomRefsSb.append(' ');
        }
        atomRefsSb.append('a');
        atomRefsSb.append(this.atomRefs4[this.atomRefs4.length - 1].getID());
        bondStereoElement.addAttribute(new Attribute("atomRefs4", atomRefsSb.toString()));
        bondStereoElement.appendChild(this.bondStereoValue.toString());
        return bondStereoElement;
    }

    Atom[] getAtomRefs4() {
        return this.atomRefs4;
    }

    void setAtomRefs4(Atom[] atomRefs4) {
        this.atomRefs4 = atomRefs4;
    }

    BondStereoValue getBondStereoValue() {
        return this.bondStereoValue;
    }

    void setBondStereoValue(BondStereoValue bondStereoValue) {
        this.bondStereoValue = bondStereoValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum BondStereoValue {
        CIS("C"),
        TRANS("T");

        private final String value;

        private BondStereoValue(String value2) {
            this.value = value2;
        }

        public String toString() {
            return this.value;
        }
    }
}

