/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.List;
import nu.xom.Attribute;
import nu.xom.Element;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.BondStereo;
import uk.ac.cam.ch.wwmm.opsin.Ring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Bond {
    private final Atom from;
    private final Atom to;
    private int order;
    private SMILES_BOND_DIRECTION smilesBondDirection = null;
    private BondStereo bondStereo = null;
    private final List<Ring> fusedRings = new ArrayList<Ring>(2);

    Bond(Atom from2, Atom to2, int order) {
        this.from = from2;
        this.to = to2;
        this.order = order;
    }

    List<Ring> getFusedRings() {
        return this.fusedRings;
    }

    void addFusedRing(Ring ring) {
        if (this.fusedRings.size() < 2) {
            this.fusedRings.add(ring);
        }
    }

    Element toCMLBond() {
        Element elem2 = new Element("bond", "http://www.xml-cml.org/schema");
        elem2.addAttribute(new Attribute("id", "a" + Integer.toString(this.from.getID()) + "_a" + Integer.toString(this.to.getID())));
        elem2.addAttribute(new Attribute("atomRefs2", "a" + Integer.toString(this.from.getID()) + " a" + Integer.toString(this.to.getID())));
        if (this.order == 1) {
            elem2.addAttribute(new Attribute("order", "S"));
        } else if (this.order == 2) {
            elem2.addAttribute(new Attribute("order", "D"));
        } else if (this.order == 3) {
            elem2.addAttribute(new Attribute("order", "T"));
        } else {
            elem2.addAttribute(new Attribute("order", "unknown"));
        }
        if (this.bondStereo != null) {
            elem2.appendChild(this.bondStereo.toCML());
        }
        return elem2;
    }

    int getFrom() {
        return this.from.getID();
    }

    int getTo() {
        return this.to.getID();
    }

    int getOrder() {
        return this.order;
    }

    void setOrder(int order) {
        this.order = order;
    }

    Atom getFromAtom() {
        return this.from;
    }

    Atom getToAtom() {
        return this.to;
    }

    void addOrder(int o) {
        this.order += o;
    }

    SMILES_BOND_DIRECTION getSmilesStereochemistry() {
        return this.smilesBondDirection;
    }

    void setSmilesStereochemistry(SMILES_BOND_DIRECTION bondDirection) {
        this.smilesBondDirection = bondDirection;
    }

    BondStereo getBondStereo() {
        return this.bondStereo;
    }

    void setBondStereo(BondStereo bondStereo) {
        this.bondStereo = bondStereo;
    }

    void setBondStereoElement(Atom[] atomRefs4, BondStereo.BondStereoValue cOrT) {
        this.bondStereo = new BondStereo(atomRefs4, cOrT);
    }

    Atom getOtherAtom(Atom atom) {
        if (this.from == atom) {
            return this.to;
        }
        if (this.to == atom) {
            return this.from;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SMILES_BOND_DIRECTION {
        RSLASH,
        LSLASH;

    }
}

