/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.RunAutomaton;
import dk.brics.automaton.SpecialOperations;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import uk.ac.cam.ch.wwmm.opsin.ResourceGetter;

class AutomatonInitialiser {
    private static final Logger LOG = Logger.getLogger(AutomatonInitialiser.class);
    private static final ResourceGetter resourceGetter = new ResourceGetter("uk/ac/cam/ch/wwmm/opsin/resources/serialisedAutomata/");

    AutomatonInitialiser() {
    }

    static RunAutomaton loadAutomaton(String automatonName, String regex, boolean tableize, boolean reverseAutomaton) {
        if (reverseAutomaton) {
            automatonName = automatonName + "_reversed_";
        }
        try {
            if (AutomatonInitialiser.isAutomatonCached(automatonName, regex)) {
                return AutomatonInitialiser.loadCachedAutomaton(automatonName);
            }
        }
        catch (IOException e) {
            LOG.warn("Error loading cached automaton: " + automatonName, e);
        }
        RunAutomaton automaton = AutomatonInitialiser.createAutomaton(regex, tableize, reverseAutomaton);
        AutomatonInitialiser.cacheAutomaton(automatonName, automaton, regex);
        return automaton;
    }

    private static boolean isAutomatonCached(String automatonName, String regex) {
        String currentRegexHash = AutomatonInitialiser.getRegexHash(regex);
        String cachedRegexHash = AutomatonInitialiser.getCachedRegexHash(automatonName);
        return currentRegexHash.equals(cachedRegexHash);
    }

    private static String getRegexHash(String regex) {
        return Integer.toString(regex.hashCode());
    }

    private static String getCachedRegexHash(String automatonName) {
        return resourceGetter.getFileContentsAsString(automatonName + "RegexHash.txt");
    }

    private static RunAutomaton loadCachedAutomaton(String automatonName) throws IOException {
        InputStream automatonInput = resourceGetter.getInputstreamFromFileName(automatonName + "SerialisedAutomaton.aut");
        try {
            RunAutomaton runAutomaton = RunAutomaton.load(automatonInput);
            return runAutomaton;
        }
        catch (Exception e) {
            IOException ioe = new IOException("Error loading automaton");
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            IOUtils.closeQuietly(automatonInput);
        }
    }

    private static RunAutomaton createAutomaton(String regex, boolean tableize, boolean reverseAutomaton) {
        Automaton a = new RegExp(regex).toAutomaton();
        if (reverseAutomaton) {
            SpecialOperations.reverse(a);
        }
        RunAutomaton ra = new RunAutomaton(a, tableize);
        return ra;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheAutomaton(String automatonName, RunAutomaton automaton, String regex) {
        OutputStream regexHashOutputStream = null;
        OutputStream automatonOutputStream = null;
        try {
            regexHashOutputStream = resourceGetter.getOutputStream(automatonName + "RegexHash.txt");
            try {
                regexHashOutputStream.write(AutomatonInitialiser.getRegexHash(regex).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Java VM is broken; UTF-8 should be supported", e);
            }
            automatonOutputStream = resourceGetter.getOutputStream(automatonName + "SerialisedAutomaton.aut");
            automaton.store(automatonOutputStream);
        }
        catch (IOException e) {
            try {
                LOG.warn("Error serialising automaton: " + automatonName, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(regexHashOutputStream);
                IOUtils.closeQuietly(automatonOutputStream);
                throw throwable;
            }
            IOUtils.closeQuietly(regexHashOutputStream);
            IOUtils.closeQuietly(automatonOutputStream);
        }
        IOUtils.closeQuietly(regexHashOutputStream);
        IOUtils.closeQuietly(automatonOutputStream);
    }
}

