/*
 * Decompiled with CFR 0.152.
 */
package org.uimafit.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtil {
    public static List<Field> getFields(Object object) {
        Class<?> cls = object.getClass();
        return ReflectionUtil.getFields(cls);
    }

    public static List<Field> getFields(Class<?> cls) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (!cls.equals(Object.class)) {
            Field[] flds = cls.getDeclaredFields();
            fields.addAll(Arrays.asList(flds));
            cls = cls.getSuperclass();
        }
        return fields;
    }

    public static <T extends Annotation> T getInheritableAnnotation(Class<T> aAnnotation, Class<?> aClass) {
        if (aClass.isAnnotationPresent(aAnnotation)) {
            return aClass.getAnnotation(aAnnotation);
        }
        if (aClass.getSuperclass() != null) {
            return ReflectionUtil.getInheritableAnnotation(aAnnotation, aClass.getSuperclass());
        }
        return null;
    }
}

