/*
 * Decompiled with CFR 0.152.
 */
package org.uimafit.util;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.uimafit.util.CasUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCasUtil {
    public static <T extends AnnotationFS> Iterable<T> iterate(final JCas jCas, final Class<T> type) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return JCasUtil.iterator(jCas, type);
            }
        };
    }

    public static <T extends Annotation> Iterable<T> iterate(Class<T> type, Annotation container) {
        return JCasUtil.selectCovered(type, container);
    }

    public static <T extends Annotation> Iterable<T> iterate(JCas jCas, Class<T> type, Annotation container) {
        return JCasUtil.selectCovered(jCas, type, container);
    }

    public static <T extends Annotation> Iterable<T> subiterate(JCas jCas, final Class<T> type, final Annotation container, final boolean ambiguous, final boolean strict) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return JCasUtil.iterator(container, type, ambiguous, strict);
            }
        };
    }

    public static <T extends AnnotationFS> Iterator<T> iterator(JCas jCas, Class<T> type) {
        return jCas.getAnnotationIndex(JCasUtil.getType(jCas, type)).iterator();
    }

    public static <T extends AnnotationFS> Iterator<T> iterator(Annotation container, Class<T> type, boolean ambiguous, boolean strict) {
        CAS cas = container.getCAS();
        return cas.getAnnotationIndex(CasUtil.getType(cas, type)).subiterator(container, ambiguous, strict);
    }

    public static Type getType(JCas jCas, Class<?> type) {
        return CasUtil.getType(jCas.getCas(), type);
    }

    public static <T extends AnnotationFS> Collection<T> select(final JCas jCas, final Class<T> type) {
        return new AbstractCollection<T>(){
            AnnotationIndex<T> index;
            {
                this.index = jCas.getAnnotationIndex(JCasUtil.getType(jCas, type));
            }

            @Override
            public Iterator<T> iterator() {
                return this.index.iterator();
            }

            @Override
            public int size() {
                return this.index.size();
            }
        };
    }

    public static <T extends AnnotationFS> List<T> selectCovered(Class<T> type, AnnotationFS coveringAnnotation) {
        CAS cas = coveringAnnotation.getCAS();
        return CasUtil.selectCovered(cas, CasUtil.getType(cas, type), coveringAnnotation);
    }

    public static <T extends Annotation> List<T> selectCovered(JCas jCas, Class<T> type, Annotation coveringAnnotation) {
        return CasUtil.selectCovered(jCas.getCas(), JCasUtil.getType(jCas, type), coveringAnnotation);
    }

    public static boolean isCovered(JCas jCas, Annotation coveringAnnotation, Class<? extends Annotation> type) {
        return JCasUtil.selectCovered(jCas, type, coveringAnnotation).size() > 0;
    }

    public static <T extends Annotation> T selectByIndex(JCas jCas, Class<T> cls, int index) {
        int n;
        FSIterator i = jCas.getAnnotationIndex(JCasUtil.getType(jCas, cls)).iterator();
        i.moveToFirst();
        if (n > 0) {
            for (n = index; n > 0 && i.isValid(); --n) {
                i.moveToNext();
            }
        }
        if (n < 0) {
            i.moveToLast();
            while (n < -1 && i.isValid()) {
                i.moveToPrevious();
                ++n;
            }
        }
        return (T)(i.isValid() ? (Annotation)i.get() : null);
    }

    public static <T extends FeatureStructure> T selectSingle(JCas jCas, Class<T> type) {
        FSIterator<FeatureStructure> iterator2 = jCas.getIndexRepository().getAllIndexedFS(JCasUtil.getType(jCas, type));
        if (!iterator2.hasNext()) {
            throw new IllegalArgumentException("CAS does not contain any " + type.getName());
        }
        FeatureStructure result2 = (FeatureStructure)iterator2.next();
        if (iterator2.hasNext()) {
            throw new IllegalArgumentException("CAS contains more than one " + type.getName());
        }
        return (T)result2;
    }

    public static <T extends Annotation> List<T> selectPreceding(JCas aJCas, Class<T> aType, Annotation annotation, int count2) {
        Type t = aJCas.getTypeSystem().getType(aType.getName());
        return CasUtil.selectPreceding(aJCas.getCas(), t, annotation, count2);
    }

    public static <T extends Annotation> List<T> selectFollowing(JCas aJCas, Class<T> aType, Annotation annotation, int count2) {
        Type t = aJCas.getTypeSystem().getType(aType.getName());
        return CasUtil.selectFollowing(aJCas.getCas(), t, annotation, count2);
    }

    public static <T extends AnnotationFS> boolean exists(JCas aJCas, Class<T> aType) {
        return JCasUtil.iterator(aJCas, aType).hasNext();
    }

    public static JCas getView(JCas aJCas, String viewName, JCas fallback) {
        JCas view;
        try {
            view = aJCas.getView(viewName);
        }
        catch (CASException e) {
            view = fallback;
        }
        catch (CASRuntimeException e) {
            view = fallback;
        }
        return view;
    }

    public static JCas getView(JCas aJCas, String viewName, boolean aCreate) throws AnalysisEngineProcessException {
        JCas view = null;
        try {
            view = aJCas.getView(viewName);
        }
        catch (CASException e) {
        }
        catch (CASRuntimeException e) {
            // empty catch block
        }
        if (view == null && aCreate) {
            try {
                view = aJCas.createView(viewName);
            }
            catch (CASException e) {
                new AnalysisEngineProcessException(e);
            }
        }
        if (view == null) {
            throw new AnalysisEngineProcessException(new IllegalStateException("No view with name [" + viewName + "]"));
        }
        return view;
    }

    public static <T extends AnnotationFS> List<String> toText(Iterable<T> iterable) {
        ArrayList<String> text2 = new ArrayList<String>();
        for (AnnotationFS a : iterable) {
            text2.add(a.getCoveredText());
        }
        return text2;
    }
}

