/*
 * Decompiled with CFR 0.152.
 */
package org.uimafit.factory.initializable;

import org.apache.uima.UimaContext;
import org.apache.uima.resource.ResourceInitializationException;
import org.uimafit.factory.initializable.Initializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InitializableFactory {
    private InitializableFactory() {
    }

    public static <T> T create(UimaContext context, String className, Class<T> superClass) throws ResourceInitializationException {
        Class<T> cls = InitializableFactory.getClass(className, superClass);
        return InitializableFactory.create(context, cls);
    }

    public static <T> Class<? extends T> getClass(String className, Class<T> superClass) throws ResourceInitializationException {
        try {
            Class<T> cls = Class.forName(className).asSubclass(superClass);
            return cls;
        }
        catch (Exception e) {
            throw new ResourceInitializationException(new Throwable("classname = " + className + " superClass = " + superClass.getName(), e));
        }
    }

    public static <T> T create(UimaContext context, Class<? extends T> cls) throws ResourceInitializationException {
        T instance;
        try {
            instance = cls.newInstance();
        }
        catch (Exception e) {
            throw new ResourceInitializationException(e);
        }
        InitializableFactory.initialize(instance, context);
        return instance;
    }

    public static void initialize(Object object, UimaContext context) throws ResourceInitializationException {
        if (object instanceof Initializable) {
            ((Initializable)object).initialize(context);
        }
    }
}

