/*
 * Decompiled with CFR 0.152.
 */
package org.uimafit.factory;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.LogFactory;
import org.apache.uima.UIMAFramework;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.resource.metadata.impl.Import_impl;
import org.apache.uima.resource.metadata.impl.TypeSystemDescription_impl;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeSystemDescriptionFactory {
    public static final String TYPE_IMPORT_PATTERN = "org.uimafit.type.import_pattern";
    public static final String TYPE_MANIFEST_PATTERN = "classpath*:META-INF/org.uimafit/types.txt";
    private static String[] typeDescriptorLocations;

    private TypeSystemDescriptionFactory() {
    }

    public static TypeSystemDescription createTypeSystemDescription(Class<?> ... typeSystemClasses) {
        TypeSystemDescription_impl typeSystem = new TypeSystemDescription_impl();
        ArrayList<Import_impl> imports = new ArrayList<Import_impl>();
        for (Class<?> typeSystemClass : typeSystemClasses) {
            Import_impl imprt = new Import_impl();
            imprt.setName(typeSystemClass.getName());
            imports.add(imprt);
        }
        Import[] importArray = new Import[imports.size()];
        typeSystem.setImports(imports.toArray(importArray));
        return typeSystem;
    }

    public static TypeSystemDescription createTypeSystemDescription(String ... descriptorNames) {
        TypeSystemDescription_impl typeSystem = new TypeSystemDescription_impl();
        ArrayList<Import_impl> imports = new ArrayList<Import_impl>();
        for (String descriptorName : descriptorNames) {
            Import_impl imp = new Import_impl();
            imp.setName(descriptorName);
            imports.add(imp);
        }
        Import[] importArray = new Import[imports.size()];
        typeSystem.setImports(imports.toArray(importArray));
        return typeSystem;
    }

    public static TypeSystemDescription createTypeSystemDescriptionFromPath(String ... descriptorURIs) {
        TypeSystemDescription_impl typeSystem = new TypeSystemDescription_impl();
        ArrayList<Import_impl> imports = new ArrayList<Import_impl>();
        for (String descriptorURI : descriptorURIs) {
            Import_impl imp = new Import_impl();
            imp.setLocation(descriptorURI);
            imports.add(imp);
        }
        Import[] importArray = new Import[imports.size()];
        typeSystem.setImports(imports.toArray(importArray));
        return typeSystem;
    }

    public static TypeSystemDescription createTypeSystemDescription() throws ResourceInitializationException {
        ArrayList<TypeSystemDescription> tsdList = new ArrayList<TypeSystemDescription>();
        for (String location : TypeSystemDescriptionFactory.scanTypeDescriptors()) {
            try {
                XMLInputSource xmlInputType1 = new XMLInputSource(location);
                tsdList.add(UIMAFramework.getXMLParser().parseTypeSystemDescription(xmlInputType1));
                LogFactory.getLog(TypeSystemDescription.class).debug("Detected type system at [" + location + "]");
            }
            catch (IOException e) {
                throw new ResourceInitializationException(e);
            }
            catch (InvalidXMLException e) {
                LogFactory.getLog(TypeSystemDescription.class).warn("[" + location + "] is not a type file. Ignoring.", e);
            }
        }
        return CasCreationUtils.mergeTypeSystems(tsdList);
    }

    public static String[] scanTypeDescriptors() throws ResourceInitializationException {
        block5: {
            if (typeDescriptorLocations != null) break block5;
            ArrayList<String> patterns = new ArrayList<String>();
            patterns.addAll(Arrays.asList(System.getProperty(TYPE_IMPORT_PATTERN, "").split(";")));
            for (String mfUrl : TypeSystemDescriptionFactory.resolve(TYPE_MANIFEST_PATTERN)) {
                InputStream is = null;
                try {
                    is = new URL(mfUrl).openStream();
                    List<String> lines2 = IOUtils.readLines(is);
                    patterns.addAll(lines2);
                }
                catch (IOException e) {
                    try {
                        throw new ResourceInitializationException(e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly(is);
            }
            String[] patternsArray = patterns.toArray(new String[patterns.size()]);
            typeDescriptorLocations = TypeSystemDescriptionFactory.resolve(patternsArray);
        }
        return typeDescriptorLocations;
    }

    public static void forceTypeDescriptorsScan() {
        typeDescriptorLocations = null;
    }

    public static String[] resolve(String ... patterns) throws ResourceInitializationException {
        HashSet<String> locations = new HashSet<String>();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            for (String pattern : new TreeSet<String>(Arrays.asList(patterns))) {
                String p = pattern.trim();
                if (p.length() == 0) continue;
                for (Resource r : resolver.getResources(pattern)) {
                    locations.add(r.getURL().toString());
                }
            }
            return locations.toArray(new String[locations.size()]);
        }
        catch (IOException e) {
            throw new ResourceInitializationException(e);
        }
    }
}

