/*
 * Decompiled with CFR 0.152.
 */
package org.uimafit.factory;

import java.io.IOException;
import java.net.URL;
import org.apache.uima.UIMAException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;
import org.uimafit.factory.ConfigurationParameterFactory;

public final class ResourceCreationSpecifierFactory {
    private ResourceCreationSpecifierFactory() {
    }

    public static ResourceCreationSpecifier createResourceCreationSpecifier(URL descriptorURL, Object[] parameters) throws UIMAException, IOException {
        return ResourceCreationSpecifierFactory.createResourceCreationSpecifier(new XMLInputSource(descriptorURL), parameters);
    }

    public static ResourceCreationSpecifier createResourceCreationSpecifier(XMLInputSource xmlInput, Object[] parameters) throws UIMAException, IOException {
        if (parameters.length % 2 != 0) {
            String message = "a value must be specified for each parameter name: an odd number of values passed in (" + parameters.length + ")";
            throw new IllegalArgumentException(message);
        }
        XMLParser parser = UIMAFramework.getXMLParser();
        ResourceCreationSpecifier specifier = (ResourceCreationSpecifier)parser.parseResourceSpecifier(xmlInput);
        ResourceCreationSpecifierFactory.setConfigurationParameters(specifier, parameters);
        return specifier;
    }

    public static ResourceCreationSpecifier createResourceCreationSpecifier(String descriptorPath, Object[] parameters) throws UIMAException, IOException {
        return ResourceCreationSpecifierFactory.createResourceCreationSpecifier(new XMLInputSource(descriptorPath), parameters);
    }

    public static void setConfigurationParameters(ResourceCreationSpecifier specifier, Object ... configurationData) {
        if (configurationData.length % 2 != 0) {
            String message = "a value must be specified for each parameter name: an odd number of values passed in (" + configurationData.length + ")";
            throw new IllegalArgumentException(message);
        }
        ConfigurationParameter[] configurationParameters = new ConfigurationParameter[configurationData.length / 2];
        Object[] configurationValues = new Object[configurationData.length / 2];
        for (int i = 0; i < configurationValues.length; ++i) {
            ConfigurationParameter param2;
            String name = (String)configurationData[i * 2];
            Object value2 = configurationData[i * 2 + 1];
            configurationParameters[i] = param2 = ConfigurationParameterFactory.createPrimitiveParameter(name, value2.getClass(), null, false);
            configurationValues[i] = value2;
        }
        ResourceCreationSpecifierFactory.setConfigurationParameters(specifier, configurationParameters, configurationValues);
    }

    public static void setConfigurationParameters(ResourceCreationSpecifier specifier, ConfigurationParameter[] configurationParameters, Object[] configurationValues) {
        ResourceCreationSpecifierFactory.setConfigurationParameters(specifier.getMetaData(), configurationParameters, configurationValues);
    }

    public static void setConfigurationParameters(ResourceMetaData metaData, ConfigurationParameter[] configurationParameters, Object[] configurationValues) {
        ConfigurationParameterDeclarations paramDecls = metaData.getConfigurationParameterDeclarations();
        ConfigurationParameterSettings paramSettings = metaData.getConfigurationParameterSettings();
        for (int i = 0; i < configurationParameters.length; ++i) {
            if (paramDecls != null && paramDecls.getConfigurationParameter(null, configurationParameters[i].getName()) == null) {
                paramDecls.addConfigurationParameter(configurationParameters[i]);
            }
            paramSettings.setParameterValue(configurationParameters[i].getName(), configurationValues[i]);
        }
    }
}

