/*
 * Decompiled with CFR 0.152.
 */
package org.uimafit.factory;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.uima.UIMAException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_component.AnalysisComponent;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.impl.AggregateAnalysisEngine_impl;
import org.apache.uima.analysis_engine.impl.AnalysisEngineDescription_impl;
import org.apache.uima.analysis_engine.impl.PrimitiveAnalysisEngine_impl;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.analysis_engine.metadata.SofaMapping;
import org.apache.uima.analysis_engine.metadata.impl.FixedFlow_impl;
import org.apache.uima.analysis_engine.metadata.impl.FlowControllerDeclaration_impl;
import org.apache.uima.flow.FlowControllerDescription;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ExternalResourceDependency;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.resource.metadata.impl.Import_impl;
import org.apache.uima.util.FileUtils;
import org.uimafit.component.initialize.ExternalResourceInitializer;
import org.uimafit.descriptor.OperationalProperties;
import org.uimafit.factory.AggregateBuilder;
import org.uimafit.factory.CapabilityFactory;
import org.uimafit.factory.ConfigurationParameterFactory;
import org.uimafit.factory.ResourceCreationSpecifierFactory;
import org.uimafit.factory.TypePrioritiesFactory;
import org.uimafit.factory.TypeSystemDescriptionFactory;
import org.uimafit.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnalysisEngineFactory {
    private AnalysisEngineFactory() {
    }

    public static AnalysisEngine createAnalysisEngine(String descriptorName, Object ... configurationData) throws UIMAException, IOException {
        AnalysisEngineDescription aed = AnalysisEngineFactory.createAnalysisEngineDescription(descriptorName, configurationData);
        return UIMAFramework.produceAnalysisEngine(aed);
    }

    public static AnalysisEngineDescription createAnalysisEngineDescription(String descriptorName, Object ... configurationData) throws UIMAException, IOException {
        Import_impl imprt = new Import_impl();
        imprt.setName(descriptorName);
        URL url = imprt.findAbsoluteUrl(UIMAFramework.newDefaultResourceManager());
        ResourceCreationSpecifier specifier = ResourceCreationSpecifierFactory.createResourceCreationSpecifier(url, configurationData);
        return (AnalysisEngineDescription)specifier;
    }

    public static AnalysisEngine createAnalysisEngine(AnalysisEngineDescription analysisEngineDescription, String viewName) throws ResourceInitializationException {
        AggregateBuilder builder = new AggregateBuilder();
        builder.add(analysisEngineDescription, "_InitialView", viewName);
        return builder.createAggregate();
    }

    public static AnalysisEngine createAnalysisEngineFromPath(String descriptorPath, Object ... configurationData) throws UIMAException, IOException {
        ResourceCreationSpecifier specifier = ResourceCreationSpecifierFactory.createResourceCreationSpecifier(descriptorPath, configurationData);
        return UIMAFramework.produceAnalysisEngine(specifier);
    }

    public static AnalysisEngine createPrimitive(Class<? extends AnalysisComponent> componentClass, Object ... configurationData) throws ResourceInitializationException {
        TypeSystemDescription tsd = TypeSystemDescriptionFactory.createTypeSystemDescription();
        return AnalysisEngineFactory.createPrimitive(componentClass, tsd, (TypePriorities)null, configurationData);
    }

    public static AnalysisEngine createPrimitive(Class<? extends AnalysisComponent> componentClass, TypeSystemDescription typeSystem, Object ... configurationData) throws ResourceInitializationException {
        return AnalysisEngineFactory.createPrimitive(componentClass, typeSystem, (TypePriorities)null, configurationData);
    }

    public static AnalysisEngine createPrimitive(Class<? extends AnalysisComponent> componentClass, TypeSystemDescription typeSystem, String[] prioritizedTypeNames, Object ... configurationData) throws ResourceInitializationException {
        TypePriorities typePriorities = TypePrioritiesFactory.createTypePriorities(prioritizedTypeNames);
        return AnalysisEngineFactory.createPrimitive(componentClass, typeSystem, typePriorities, configurationData);
    }

    public static AnalysisEngineDescription createPrimitiveDescription(Class<? extends AnalysisComponent> componentClass, TypeSystemDescription typeSystem, Object ... configurationData) throws ResourceInitializationException {
        return AnalysisEngineFactory.createPrimitiveDescription(componentClass, typeSystem, (TypePriorities)null, configurationData);
    }

    public static AnalysisEngineDescription createPrimitiveDescription(Class<? extends AnalysisComponent> componentClass, Object ... configurationData) throws ResourceInitializationException {
        TypeSystemDescription tsd = TypeSystemDescriptionFactory.createTypeSystemDescription();
        return AnalysisEngineFactory.createPrimitiveDescription(componentClass, tsd, (TypePriorities)null, configurationData);
    }

    public static AnalysisEngineDescription createPrimitiveDescription(Class<? extends AnalysisComponent> componentClass, TypeSystemDescription typeSystem, TypePriorities typePriorities, Object ... configurationData) throws ResourceInitializationException {
        return AnalysisEngineFactory.createPrimitiveDescription(componentClass, typeSystem, typePriorities, (Capability[])null, configurationData);
    }

    public static AnalysisEngineDescription createPrimitiveDescription(Class<? extends AnalysisComponent> componentClass, TypeSystemDescription typeSystem, TypePriorities typePriorities, Capability[] capabilities, Object ... configurationData) throws ResourceInitializationException {
        ConfigurationParameterFactory.ConfigurationData cdata = ConfigurationParameterFactory.createConfigurationData(configurationData);
        return AnalysisEngineFactory.createPrimitiveDescription(componentClass, typeSystem, typePriorities, capabilities, cdata.configurationParameters, cdata.configurationValues);
    }

    public static AnalysisEngineDescription createPrimitiveDescription(Class<? extends AnalysisComponent> componentClass, TypeSystemDescription typeSystem, TypePriorities typePriorities, Capability[] capabilities, ConfigurationParameter[] configurationParameters, Object[] configurationValues) throws ResourceInitializationException {
        Capability capability;
        org.apache.uima.resource.metadata.OperationalProperties op;
        AnalysisEngineDescription_impl desc = new AnalysisEngineDescription_impl();
        desc.setFrameworkImplementation("org.apache.uima.java");
        desc.setPrimitive(true);
        desc.setAnnotatorImplementationName(componentClass.getName());
        OperationalProperties componentAnno = ReflectionUtil.getInheritableAnnotation(OperationalProperties.class, componentClass);
        if (componentAnno != null) {
            op = desc.getAnalysisEngineMetaData().getOperationalProperties();
            op.setMultipleDeploymentAllowed(componentAnno.multipleDeploymentAllowed());
            op.setModifiesCas(componentAnno.modifiesCas());
            op.setOutputsNewCASes(componentAnno.outputsNewCases());
        } else {
            op = desc.getAnalysisEngineMetaData().getOperationalProperties();
            op.setMultipleDeploymentAllowed(true);
            op.setModifiesCas(true);
            op.setOutputsNewCASes(false);
        }
        AnalysisEngineMetaData meta = desc.getAnalysisEngineMetaData();
        meta.setName(componentClass.getName());
        meta.setVendor(componentClass.getPackage().getName());
        meta.setDescription("Descriptor automatically generated by uimaFIT");
        meta.setVersion("unknown");
        Collection<ExternalResourceDependency> deps = ExternalResourceInitializer.getResourceDeclarations(componentClass).values();
        desc.setExternalResourceDependencies(deps.toArray(new ExternalResourceDependency[deps.size()]));
        ConfigurationParameterFactory.ConfigurationData reflectedConfigurationData = ConfigurationParameterFactory.createConfigurationData(componentClass);
        ResourceCreationSpecifierFactory.setConfigurationParameters((ResourceCreationSpecifier)desc, reflectedConfigurationData.configurationParameters, reflectedConfigurationData.configurationValues);
        if (configurationParameters != null) {
            ResourceCreationSpecifierFactory.setConfigurationParameters((ResourceCreationSpecifier)desc, configurationParameters, configurationValues);
        }
        if (typeSystem != null) {
            desc.getAnalysisEngineMetaData().setTypeSystem(typeSystem);
        }
        if (typePriorities != null) {
            desc.getAnalysisEngineMetaData().setTypePriorities(typePriorities);
        }
        if (capabilities == null && (capability = CapabilityFactory.createCapability(componentClass)) != null) {
            capabilities = new Capability[]{capability};
        }
        if (capabilities != null) {
            desc.getAnalysisEngineMetaData().setCapabilities(capabilities);
        }
        return desc;
    }

    public static void setConfigurationParameters(AnalysisEngineDescription analysisEngineDescription, Object ... configurationData) throws ResourceInitializationException {
        ConfigurationParameterFactory.ConfigurationData cdata = ConfigurationParameterFactory.createConfigurationData(configurationData);
        ResourceCreationSpecifierFactory.setConfigurationParameters((ResourceCreationSpecifier)analysisEngineDescription, cdata.configurationParameters, cdata.configurationValues);
    }

    public static AnalysisEngine createPrimitive(Class<? extends AnalysisComponent> componentClass, TypeSystemDescription typeSystem, TypePriorities typePriorities, Object ... configurationParameters) throws ResourceInitializationException {
        AnalysisEngineDescription desc = AnalysisEngineFactory.createPrimitiveDescription(componentClass, typeSystem, typePriorities, configurationParameters);
        return AnalysisEngineFactory.createPrimitive(desc, new Object[0]);
    }

    public static AnalysisEngine createPrimitive(AnalysisEngineDescription desc, Object ... configurationData) throws ResourceInitializationException {
        PrimitiveAnalysisEngine_impl engine = new PrimitiveAnalysisEngine_impl();
        if (configurationData != null) {
            ConfigurationParameterFactory.ConfigurationData cdata = ConfigurationParameterFactory.createConfigurationData(configurationData);
            ConfigurationParameter[] configurationParameters = cdata.configurationParameters;
            Object[] configurationValues = cdata.configurationValues;
            ResourceCreationSpecifierFactory.setConfigurationParameters((ResourceCreationSpecifier)desc, configurationParameters, configurationValues);
            ResourceMetaData metaData = desc.getMetaData();
            ConfigurationParameterSettings paramSettings = metaData.getConfigurationParameterSettings();
            HashMap<String, Object> additionalParameters = new HashMap<String, Object>();
            additionalParameters.put("CONFIG_PARAM_SETTINGS", paramSettings);
            engine.initialize(desc, additionalParameters);
        } else {
            engine.initialize(desc, null);
        }
        return engine;
    }

    public static AnalysisEngine createAggregate(List<Class<? extends AnalysisComponent>> componentClasses, TypeSystemDescription typeSystem, TypePriorities typePriorities, SofaMapping[] sofaMappings, Object ... configurationParameters) throws ResourceInitializationException {
        AnalysisEngineDescription desc = AnalysisEngineFactory.createAggregateDescription(componentClasses, typeSystem, typePriorities, sofaMappings, configurationParameters);
        AggregateAnalysisEngine_impl engine = new AggregateAnalysisEngine_impl();
        engine.initialize(desc, null);
        return engine;
    }

    public static AnalysisEngine createAggregate(List<Class<? extends AnalysisComponent>> componentClasses, TypeSystemDescription typeSystem, TypePriorities typePriorities, SofaMapping[] sofaMappings, FlowControllerDescription flowControllerDescription, Object ... configurationParameters) throws ResourceInitializationException {
        AnalysisEngineDescription desc = AnalysisEngineFactory.createAggregateDescription(componentClasses, typeSystem, typePriorities, sofaMappings, configurationParameters, flowControllerDescription);
        AggregateAnalysisEngine_impl engine = new AggregateAnalysisEngine_impl();
        engine.initialize(desc, null);
        return engine;
    }

    public static AnalysisEngine createAggregate(AnalysisEngineDescription desc) throws ResourceInitializationException {
        AggregateAnalysisEngine_impl engine = new AggregateAnalysisEngine_impl();
        engine.initialize(desc, null);
        return engine;
    }

    public static AnalysisEngineDescription createAggregateDescription(List<Class<? extends AnalysisComponent>> componentClasses, TypeSystemDescription typeSystem, TypePriorities typePriorities, SofaMapping[] sofaMappings, Object ... configurationParameters) throws ResourceInitializationException {
        ArrayList<AnalysisEngineDescription> primitiveEngineDescriptions = new ArrayList<AnalysisEngineDescription>();
        ArrayList<String> componentNames = new ArrayList<String>();
        for (Class<? extends AnalysisComponent> componentClass : componentClasses) {
            AnalysisEngineDescription primitiveDescription = AnalysisEngineFactory.createPrimitiveDescription(componentClass, typeSystem, typePriorities, configurationParameters);
            primitiveEngineDescriptions.add(primitiveDescription);
            componentNames.add(componentClass.getName());
        }
        return AnalysisEngineFactory.createAggregateDescription(primitiveEngineDescriptions, componentNames, typeSystem, typePriorities, sofaMappings, null);
    }

    public static AnalysisEngine createAggregate(List<AnalysisEngineDescription> analysisEngineDescriptions, List<String> componentNames, TypeSystemDescription typeSystem, TypePriorities typePriorities, SofaMapping[] sofaMappings) throws ResourceInitializationException {
        AnalysisEngineDescription desc = AnalysisEngineFactory.createAggregateDescription(analysisEngineDescriptions, componentNames, typeSystem, typePriorities, sofaMappings, null);
        AggregateAnalysisEngine_impl engine = new AggregateAnalysisEngine_impl();
        engine.initialize(desc, null);
        return engine;
    }

    public static AnalysisEngineDescription createAggregateDescription(AnalysisEngineDescription ... analysisEngineDescriptions) throws ResourceInitializationException {
        String[] names = new String[analysisEngineDescriptions.length];
        int i = 0;
        for (AnalysisEngineDescription aed : analysisEngineDescriptions) {
            names[i] = aed.getImplementationName() + "-" + i;
            ++i;
        }
        return AnalysisEngineFactory.createAggregateDescription(Arrays.asList(analysisEngineDescriptions), Arrays.asList(names), null, null, null, null);
    }

    public static AnalysisEngineDescription createAggregateDescription(List<Class<? extends AnalysisComponent>> componentClasses, TypeSystemDescription typeSystem, TypePriorities typePriorities, SofaMapping[] sofaMappings, FlowControllerDescription flowControllerDescription, Object ... configurationParameters) throws ResourceInitializationException {
        ArrayList<AnalysisEngineDescription> primitiveEngineDescriptions = new ArrayList<AnalysisEngineDescription>();
        ArrayList<String> componentNames = new ArrayList<String>();
        for (Class<? extends AnalysisComponent> componentClass : componentClasses) {
            AnalysisEngineDescription primitiveDescription = AnalysisEngineFactory.createPrimitiveDescription(componentClass, typeSystem, typePriorities, configurationParameters);
            primitiveEngineDescriptions.add(primitiveDescription);
            componentNames.add(componentClass.getName());
        }
        return AnalysisEngineFactory.createAggregateDescription(primitiveEngineDescriptions, componentNames, typeSystem, typePriorities, sofaMappings, flowControllerDescription);
    }

    public static AnalysisEngine createAggregate(List<AnalysisEngineDescription> analysisEngineDescriptions, List<String> componentNames, TypeSystemDescription typeSystem, TypePriorities typePriorities, SofaMapping[] sofaMappings, FlowControllerDescription flowControllerDescription) throws ResourceInitializationException {
        AnalysisEngineDescription desc = AnalysisEngineFactory.createAggregateDescription(analysisEngineDescriptions, componentNames, typeSystem, typePriorities, sofaMappings, flowControllerDescription);
        AggregateAnalysisEngine_impl engine = new AggregateAnalysisEngine_impl();
        engine.initialize(desc, null);
        return engine;
    }

    public static AnalysisEngineDescription createAggregateDescription(FlowControllerDescription flowControllerDescription, AnalysisEngineDescription ... analysisEngineDescriptions) throws ResourceInitializationException {
        String[] names = new String[analysisEngineDescriptions.length];
        int i = 0;
        for (AnalysisEngineDescription aed : analysisEngineDescriptions) {
            names[i] = aed.getImplementationName() + "-" + i;
            ++i;
        }
        return AnalysisEngineFactory.createAggregateDescription(Arrays.asList(analysisEngineDescriptions), Arrays.asList(names), null, null, null, flowControllerDescription);
    }

    public static AnalysisEngineDescription createAggregateDescription(List<AnalysisEngineDescription> analysisEngineDescriptions, List<String> componentNames, TypeSystemDescription typeSystem, TypePriorities typePriorities, SofaMapping[] sofaMappings, FlowControllerDescription flowControllerDescription) throws ResourceInitializationException {
        AnalysisEngineDescription_impl desc = new AnalysisEngineDescription_impl();
        desc.setFrameworkImplementation("org.apache.uima.java");
        desc.setPrimitive(false);
        boolean allowMultipleDeploy = true;
        for (AnalysisEngineDescription d : analysisEngineDescriptions) {
            allowMultipleDeploy &= d.getAnalysisEngineMetaData().getOperationalProperties().isMultipleDeploymentAllowed();
        }
        desc.getAnalysisEngineMetaData().getOperationalProperties().setMultipleDeploymentAllowed(allowMultipleDeploy);
        ArrayList<String> flowNames = new ArrayList<String>();
        for (int i = 0; i < analysisEngineDescriptions.size(); ++i) {
            AnalysisEngineDescription aed = analysisEngineDescriptions.get(i);
            String componentName = componentNames.get(i);
            desc.getDelegateAnalysisEngineSpecifiersWithImports().put(componentName, aed);
            flowNames.add(componentName);
        }
        if (flowControllerDescription != null) {
            FlowControllerDeclaration_impl flowControllerDeclaration = new FlowControllerDeclaration_impl();
            flowControllerDeclaration.setSpecifier(flowControllerDescription);
            desc.setFlowControllerDeclaration(flowControllerDeclaration);
        }
        FixedFlow_impl fixedFlow = new FixedFlow_impl();
        fixedFlow.setFixedFlow(flowNames.toArray(new String[flowNames.size()]));
        desc.getAnalysisEngineMetaData().setFlowConstraints(fixedFlow);
        if (typePriorities != null) {
            desc.getAnalysisEngineMetaData().setTypePriorities(typePriorities);
        }
        if (sofaMappings != null) {
            desc.setSofaMappings(sofaMappings);
        }
        return desc;
    }

    public static JCas process(String descriptorFileName, String fileNameOrText) throws IOException, UIMAException {
        AnalysisEngine engine = AnalysisEngineFactory.createAnalysisEngine(descriptorFileName, new Object[0]);
        JCas jCas = AnalysisEngineFactory.process(engine, fileNameOrText);
        engine.collectionProcessComplete();
        return jCas;
    }

    public static JCas process(AnalysisEngine analysisEngine, String fileNameOrText) throws IOException, UIMAException {
        JCas jCas = analysisEngine.newJCas();
        AnalysisEngineFactory.process(jCas, analysisEngine, fileNameOrText);
        return jCas;
    }

    public static void process(JCas jCas, AnalysisEngine analysisEngine, String fileNameOrText) throws IOException, UIMAException {
        File textFile = new File(fileNameOrText);
        String text2 = textFile.exists() ? FileUtils.file2String(textFile) : fileNameOrText;
        jCas.setDocumentText(text2);
        analysisEngine.process(jCas);
    }
}

