/*
 * Decompiled with CFR 0.152.
 */
package org.uimafit.factory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.metadata.SofaMapping;
import org.apache.uima.flow.FlowControllerDescription;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.uimafit.factory.AnalysisEngineFactory;
import org.uimafit.factory.SofaMappingFactory;

public class AggregateBuilder {
    List<String> componentNames = new ArrayList<String>();
    List<SofaMapping> sofaMappings = new ArrayList<SofaMapping>();
    List<AnalysisEngineDescription> analysisEngineDescriptions = new ArrayList<AnalysisEngineDescription>();
    TypeSystemDescription typeSystemDescription;
    TypePriorities typePriorities;
    FlowControllerDescription flowControllerDescription;

    public AggregateBuilder() {
        this(null, null, null);
    }

    public AggregateBuilder(TypeSystemDescription typeSystemDescription, TypePriorities typePriorities, FlowControllerDescription flowControllerDescription) {
        this.typeSystemDescription = typeSystemDescription;
        this.typePriorities = typePriorities;
        this.flowControllerDescription = flowControllerDescription;
    }

    public String add(AnalysisEngineDescription aed, String ... viewNames) {
        String componentName = aed.getAnalysisEngineMetaData().getName();
        if (componentName == null || componentName.equals("")) {
            componentName = aed.isPrimitive() ? aed.getAnnotatorImplementationName() : "aggregate";
        }
        if (this.componentNames.contains(componentName)) {
            componentName = componentName + "." + (this.componentNames.size() + 1);
        }
        this.add(componentName, aed, viewNames);
        return componentName;
    }

    public void add(String componentName, AnalysisEngineDescription aed, String ... viewNames) {
        if (this.componentNames.contains(componentName)) {
            throw new IllegalArgumentException("the component name '" + componentName + "' has already been used for another added analysis engine description.");
        }
        if (viewNames != null && viewNames.length % 2 != 0) {
            throw new IllegalArgumentException("an even number of view names is required (as component view name, aggregate view name pairs) for the AggregateBuilder.add method. " + viewNames.length + " view names passed: " + Arrays.asList(viewNames));
        }
        this.analysisEngineDescriptions.add(aed);
        this.componentNames.add(componentName);
        if (viewNames != null) {
            for (int i = 0; i < viewNames.length; i += 2) {
                this.sofaMappings.add(SofaMappingFactory.createSofaMapping(componentName, viewNames[i], viewNames[i + 1]));
            }
        }
    }

    public void addSofaMapping(String componentName, String componentViewName, String aggregateViewName) {
        if (!this.componentNames.contains(componentName)) {
            throw new IllegalArgumentException("No component with the name '" + componentName + "' has been added to this builder.  Sofa mappings may only be added for " + "components that have been added to this builder. ");
        }
        this.sofaMappings.add(SofaMappingFactory.createSofaMapping(componentName, componentViewName, aggregateViewName));
    }

    public void setFlowControllerDescription(FlowControllerDescription flowControllerDescription) {
        this.flowControllerDescription = flowControllerDescription;
    }

    public AnalysisEngine createAggregate() throws ResourceInitializationException {
        return AnalysisEngineFactory.createAggregate(this.analysisEngineDescriptions, this.componentNames, this.typeSystemDescription, this.typePriorities, this.sofaMappings.toArray(new SofaMapping[this.sofaMappings.size()]), this.flowControllerDescription);
    }

    public AnalysisEngineDescription createAggregateDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createAggregateDescription(this.analysisEngineDescriptions, this.componentNames, this.typeSystemDescription, this.typePriorities, this.sofaMappings.toArray(new SofaMapping[this.sofaMappings.size()]), this.flowControllerDescription);
    }
}

