/*
 * Decompiled with CFR 0.152.
 */
package org.uimafit.component.initialize;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.uima.UimaContext;
import org.apache.uima.resource.ExternalResourceDependency;
import org.apache.uima.resource.Resource;
import org.apache.uima.resource.ResourceInitializationException;
import org.uimafit.descriptor.ExternalResource;
import org.uimafit.descriptor.ExternalResourceLocator;
import org.uimafit.factory.ExternalResourceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalResourceInitializer {
    public static <T> void initialize(UimaContext context, T object) throws ResourceInitializationException {
        try {
            ExternalResourceInitializer.configure(context, object.getClass(), object.getClass(), object, ExternalResourceInitializer.getResourceDeclarations(object.getClass()));
        }
        catch (Exception e) {
            throw new ResourceInitializationException(e);
        }
    }

    private static <T> void configure(UimaContext context, Class<?> baseCls, Class<?> cls, T object, Map<String, ExternalResourceDependency> dependencies) throws ResourceInitializationException {
        try {
            if (cls.getSuperclass() != null) {
                ExternalResourceInitializer.configure(context, baseCls, cls.getSuperclass(), object, dependencies);
            }
            for (Field field2 : cls.getDeclaredFields()) {
                if (!field2.isAnnotationPresent(ExternalResource.class)) continue;
                Object value2 = context.getResourceObject(ExternalResourceInitializer.getKey(field2));
                if (value2 instanceof ExternalResourceLocator) {
                    value2 = ((ExternalResourceLocator)value2).getResource();
                }
                if (value2 == null && ExternalResourceInitializer.isMandatory(field2)) {
                    throw new ResourceInitializationException(new IllegalStateException("Mandatory resource [" + ExternalResourceInitializer.getKey(field2) + "] is not set on [" + baseCls + "]"));
                }
                if (value2 == null) continue;
                field2.setAccessible(true);
                field2.set(object, value2);
                field2.setAccessible(false);
            }
        }
        catch (ResourceInitializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceInitializationException(e);
        }
    }

    public static <T> Map<String, ExternalResourceDependency> getResourceDeclarations(Class<?> cls) throws ResourceInitializationException {
        try {
            HashMap<String, ExternalResourceDependency> deps = new HashMap<String, ExternalResourceDependency>();
            ExternalResourceInitializer.getResourceDeclarations(cls, cls, deps);
            return deps;
        }
        catch (ResourceInitializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceInitializationException(e);
        }
    }

    private static <T> void getResourceDeclarations(Class<?> baseCls, Class<?> cls, Map<String, ExternalResourceDependency> dependencies) throws ResourceInitializationException {
        if (cls.getSuperclass() != null) {
            ExternalResourceInitializer.getResourceDeclarations(baseCls, cls.getSuperclass(), dependencies);
        }
        for (Field field2 : cls.getDeclaredFields()) {
            if (!field2.isAnnotationPresent(ExternalResource.class)) continue;
            if (dependencies.containsKey(ExternalResourceInitializer.getKey(field2))) {
                throw new ResourceInitializationException(new IllegalStateException("Key [" + ExternalResourceInitializer.getKey(field2) + "] may only be used on a single field."));
            }
            dependencies.put(ExternalResourceInitializer.getKey(field2), ExternalResourceFactory.createExternalResourceDependency(ExternalResourceInitializer.getKey(field2), ExternalResourceInitializer.getApi(field2), !ExternalResourceInitializer.isMandatory(field2)));
        }
    }

    private static boolean isMandatory(Field field2) {
        return field2.getAnnotation(ExternalResource.class).mandatory();
    }

    private static String getKey(Field field2) {
        ExternalResource cpa = field2.getAnnotation(ExternalResource.class);
        String key = cpa.key();
        if (key.length() == 0) {
            key = field2.getType().getName();
        }
        return key;
    }

    private static Class<? extends Resource> getApi(Field field2) {
        ExternalResource cpa = field2.getAnnotation(ExternalResource.class);
        Class<Resource> api = cpa.api();
        if (api == Resource.class) {
            api = field2.getType();
        }
        return api;
    }
}

