/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WeakReferenceMonitor {
    private static final Log logger = LogFactory.getLog(WeakReferenceMonitor.class);
    private static final ReferenceQueue<Object> handleQueue = new ReferenceQueue();
    private static final Map<Reference, ReleaseListener> trackedEntries = Collections.synchronizedMap(new HashMap());
    private static Thread monitoringThread = null;

    public static void monitor(Object handle, ReleaseListener listener) {
        if (logger.isDebugEnabled()) {
            logger.debug("Monitoring handle [" + handle + "] with release listener [" + listener + "]");
        }
        WeakReference<Object> weakRef = new WeakReference<Object>(handle, handleQueue);
        WeakReferenceMonitor.addEntry(weakRef, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addEntry(Reference ref2, ReleaseListener entry) {
        trackedEntries.put(ref2, entry);
        Class<WeakReferenceMonitor> clazz = WeakReferenceMonitor.class;
        synchronized (WeakReferenceMonitor.class) {
            if (!WeakReferenceMonitor.isMonitoringThreadRunning()) {
                monitoringThread = new Thread((Runnable)new MonitoringProcess(), WeakReferenceMonitor.class.getName());
                monitoringThread.setDaemon(true);
                monitoringThread.start();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static ReleaseListener removeEntry(Reference reference) {
        return trackedEntries.remove(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isMonitoringThreadRunning() {
        Class<WeakReferenceMonitor> clazz = WeakReferenceMonitor.class;
        synchronized (WeakReferenceMonitor.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return monitoringThread != null;
        }
    }

    private static class MonitoringProcess
    implements Runnable {
        private MonitoringProcess() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            logger.debug("Starting reference monitor thread");
            while (true) {
                try {
                    if (trackedEntries.isEmpty()) break;
                    try {
                        Reference reference = handleQueue.remove();
                        ReleaseListener entry = WeakReferenceMonitor.removeEntry(reference);
                        if (entry == null) continue;
                        entry.released();
                    }
                    catch (InterruptedException ex) {
                        logger.debug("Reference monitor thread interrupted", ex);
                        break;
                    }
                }
                catch (Throwable throwable) {
                    logger.debug("Stopping reference monitor thread");
                    Class<WeakReferenceMonitor> clazz = WeakReferenceMonitor.class;
                    synchronized (WeakReferenceMonitor.class) {
                        monitoringThread = null;
                        // ** MonitorExit[var4_5] (shouldn't be in output)
                        throw throwable;
                    }
                }
            }
            logger.debug("Stopping reference monitor thread");
            Class<WeakReferenceMonitor> clazz = WeakReferenceMonitor.class;
            synchronized (WeakReferenceMonitor.class) {
                monitoringThread = null;
                // ** MonitorExit[var4_6] (shouldn't be in output)
                return;
            }
        }
    }

    public static interface ReleaseListener {
        public void released();
    }
}

