/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.Type;
import org.springframework.asm.commons.EmptyVisitor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AnnotationAttributesReadingVisitor
implements AnnotationVisitor {
    private final String annotationType;
    private final Map<String, Map<String, Object>> attributesMap;
    private final Map<String, Set<String>> metaAnnotationMap;
    private final ClassLoader classLoader;
    private final Map<String, Object> localAttributes = new LinkedHashMap<String, Object>();

    public AnnotationAttributesReadingVisitor(String annotationType, Map<String, Map<String, Object>> attributesMap, Map<String, Set<String>> metaAnnotationMap, ClassLoader classLoader) {
        this.annotationType = annotationType;
        this.attributesMap = attributesMap;
        this.metaAnnotationMap = metaAnnotationMap;
        this.classLoader = classLoader;
    }

    public void visit(String name, Object value2) {
        this.localAttributes.put(name, value2);
    }

    public void visitEnum(String name, String desc, String value2) {
        Object valueToUse = value2;
        try {
            Class<?> enumType = this.classLoader.loadClass(Type.getType((String)desc).getClassName());
            Field enumConstant = ReflectionUtils.findField(enumType, value2);
            if (enumConstant != null) {
                valueToUse = enumConstant.get(null);
            }
        }
        catch (Exception exception) {}
        this.localAttributes.put(name, valueToUse);
    }

    public AnnotationVisitor visitAnnotation(String name, String desc) {
        return new EmptyVisitor();
    }

    public AnnotationVisitor visitArray(final String attrName) {
        return new AnnotationVisitor(){

            public void visit(String name, Object value2) {
                Object[] newValue = value2;
                Object existingValue = AnnotationAttributesReadingVisitor.this.localAttributes.get(attrName);
                if (existingValue != null) {
                    newValue = ObjectUtils.addObjectToArray((Object[])existingValue, newValue);
                } else {
                    Object[] newArray = (Object[])Array.newInstance(newValue.getClass(), 1);
                    newArray[0] = newValue;
                    newValue = newArray;
                }
                AnnotationAttributesReadingVisitor.this.localAttributes.put(attrName, newValue);
            }

            public void visitEnum(String name, String desc, String value2) {
            }

            public AnnotationVisitor visitAnnotation(String name, String desc) {
                return new EmptyVisitor();
            }

            public AnnotationVisitor visitArray(String name) {
                return new EmptyVisitor();
            }

            public void visitEnd() {
            }
        };
    }

    public void visitEnd() {
        this.attributesMap.put(this.annotationType, this.localAttributes);
        try {
            Method[] annotationAttributes;
            Class<?> annotationClass = this.classLoader.loadClass(this.annotationType);
            Method[] methodArray = annotationAttributes = annotationClass.getMethods();
            int n = annotationAttributes.length;
            int n2 = 0;
            while (n2 < n) {
                Method annotationAttribute = methodArray[n2];
                String attributeName = annotationAttribute.getName();
                Object defaultValue = annotationAttribute.getDefaultValue();
                if (defaultValue != null && !this.localAttributes.containsKey(attributeName)) {
                    this.localAttributes.put(attributeName, defaultValue);
                }
                ++n2;
            }
            LinkedHashSet<String> metaAnnotationTypeNames = new LinkedHashSet<String>();
            Annotation[] annotationArray = annotationClass.getAnnotations();
            int n3 = annotationArray.length;
            n = 0;
            while (n < n3) {
                Annotation metaAnnotation = annotationArray[n];
                metaAnnotationTypeNames.add(metaAnnotation.annotationType().getName());
                if (!this.attributesMap.containsKey(metaAnnotation.annotationType().getName())) {
                    this.attributesMap.put(metaAnnotation.annotationType().getName(), AnnotationUtils.getAnnotationAttributes(metaAnnotation, true));
                }
                Annotation[] annotationArray2 = metaAnnotation.annotationType().getAnnotations();
                int n4 = annotationArray2.length;
                int n5 = 0;
                while (n5 < n4) {
                    Annotation metaMetaAnnotation = annotationArray2[n5];
                    metaAnnotationTypeNames.add(metaMetaAnnotation.annotationType().getName());
                    ++n5;
                }
                ++n;
            }
            if (this.metaAnnotationMap != null) {
                this.metaAnnotationMap.put(this.annotationType, metaAnnotationTypeNames);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }
}

