/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.SystemPropertyUtils;

public class ResourceEditor
extends PropertyEditorSupport {
    private final ResourceLoader resourceLoader;
    private final boolean ignoreUnresolvablePlaceholders;

    public ResourceEditor() {
        this(new DefaultResourceLoader());
    }

    public ResourceEditor(ResourceLoader resourceLoader) {
        this(resourceLoader, true);
    }

    public ResourceEditor(ResourceLoader resourceLoader, boolean ignoreUnresolvablePlaceholders) {
        Assert.notNull(resourceLoader, "ResourceLoader must not be null");
        this.resourceLoader = resourceLoader;
        this.ignoreUnresolvablePlaceholders = ignoreUnresolvablePlaceholders;
    }

    public void setAsText(String text2) {
        if (StringUtils.hasText(text2)) {
            String locationToUse = this.resolvePath(text2).trim();
            this.setValue(this.resourceLoader.getResource(locationToUse));
        } else {
            this.setValue(null);
        }
    }

    protected String resolvePath(String path) {
        return SystemPropertyUtils.resolvePlaceholders(path, this.ignoreUnresolvablePlaceholders);
    }

    public String getAsText() {
        Resource value2 = (Resource)this.getValue();
        try {
            return value2 != null ? value2.getURL().toExternalForm() : "";
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

