/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.DecoratingClassLoader;
import org.springframework.util.FileCopyUtils;

public class OverridingClassLoader
extends DecoratingClassLoader {
    public static final String[] DEFAULT_EXCLUDED_PACKAGES = new String[]{"java.", "javax.", "sun.", "oracle."};
    private static final String CLASS_FILE_SUFFIX = ".class";

    public OverridingClassLoader(ClassLoader parent) {
        super(parent);
        String[] stringArray = DEFAULT_EXCLUDED_PACKAGES;
        int n = DEFAULT_EXCLUDED_PACKAGES.length;
        int n2 = 0;
        while (n2 < n) {
            String packageName = stringArray[n2];
            this.excludePackage(packageName);
            ++n2;
        }
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class result2 = null;
        if (this.isEligibleForOverriding(name)) {
            result2 = this.loadClassForOverriding(name);
        }
        if (result2 != null) {
            if (resolve) {
                this.resolveClass(result2);
            }
            return result2;
        }
        return super.loadClass(name, resolve);
    }

    protected boolean isEligibleForOverriding(String className) {
        return !this.isExcluded(className);
    }

    protected Class loadClassForOverriding(String name) throws ClassNotFoundException {
        byte[] bytes;
        Class<?> result2 = this.findLoadedClass(name);
        if (result2 == null && (bytes = this.loadBytesForClass(name)) != null) {
            result2 = this.defineClass(name, bytes, 0, bytes.length);
        }
        return result2;
    }

    protected byte[] loadBytesForClass(String name) throws ClassNotFoundException {
        InputStream is = this.openStreamForClass(name);
        if (is == null) {
            return null;
        }
        try {
            byte[] bytes = FileCopyUtils.copyToByteArray(is);
            return this.transformIfNecessary(name, bytes);
        }
        catch (IOException ex) {
            throw new ClassNotFoundException("Cannot load resource for class [" + name + "]", ex);
        }
    }

    protected InputStream openStreamForClass(String name) {
        String internalName = String.valueOf(name.replace('.', '/')) + CLASS_FILE_SUFFIX;
        return this.getParent().getResourceAsStream(internalName);
    }

    protected byte[] transformIfNecessary(String name, byte[] bytes) {
        return bytes;
    }
}

