/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.asm.ClassReader;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.Label;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.Type;
import org.springframework.asm.commons.EmptyVisitor;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalVariableTableParameterNameDiscoverer
implements ParameterNameDiscoverer {
    private static Log logger = LogFactory.getLog(LocalVariableTableParameterNameDiscoverer.class);
    private static final Map<Member, String[]> NO_DEBUG_INFO_MAP = Collections.emptyMap();
    private final Map<Class<?>, Map<Member, String[]>> parameterNamesCache = new ConcurrentHashMap();

    @Override
    public String[] getParameterNames(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        Map<Member, String[]> map2 = this.parameterNamesCache.get(declaringClass);
        if (map2 == null) {
            map2 = this.inspectClass(declaringClass);
            this.parameterNamesCache.put(declaringClass, map2);
        }
        if (map2 != NO_DEBUG_INFO_MAP) {
            return map2.get(method);
        }
        return null;
    }

    @Override
    public String[] getParameterNames(Constructor ctor) {
        Class declaringClass = ctor.getDeclaringClass();
        Map<Member, String[]> map2 = this.parameterNamesCache.get(declaringClass);
        if (map2 == null) {
            map2 = this.inspectClass(declaringClass);
            this.parameterNamesCache.put(declaringClass, map2);
        }
        if (map2 != NO_DEBUG_INFO_MAP) {
            return map2.get(ctor);
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private Map<Member, String[]> inspectClass(Class<?> clazz) {
        InputStream is = clazz.getResourceAsStream(ClassUtils.getClassFileName(clazz));
        if (is == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Cannot find '.class' file for class [" + clazz + "] - unable to determine constructors/methods parameter names");
            }
            return NO_DEBUG_INFO_MAP;
        }
        ClassReader classReader = new ClassReader(is);
        ConcurrentHashMap<Member, String[]> map2 = new ConcurrentHashMap<Member, String[]>();
        classReader.accept((ClassVisitor)new ParameterNameDiscoveringVisitor(clazz, map2), false);
        ConcurrentHashMap<Member, String[]> concurrentHashMap = map2;
        try {
            is.close();
        }
        catch (IOException iOException) {}
        return concurrentHashMap;
        catch (IOException ex) {
            block12: {
                try {
                    if (!logger.isDebugEnabled()) break block12;
                    logger.debug("Exception thrown while reading '.class' file for class [" + clazz + "] - unable to determine constructors/methods parameter names", ex);
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return NO_DEBUG_INFO_MAP;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocalVariableTableVisitor
    extends EmptyVisitor {
        private static final String CONSTRUCTOR = "<init>";
        private final Class<?> clazz;
        private final Map<Member, String[]> memberMap;
        private final String name;
        private final Type[] args;
        private final boolean isStatic;
        private String[] parameterNames;
        private boolean hasLvtInfo = false;
        private final int[] lvtSlotIndex;

        public LocalVariableTableVisitor(Class<?> clazz, Map<Member, String[]> map2, String name, String desc, boolean isStatic) {
            this.clazz = clazz;
            this.memberMap = map2;
            this.name = name;
            this.args = Type.getArgumentTypes((String)desc);
            this.parameterNames = new String[this.args.length];
            this.isStatic = isStatic;
            this.lvtSlotIndex = LocalVariableTableVisitor.computeLvtSlotIndices(isStatic, this.args);
        }

        public void visitLocalVariable(String name, String description, String signature, Label start, Label end, int index) {
            this.hasLvtInfo = true;
            int i = 0;
            while (i < this.lvtSlotIndex.length) {
                if (this.lvtSlotIndex[i] == index) {
                    this.parameterNames[i] = name;
                }
                ++i;
            }
        }

        public void visitEnd() {
            if (this.hasLvtInfo || this.isStatic && this.parameterNames.length == 0) {
                this.memberMap.put(this.resolveMember(), this.parameterNames);
            }
        }

        private Member resolveMember() {
            ClassLoader loader = this.clazz.getClassLoader();
            Class[] classes = new Class[this.args.length];
            int i = 0;
            while (i < this.args.length) {
                classes[i] = ClassUtils.resolveClassName(this.args[i].getClassName(), loader);
                ++i;
            }
            try {
                if (CONSTRUCTOR.equals(this.name)) {
                    return this.clazz.getDeclaredConstructor(classes);
                }
                return this.clazz.getDeclaredMethod(this.name, classes);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException("Method [" + this.name + "] was discovered in the .class file but cannot be resolved in the class object", ex);
            }
        }

        private static int[] computeLvtSlotIndices(boolean isStatic, Type[] paramTypes) {
            int[] lvtIndex = new int[paramTypes.length];
            int nextIndex = isStatic ? 0 : 1;
            int i = 0;
            while (i < paramTypes.length) {
                lvtIndex[i] = nextIndex++;
                if (LocalVariableTableVisitor.isWideType(paramTypes[i])) {
                    nextIndex += 2;
                }
                ++i;
            }
            return lvtIndex;
        }

        private static boolean isWideType(Type aType) {
            return aType == Type.LONG_TYPE || aType == Type.DOUBLE_TYPE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParameterNameDiscoveringVisitor
    extends EmptyVisitor {
        private static final String STATIC_CLASS_INIT = "<clinit>";
        private final Class<?> clazz;
        private final Map<Member, String[]> memberMap;

        public ParameterNameDiscoveringVisitor(Class<?> clazz, Map<Member, String[]> memberMap) {
            this.clazz = clazz;
            this.memberMap = memberMap;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (!ParameterNameDiscoveringVisitor.isSyntheticOrBridged(access) && !STATIC_CLASS_INIT.equals(name)) {
                return new LocalVariableTableVisitor(this.clazz, this.memberMap, name, desc, ParameterNameDiscoveringVisitor.isStatic(access));
            }
            return null;
        }

        private static boolean isSyntheticOrBridged(int access) {
            return (access & 0x1000 | access & 0x40) > 0;
        }

        private static boolean isStatic(int access) {
            return (access & 8) > 0;
        }
    }
}

