/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.springframework.util.Assert;

public abstract class DecoratingClassLoader
extends ClassLoader {
    private final Set<String> excludedPackages = new HashSet<String>();
    private final Set<String> excludedClasses = new HashSet<String>();
    private final Object exclusionMonitor = new Object();

    public DecoratingClassLoader() {
    }

    public DecoratingClassLoader(ClassLoader parent) {
        super(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void excludePackage(String packageName) {
        Assert.notNull(packageName, "Package name must not be null");
        Object object = this.exclusionMonitor;
        synchronized (object) {
            this.excludedPackages.add(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void excludeClass(String className) {
        Assert.notNull(className, "Class name must not be null");
        Object object = this.exclusionMonitor;
        synchronized (object) {
            this.excludedClasses.add(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isExcluded(String className) {
        Object object = this.exclusionMonitor;
        synchronized (object) {
            String packageName;
            if (this.excludedClasses.contains(className)) {
                return true;
            }
            Iterator<String> iterator2 = this.excludedPackages.iterator();
            do {
                if (iterator2.hasNext()) continue;
                return false;
            } while (!className.startsWith(packageName = iterator2.next()));
            return true;
        }
    }
}

