/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.springframework.core.ConstantException;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Constants {
    private final String className;
    private final Map<String, Object> fieldCache = new HashMap<String, Object>();

    public Constants(Class clazz) {
        Field[] fields;
        Assert.notNull(clazz);
        this.className = clazz.getName();
        Field[] fieldArray = fields = clazz.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field2 = fieldArray[n2];
            if (ReflectionUtils.isPublicStaticFinal(field2)) {
                String name = field2.getName();
                try {
                    Object value2 = field2.get(null);
                    this.fieldCache.put(name, value2);
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            ++n2;
        }
    }

    public final String getClassName() {
        return this.className;
    }

    public final int getSize() {
        return this.fieldCache.size();
    }

    protected final Map<String, Object> getFieldCache() {
        return this.fieldCache;
    }

    public Number asNumber(String code) throws ConstantException {
        Object obj = this.asObject(code);
        if (!(obj instanceof Number)) {
            throw new ConstantException(this.className, code, "not a Number");
        }
        return (Number)obj;
    }

    public String asString(String code) throws ConstantException {
        return this.asObject(code).toString();
    }

    public Object asObject(String code) throws ConstantException {
        Assert.notNull(code, "Code must not be null");
        String codeToUse = code.toUpperCase(Locale.ENGLISH);
        Object val = this.fieldCache.get(codeToUse);
        if (val == null) {
            throw new ConstantException(this.className, codeToUse, "not found");
        }
        return val;
    }

    public Set<String> getNames(String namePrefix) {
        String prefixToUse = namePrefix != null ? namePrefix.trim().toUpperCase(Locale.ENGLISH) : "";
        HashSet<String> names = new HashSet<String>();
        for (String code : this.fieldCache.keySet()) {
            if (!code.startsWith(prefixToUse)) continue;
            names.add(code);
        }
        return names;
    }

    public Set<String> getNamesForProperty(String propertyName) {
        return this.getNames(this.propertyToConstantNamePrefix(propertyName));
    }

    public Set getNamesForSuffix(String nameSuffix) {
        String suffixToUse = nameSuffix != null ? nameSuffix.trim().toUpperCase(Locale.ENGLISH) : "";
        HashSet<String> names = new HashSet<String>();
        for (String code : this.fieldCache.keySet()) {
            if (!code.endsWith(suffixToUse)) continue;
            names.add(code);
        }
        return names;
    }

    public Set<Object> getValues(String namePrefix) {
        String prefixToUse = namePrefix != null ? namePrefix.trim().toUpperCase(Locale.ENGLISH) : "";
        HashSet<Object> values2 = new HashSet<Object>();
        for (String code : this.fieldCache.keySet()) {
            if (!code.startsWith(prefixToUse)) continue;
            values2.add(this.fieldCache.get(code));
        }
        return values2;
    }

    public Set<Object> getValuesForProperty(String propertyName) {
        return this.getValues(this.propertyToConstantNamePrefix(propertyName));
    }

    public Set<Object> getValuesForSuffix(String nameSuffix) {
        String suffixToUse = nameSuffix != null ? nameSuffix.trim().toUpperCase(Locale.ENGLISH) : "";
        HashSet<Object> values2 = new HashSet<Object>();
        for (String code : this.fieldCache.keySet()) {
            if (!code.endsWith(suffixToUse)) continue;
            values2.add(this.fieldCache.get(code));
        }
        return values2;
    }

    public String toCode(Object value2, String namePrefix) throws ConstantException {
        String prefixToUse = namePrefix != null ? namePrefix.trim().toUpperCase(Locale.ENGLISH) : null;
        for (Map.Entry<String, Object> entry : this.fieldCache.entrySet()) {
            if (!entry.getKey().startsWith(prefixToUse) || !entry.getValue().equals(value2)) continue;
            return entry.getKey();
        }
        throw new ConstantException(this.className, prefixToUse, value2);
    }

    public String toCodeForProperty(Object value2, String propertyName) throws ConstantException {
        return this.toCode(value2, this.propertyToConstantNamePrefix(propertyName));
    }

    public String toCodeForSuffix(Object value2, String nameSuffix) throws ConstantException {
        String suffixToUse = nameSuffix != null ? nameSuffix.trim().toUpperCase(Locale.ENGLISH) : null;
        for (Map.Entry<String, Object> entry : this.fieldCache.entrySet()) {
            if (!entry.getKey().endsWith(suffixToUse) || !entry.getValue().equals(value2)) continue;
            return entry.getKey();
        }
        throw new ConstantException(this.className, suffixToUse, value2);
    }

    public String propertyToConstantNamePrefix(String propertyName) {
        StringBuilder parsedPrefix = new StringBuilder();
        int i = 0;
        while (i < propertyName.length()) {
            char c = propertyName.charAt(i);
            if (Character.isUpperCase(c)) {
                parsedPrefix.append("_");
                parsedPrefix.append(c);
            } else {
                parsedPrefix.append(Character.toUpperCase(c));
            }
            ++i;
        }
        return parsedPrefix.toString();
    }
}

