/*
 * Decompiled with CFR 0.152.
 */
package org.j_paine.formatter;

import java.io.DataInputStream;
import java.io.IOException;
import org.j_paine.formatter.DataMissingOnReadException;
import org.j_paine.formatter.EndOfFileWhenStartingReadException;
import org.j_paine.formatter.FormatElement;
import org.j_paine.formatter.IOExceptionOnReadException;
import org.j_paine.formatter.LineMissingOnReadException;

class InputStreamAndBuffer {
    private DataInputStream in;
    private String line;
    private int ptr;
    private int line_number;
    private boolean nothing_read;

    public InputStreamAndBuffer(DataInputStream dataInputStream) {
        this.in = dataInputStream;
        this.ptr = 0;
        this.line = "";
        this.line_number = 0;
        this.nothing_read = true;
    }

    public void readLine(int n, FormatElement formatElement) throws EndOfFileWhenStartingReadException, LineMissingOnReadException, IOExceptionOnReadException {
        try {
            String string2 = this.in.readLine();
            if (string2 == null) {
                if (this.nothing_read) {
                    throw new EndOfFileWhenStartingReadException(n, formatElement.toString(), this.line, this.line_number);
                }
                throw new LineMissingOnReadException(n, formatElement.toString(), this.line, this.line_number);
            }
            this.ptr = 0;
            this.nothing_read = false;
            ++this.line_number;
            this.line = string2;
        }
        catch (IOException iOException) {
            throw new IOExceptionOnReadException(this.line, this.line_number, iOException.getMessage());
        }
    }

    public String getSlice(int n, int n2, FormatElement formatElement) throws DataMissingOnReadException, LineMissingOnReadException, EndOfFileWhenStartingReadException, IOExceptionOnReadException {
        if (this.nothing_read) {
            this.readLine(n2, formatElement);
        }
        if (this.ptr + n > this.line.length()) {
            return this.line.substring(this.ptr);
        }
        return this.line.substring(this.ptr, this.ptr + n);
    }

    public void advance(int n) {
        this.ptr += n;
    }

    public String getLineErrorReport() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  Line number = " + this.line_number + ":\n");
        stringBuffer.append(this.line + "\n");
        for (int i = 0; i < this.ptr; ++i) {
            stringBuffer.append(" ");
        }
        stringBuffer.append("^");
        return stringBuffer.toString();
    }
}

