/*
 * Decompiled with CFR 0.152.
 */
package org.j_paine.formatter;

import java.io.StringBufferInputStream;
import org.j_paine.formatter.FormatIOElement;
import org.j_paine.formatter.FormatInputList;
import org.j_paine.formatter.IllegalObjectOnWriteException;
import org.j_paine.formatter.InputStreamAndBuffer;
import org.j_paine.formatter.InvalidNumberOnReadException;
import org.j_paine.formatter.NumberParser;
import org.j_paine.formatter.NumberTooWideOnWriteException;
import org.j_paine.formatter.ParseException;
import org.j_paine.formatter.Parsers;
import org.j_paine.formatter.TokenMgrError;

class FormatL
extends FormatIOElement {
    public FormatL(int n) {
        this.setWidth(n);
    }

    String convertToString(Object object, int n) throws IllegalObjectOnWriteException, NumberTooWideOnWriteException {
        if (object instanceof Boolean) {
            char[] cArray = new char[this.getWidth()];
            for (int i = 0; i < cArray.length - 1; ++i) {
                cArray[i] = 32;
            }
            cArray[i] = (Boolean)object == true ? 84 : 70;
            String string2 = new String(cArray);
            if (string2.length() > this.getWidth()) {
                throw new NumberTooWideOnWriteException((Number)object, n, this.toString());
            }
            return string2;
        }
        throw new IllegalObjectOnWriteException(object, n, this.toString());
    }

    Object convertFromString(String string2, FormatInputList formatInputList, InputStreamAndBuffer inputStreamAndBuffer) throws InvalidNumberOnReadException {
        NumberParser numberParser = Parsers.theParsers().number_parser;
        numberParser.ReInit(new StringBufferInputStream(string2));
        try {
            Boolean bl;
            int n = numberParser.Boolean();
            char c = string2.substring(n).charAt(0);
            if (c == 't' || c == 'T') {
                bl = new Boolean(true);
            } else if (c == 'f' || c == 'F') {
                bl = new Boolean(false);
            } else {
                throw new ParseException("bad logical value");
            }
            return bl;
        }
        catch (ParseException parseException) {
            throw new InvalidNumberOnReadException(string2, formatInputList.getPtr(), this.toString(), inputStreamAndBuffer.getLineErrorReport(), parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidNumberOnReadException(string2, formatInputList.getPtr(), this.toString(), inputStreamAndBuffer.getLineErrorReport(), tokenMgrError.getMessage());
        }
    }

    public String toString() {
        return "L" + this.getWidth();
    }
}

