/*
 * Decompiled with CFR 0.152.
 */
package org.j_paine.formatter;

import java.io.StringBufferInputStream;
import org.j_paine.formatter.CJFormat;
import org.j_paine.formatter.FormatIOElement;
import org.j_paine.formatter.FormatInputList;
import org.j_paine.formatter.IllegalObjectOnWriteException;
import org.j_paine.formatter.InputStreamAndBuffer;
import org.j_paine.formatter.InvalidNumberOnReadException;
import org.j_paine.formatter.NumberParser;
import org.j_paine.formatter.NumberTooWideOnWriteException;
import org.j_paine.formatter.ParseException;
import org.j_paine.formatter.Parsers;
import org.j_paine.formatter.TokenMgrError;

class FormatE
extends FormatIOElement {
    int d;

    public FormatE(int n, int n2) {
        this.setWidth(n);
        this.d = n2;
    }

    String convertToString(Object object, int n) throws IllegalObjectOnWriteException, NumberTooWideOnWriteException {
        if (object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double) {
            CJFormat cJFormat = new CJFormat();
            cJFormat.setWidth(this.getWidth());
            cJFormat.setPrecision(this.d);
            cJFormat.setPre("");
            cJFormat.setPost("");
            cJFormat.setLeadingZeroes(false);
            cJFormat.setShowPlus(false);
            cJFormat.setAlternate(false);
            cJFormat.setShowSpace(false);
            cJFormat.setLeftAlign(false);
            cJFormat.setFmt('E');
            String string2 = cJFormat.form(((Number)object).doubleValue());
            if (string2.length() > this.getWidth()) {
                throw new NumberTooWideOnWriteException((Number)object, n, this.toString());
            }
            return string2;
        }
        throw new IllegalObjectOnWriteException(object, n, this.toString());
    }

    Object convertFromString(String string2, FormatInputList formatInputList, InputStreamAndBuffer inputStreamAndBuffer) throws InvalidNumberOnReadException {
        NumberParser numberParser = Parsers.theParsers().number_parser;
        numberParser.ReInit(new StringBufferInputStream(string2));
        try {
            int n = numberParser.Float();
            Double d = new Double(string2.substring(n));
            return d;
        }
        catch (ParseException parseException) {
            throw new InvalidNumberOnReadException(string2, formatInputList.getPtr(), this.toString(), inputStreamAndBuffer.getLineErrorReport(), parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidNumberOnReadException(string2, formatInputList.getPtr(), this.toString(), inputStreamAndBuffer.getLineErrorReport(), tokenMgrError.getMessage());
        }
    }

    public String toString() {
        return "E" + this.getWidth() + "." + this.d;
    }
}

