/*
 * Decompiled with CFR 0.152.
 */
package org.j_paine.formatter;

import java.io.PrintStream;

public class CJFormat {
    private int width = 0;
    private int precision = -1;
    private String pre = "";
    private String post = "";
    private boolean leading_zeroes = false;
    private boolean show_plus = false;
    private boolean alternate = false;
    private boolean show_space = false;
    private boolean left_align = false;
    private char fmt = (char)32;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CJFormat(String string2) {
        boolean bl = false;
        int n = string2.length();
        int n2 = 0;
        int n3 = 0;
        while (n2 == 0) {
            if (n3 >= n) {
                n2 = 5;
            } else if (string2.charAt(n3) == '%') {
                if (n3 >= n - 1) throw new IllegalArgumentException();
                if (string2.charAt(n3 + 1) == '%') {
                    this.pre = this.pre + '%';
                    ++n3;
                } else {
                    n2 = 1;
                }
            } else {
                this.pre = this.pre + string2.charAt(n3);
            }
            ++n3;
        }
        while (n2 == 1) {
            if (n3 >= n) {
                n2 = 5;
            } else if (string2.charAt(n3) == ' ') {
                this.show_space = true;
            } else if (string2.charAt(n3) == '-') {
                this.left_align = true;
            } else if (string2.charAt(n3) == '+') {
                this.show_plus = true;
            } else if (string2.charAt(n3) == '0') {
                this.leading_zeroes = true;
            } else if (string2.charAt(n3) == '#') {
                this.alternate = true;
            } else {
                n2 = 2;
                --n3;
            }
            ++n3;
        }
        while (n2 == 2) {
            if (n3 >= n) {
                n2 = 5;
                continue;
            }
            if ('0' <= string2.charAt(n3) && string2.charAt(n3) <= '9') {
                this.width = this.width * 10 + string2.charAt(n3) - 48;
                ++n3;
                continue;
            }
            if (string2.charAt(n3) == '.') {
                n2 = 3;
                this.precision = 0;
                ++n3;
                continue;
            }
            n2 = 4;
        }
        while (n2 == 3) {
            if (n3 >= n) {
                n2 = 5;
                continue;
            }
            if ('0' <= string2.charAt(n3) && string2.charAt(n3) <= '9') {
                this.precision = this.precision * 10 + string2.charAt(n3) - 48;
                ++n3;
                continue;
            }
            n2 = 4;
        }
        if (n2 == 4) {
            if (n3 >= n) {
                n2 = 5;
            } else {
                this.fmt = string2.charAt(n3);
            }
            ++n3;
        }
        if (n3 >= n) return;
        this.post = string2.substring(n3, n);
    }

    public CJFormat() {
    }

    public static void print(PrintStream printStream, String string2, double d) {
        printStream.print(new CJFormat(string2).form(d));
    }

    public static void print(PrintStream printStream, String string2, long l) {
        printStream.print(new CJFormat(string2).form(l));
    }

    public static void print(PrintStream printStream, String string2, char c) {
        printStream.print(new CJFormat(string2).form(c));
    }

    public static void print(PrintStream printStream, String string2, String string3) {
        printStream.print(new CJFormat(string2).form(string3));
    }

    public static int atoi(String string2) {
        return (int)CJFormat.atol(string2);
    }

    public static long atol(String string2) {
        int n;
        for (n = 0; n < string2.length() && Character.isSpace(string2.charAt(n)); ++n) {
        }
        if (n < string2.length() && string2.charAt(n) == '0') {
            if (n + 1 < string2.length() && (string2.charAt(n + 1) == 'x' || string2.charAt(n + 1) == 'X')) {
                return CJFormat.parseLong(string2.substring(n + 2), 16);
            }
            return CJFormat.parseLong(string2, 8);
        }
        return CJFormat.parseLong(string2, 10);
    }

    private static long parseLong(String string2, int n) {
        int n2;
        int n3 = 1;
        long l = 0L;
        for (n2 = 0; n2 < string2.length() && Character.isSpace(string2.charAt(n2)); ++n2) {
        }
        if (n2 < string2.length() && string2.charAt(n2) == '-') {
            n3 = -1;
            ++n2;
        } else if (n2 < string2.length() && string2.charAt(n2) == '+') {
            ++n2;
        }
        while (n2 < string2.length()) {
            char c = string2.charAt(n2);
            if ('0' <= c && c < 48 + n) {
                l = l * (long)n + (long)c - 48L;
            } else if ('A' <= c && c < 65 + n - 10) {
                l = l * (long)n + (long)c - 65L + 10L;
            } else if ('a' <= c && c < 97 + n - 10) {
                l = l * (long)n + (long)c - 97L + 10L;
            } else {
                return l * (long)n3;
            }
            ++n2;
        }
        return l * (long)n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double atof(String string2) {
        int n;
        int n2 = 1;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 1.0;
        boolean bl = false;
        for (n = 0; n < string2.length() && Character.isSpace(string2.charAt(n)); ++n) {
        }
        if (n < string2.length() && string2.charAt(n) == '-') {
            n2 = -1;
            ++n;
        } else if (n < string2.length() && string2.charAt(n) == '+') {
            ++n;
        }
        while (n < string2.length()) {
            char c = string2.charAt(n);
            if ('0' <= c && c <= '9') {
                if (!bl) {
                    d = d * 10.0 + (double)c - 48.0;
                } else if (bl) {
                    d += (d3 /= 10.0) * (double)(c - 48);
                }
            } else if (c == '.') {
                if (bl) return (double)n2 * d;
                bl = true;
            } else {
                if (c != 'e' && c != 'E') return (double)n2 * d;
                long l = (int)CJFormat.parseLong(string2.substring(n + 1), 10);
                return (double)n2 * d * Math.pow(10.0, l);
            }
            ++n;
        }
        return (double)n2 * d;
    }

    public String form(double d) {
        String string2;
        if (this.precision < 0) {
            this.precision = 6;
        }
        int n = 1;
        if (d < 0.0) {
            d = -d;
            n = -1;
        }
        if (this.fmt == 'f') {
            string2 = this.fixed_format(d);
        } else if (this.fmt == 'e' || this.fmt == 'E' || this.fmt == 'g' || this.fmt == 'G') {
            string2 = this.exp_format(d);
        } else {
            throw new IllegalArgumentException();
        }
        return this.pad(this.sign(n, string2));
    }

    public String form(long l) {
        String string2;
        int n = 0;
        if (this.fmt == 'd' || this.fmt == 'i') {
            n = 1;
            if (l < 0L) {
                l = -l;
                n = -1;
            }
            string2 = "" + l;
        } else if (this.fmt == 'o') {
            string2 = CJFormat.convert(l, 3, 7, "01234567");
        } else if (this.fmt == 'x') {
            string2 = CJFormat.convert(l, 4, 15, "0123456789abcdef");
        } else if (this.fmt == 'X') {
            string2 = CJFormat.convert(l, 4, 15, "0123456789ABCDEF");
        } else {
            throw new IllegalArgumentException();
        }
        return this.pad(this.sign(n, string2));
    }

    public String form(char c) {
        if (this.fmt != 'c') {
            throw new IllegalArgumentException();
        }
        String string2 = "" + c;
        return this.pad(string2);
    }

    public String form(String string2) {
        if (this.fmt != 's') {
            throw new IllegalArgumentException();
        }
        if (this.precision >= 0) {
            string2 = string2.substring(0, this.precision);
        }
        return this.pad(string2);
    }

    public static void main(String[] stringArray) {
        double d = 1.23456789012;
        double d2 = 123.0;
        double d3 = 1.2345E30;
        double d4 = 1.02;
        double d5 = 1.234E-5;
        int n = 51966;
        CJFormat.print(System.out, "x = |%f|\n", d);
        CJFormat.print(System.out, "u = |%20f|\n", d5);
        CJFormat.print(System.out, "x = |% .5f|\n", d);
        CJFormat.print(System.out, "w = |%20.5f|\n", d4);
        CJFormat.print(System.out, "x = |%020.5f|\n", d);
        CJFormat.print(System.out, "x = |%+20.5f|\n", d);
        CJFormat.print(System.out, "x = |%+020.5f|\n", d);
        CJFormat.print(System.out, "x = |% 020.5f|\n", d);
        CJFormat.print(System.out, "y = |%#+20.5f|\n", d2);
        CJFormat.print(System.out, "y = |%-+20.5f|\n", d2);
        CJFormat.print(System.out, "z = |%20.5f|\n", d3);
        CJFormat.print(System.out, "x = |%e|\n", d);
        CJFormat.print(System.out, "u = |%20e|\n", d5);
        CJFormat.print(System.out, "x = |% .5e|\n", d);
        CJFormat.print(System.out, "w = |%20.5e|\n", d4);
        CJFormat.print(System.out, "x = |%020.5e|\n", d);
        CJFormat.print(System.out, "x = |%+20.5e|\n", d);
        CJFormat.print(System.out, "x = |%+020.5e|\n", d);
        CJFormat.print(System.out, "x = |% 020.5e|\n", d);
        CJFormat.print(System.out, "y = |%#+20.5e|\n", d2);
        CJFormat.print(System.out, "y = |%-+20.5e|\n", d2);
        CJFormat.print(System.out, "x = |%g|\n", d);
        CJFormat.print(System.out, "z = |%g|\n", d3);
        CJFormat.print(System.out, "w = |%g|\n", d4);
        CJFormat.print(System.out, "u = |%g|\n", d5);
        CJFormat.print(System.out, "y = |%.2g|\n", d2);
        CJFormat.print(System.out, "y = |%#.2g|\n", d2);
        CJFormat.print(System.out, "d = |%d|\n", n);
        CJFormat.print(System.out, "d = |%20d|\n", n);
        CJFormat.print(System.out, "d = |%020d|\n", n);
        CJFormat.print(System.out, "d = |%+20d|\n", n);
        CJFormat.print(System.out, "d = |% 020d|\n", n);
        CJFormat.print(System.out, "d = |%-20d|\n", n);
        CJFormat.print(System.out, "d = |%20.8d|\n", n);
        CJFormat.print(System.out, "d = |%x|\n", n);
        CJFormat.print(System.out, "d = |%20X|\n", n);
        CJFormat.print(System.out, "d = |%#20x|\n", n);
        CJFormat.print(System.out, "d = |%020X|\n", n);
        CJFormat.print(System.out, "d = |%20.8x|\n", n);
        CJFormat.print(System.out, "d = |%o|\n", n);
        CJFormat.print(System.out, "d = |%020o|\n", n);
        CJFormat.print(System.out, "d = |%#20o|\n", n);
        CJFormat.print(System.out, "d = |%#020o|\n", n);
        CJFormat.print(System.out, "d = |%20.12o|\n", n);
        CJFormat.print(System.out, "s = |%-20s|\n", "Hello");
        CJFormat.print(System.out, "s = |%-20c|\n", '!');
    }

    private static String repeat(char c, int n) {
        if (n <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static String convert(long l, int n, int n2, String string2) {
        if (l == 0L) {
            return "0";
        }
        String string3 = "";
        while (l != 0L) {
            string3 = string2.charAt((int)(l & (long)n2)) + string3;
            l >>>= n;
        }
        return string3;
    }

    private String pad(String string2) {
        String string3 = CJFormat.repeat(' ', this.width - string2.length());
        if (this.left_align) {
            return this.pre + string2 + string3 + this.post;
        }
        return this.pre + string3 + string2 + this.post;
    }

    private String sign(int n, String string2) {
        String string3 = "";
        if (n < 0) {
            string3 = "-";
        } else if (n > 0) {
            if (this.show_plus) {
                string3 = "+";
            } else if (this.show_space) {
                string3 = " ";
            }
        } else if (this.fmt == 'o' && this.alternate && string2.length() > 0 && string2.charAt(0) != '0') {
            string3 = "0";
        } else if (this.fmt == 'x' && this.alternate) {
            string3 = "0x";
        } else if (this.fmt == 'X' && this.alternate) {
            string3 = "0X";
        }
        int n2 = 0;
        if (this.leading_zeroes) {
            n2 = this.width;
        } else if ((this.fmt == 'd' || this.fmt == 'i' || this.fmt == 'x' || this.fmt == 'X' || this.fmt == 'o') && this.precision > 0) {
            n2 = this.precision;
        }
        return string3 + CJFormat.repeat('0', n2 - string3.length() - string2.length()) + string2;
    }

    private String fixed_format(double d) {
        String string2 = "";
        if (d > 9.223372036854776E18) {
            return this.exp_format(d);
        }
        long l = (long)(this.precision == 0 ? d + 0.5 : d);
        string2 = string2 + l;
        double d2 = d - (double)l;
        if (d2 >= 1.0 || d2 < 0.0) {
            return this.exp_format(d);
        }
        return string2 + this.frac_part(d2);
    }

    private String frac_part(double d) {
        String string2 = "";
        if (this.precision > 0) {
            double d2 = 1.0;
            String string3 = "";
            for (int i = 1; i <= this.precision && d2 <= 9.223372036854776E18; d2 *= 10.0, ++i) {
                string3 = string3 + "0";
            }
            long l = (long)(d2 * d + 0.5);
            string2 = string3 + l;
            string2 = string2.substring(string2.length() - this.precision, string2.length());
        }
        if (this.precision > 0 || this.alternate) {
            string2 = "." + string2;
        }
        if (!(this.fmt != 'G' && this.fmt != 'g' || this.alternate)) {
            int n;
            for (n = string2.length() - 1; n >= 0 && string2.charAt(n) == '0'; --n) {
            }
            if (n >= 0 && string2.charAt(n) == '.') {
                --n;
            }
            string2 = string2.substring(0, n + 1);
        }
        return string2;
    }

    private String exp_format(double d) {
        double d2;
        String string2 = "";
        int n = 0;
        double d3 = 1.0;
        if (d == Double.NaN) {
            return "NaN";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-Inf";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "Inf";
        }
        if (d == 0.0) {
            if (this.fmt == 'e' || this.fmt == 'E' || this.fmt == 'g' || this.fmt == 'G') {
                return "0.000E+00";
            }
            return "0.000";
        }
        for (d2 = d; d2 > 10.0; d2 /= 10.0) {
            ++n;
            d3 /= 10.0;
        }
        while (d2 < 1.0) {
            --n;
            d3 *= 10.0;
            d2 *= 10.0;
        }
        if ((this.fmt == 'g' || this.fmt == 'G') && n >= -4 && n < this.precision) {
            return this.fixed_format(d);
        }
        string2 = string2 + this.fixed_format(d *= d3);
        string2 = this.fmt == 'e' || this.fmt == 'g' ? string2 + "e" : string2 + "E";
        String string3 = "000";
        if (n >= 0) {
            string2 = string2 + "+";
            string3 = string3 + n;
        } else {
            string2 = string2 + "-";
            string3 = string3 + -n;
        }
        return string2 + string3.substring(string3.length() - 3, string3.length());
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setPrecision(int n) {
        this.precision = n;
    }

    public void setPre(String string2) {
        this.pre = string2;
    }

    public void setPost(String string2) {
        this.post = string2;
    }

    public void setLeadingZeroes(boolean bl) {
        this.leading_zeroes = bl;
    }

    public void setShowPlus(boolean bl) {
        this.show_plus = bl;
    }

    public void setAlternate(boolean bl) {
        this.alternate = bl;
    }

    public void setShowSpace(boolean bl) {
        this.show_space = bl;
    }

    public void setLeftAlign(boolean bl) {
        this.left_align = bl;
    }

    public void setFmt(char c) {
        this.fmt = c;
    }
}

