/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vinci.transport.vns.service;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.vinci.transport.document.XMLToVinci;
import org.apache.vinci.transport.vns.service.Service;
import org.apache.vinci.transport.vns.service.ServiceAlias;
import org.apache.vinci.transport.vns.service.ServiceInterface;
import org.apache.vinci.transport.vns.service.ServiceStack;
import org.apache.vinci.transport.vns.service.ServiceTree;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ServiceRegistry {
    static int minAutoPort = 10000;
    static int maxAutoPort = 11000;
    static int sizeAutoPort = 10;
    static int MAX_ALIAS_LINKS = 25;
    ServiceTree services = new ServiceTree();
    Hashtable bindings = new Hashtable();

    public void addBinding(Service S2) {
        String ip = S2.realhost;
        ArrayList<PortRange> v = null;
        if (ip != null) {
            v = (ArrayList<PortRange>)this.bindings.get(ip);
        }
        if (v == null) {
            v = new ArrayList<PortRange>();
        }
        v.add(new PortRange(S2.minport, S2.maxport));
        this.bindings.put(ip, v);
    }

    public void delBinding(Service S2) {
        ArrayList v = (ArrayList)this.bindings.get(S2.realhost);
        if (v == null) {
            return;
        }
        v.remove(new PortRange(S2.minport, S2.maxport));
        if (v.size() < 1) {
            this.bindings.remove(S2.realhost);
        }
    }

    public boolean checkConflict(String ip, int min2, int max2) {
        ArrayList v = (ArrayList)this.bindings.get(ip);
        if (v == null) {
            return false;
        }
        for (int i = 0; i < v.size(); ++i) {
            PortRange p = (PortRange)v.get(i);
            if ((p.minPort > min2 || min2 > p.maxPort) && (p.minPort > max2 || max2 > p.maxPort)) continue;
            return true;
        }
        return false;
    }

    public boolean checkBinding(Service S2) {
        String ip;
        Object O;
        if (S2.name == null || S2.name.trim().equals("")) {
            ServiceRegistry.pr("Service not added: Null name");
            return false;
        }
        int mylevel = this.getLevel(S2.name, S2.level);
        S2.level = "" + mylevel;
        if (this.services.find(S2.name) != null && !((O = this.services.find(S2.name)) instanceof ServiceAlias)) {
            Service[] objs = ((ServiceStack)O).get("None");
            for (int i = 0; i < objs.length; ++i) {
                Service srv = objs[i];
                if (srv == null || !srv.realhost.equals(S2.realhost) || !srv.level.equals(S2.level) || srv.instance != S2.instance) continue;
                ServiceRegistry.pr("Service not added: Found one with same everything");
                return false;
            }
        }
        if ((ip = S2.realhost) == null) {
            ServiceRegistry.pr("No IP provided");
            return false;
        }
        ServiceRegistry.pr("Checking binding for : " + ip);
        if (S2.minport <= 0 || S2.maxport <= 0) {
            if (!this.bindings.containsKey(ip)) {
                S2.minport = minAutoPort;
                S2.maxport = minAutoPort + sizeAutoPort - 1;
                ServiceRegistry.pr("Binding not found");
                return true;
            }
            for (int p = minAutoPort; p < maxAutoPort; p += sizeAutoPort) {
                if (this.checkConflict(ip, p, p + sizeAutoPort - 1)) continue;
                S2.minport = p;
                S2.maxport = p + sizeAutoPort - 1;
                return true;
            }
            return false;
        }
        if (ip == null || !this.bindings.containsKey(ip)) {
            return true;
        }
        return !this.checkConflict(ip, S2.minport, S2.maxport);
    }

    public boolean addService(Service S2) {
        ServiceRegistry.pr("Adding Service : " + S2.name);
        if (!this.checkBinding(S2)) {
            return false;
        }
        ServiceStack stack = this.getStack(S2.name, true);
        if (stack == null) {
            return false;
        }
        stack.add(S2);
        this.addBinding(S2);
        return true;
    }

    public boolean addAlias(ServiceAlias S2) {
        if (this.services.find(S2.name) != null) {
            return false;
        }
        if (this.services.find(S2.target) == null) {
            return false;
        }
        this.services.setitem(S2.name, S2);
        return true;
    }

    public boolean delAlias(String name) {
        Object o = this.services.find(name);
        if (o == null || !(o instanceof ServiceAlias)) {
            return false;
        }
        this.services.setitem(name, null);
        return true;
    }

    public boolean addEntry(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof ServiceAlias) {
            return this.addAlias((ServiceAlias)o);
        }
        return this.addService((Service)o);
    }

    public boolean updateService(Service S2) {
        ServiceStack stack = this.getStack(S2.name);
        if (stack == null) {
            return false;
        }
        return stack.update(S2);
    }

    public boolean delService(Service S2) {
        ServiceStack stack = this.getStack(S2.name);
        if (stack == null) {
            return false;
        }
        Object[] dellist = stack.delete(S2);
        if (dellist != null) {
            for (int i = 0; i < dellist.length; ++i) {
                this.delBinding((Service)dellist[i]);
            }
            return dellist.length > 0;
        }
        return false;
    }

    public Service[] getServices(String name) {
        return this.getServices(name, null, false);
    }

    public Service[] getServices(String name, String level) {
        return this.getServices(name, level, false);
    }

    public Service[] getServices(String name, int level) {
        return this.getServices(name, "" + level, false);
    }

    public Service[] getServices(String name, int level, boolean resolveAlias) {
        return this.getServices(name, "" + level, resolveAlias);
    }

    public Service[] getServices(String name, String level, boolean resolveAlias) {
        Object O = this.services.find(name);
        if (O != null) {
            if (resolveAlias) {
                for (int i = 0; ServiceAlias.isAlias(O) && i < MAX_ALIAS_LINKS; ++i) {
                    O = this.services.find(((ServiceAlias)O).target);
                }
            }
            if (ServiceAlias.isAlias(O)) {
                return null;
            }
            Service[] temp = ((ServiceStack)O).get(level);
            Service[] result2 = new Service[temp.length];
            for (int i = 0; i < temp.length; ++i) {
                result2[i] = temp[i];
            }
            return result2;
        }
        return null;
    }

    int getLevel(String name, String level) {
        ServiceStack S2 = this.getStack(name);
        if (S2 == null) {
            return ServiceStack.getAbsLevel(level);
        }
        return S2.absLevel(level);
    }

    ServiceStack getStack(String name) {
        return this.getStack(name, false);
    }

    ServiceStack getStack(String name, boolean create) {
        Object o = this.services.find(name);
        if (o == null) {
            if (create) {
                o = new ServiceStack(name);
                this.services.setitem(name, o);
            }
        } else if (o instanceof ServiceAlias) {
            o = null;
        }
        return (ServiceStack)o;
    }

    Object[] getEntries(String name) {
        return this.getEntries(name, -1);
    }

    Object[] getEntries(String name, int level) {
        return this.getEntries(name, "" + level);
    }

    Object[] getEntries(String name, String level) {
        Object o = this.services.find(name);
        if (o == null) {
            return null;
        }
        if (o instanceof ServiceAlias) {
            Object[] result2 = new Object[]{o};
            return result2;
        }
        return ((ServiceStack)o).get(level);
    }

    public Object[] listServices(String prefix, int level) {
        return this.listServices(prefix, "" + level);
    }

    public Object[] listServices(String prefix, String level) {
        if (prefix == null) {
            prefix = "";
        }
        ArrayList<Object> res = new ArrayList<Object>();
        Object[] items = this.services.findprefix(prefix);
        if (items == null) {
            return res.toArray();
        }
        for (int i = 0; i < items.length; ++i) {
            if (ServiceAlias.isAlias(items[i])) {
                res.add(items[i]);
                continue;
            }
            Service[] subitems = ((ServiceStack)items[i]).get(level);
            if (subitems == null) continue;
            for (int j = 0; j < subitems.length; ++j) {
                res.add(subitems[j]);
            }
        }
        return res.toArray();
    }

    public String[] listNames(String prefix, int level) {
        return this.listNames(prefix, "" + level);
    }

    public String[] listNames(String prefix, String level) {
        if (prefix == null) {
            prefix = "";
        }
        ArrayList<String> res = new ArrayList<String>();
        Object[] items = this.services.findprefix(prefix);
        if (items == null) {
            return new String[0];
        }
        for (int i = 0; i < items.length; ++i) {
            if (ServiceAlias.isAlias(items[i])) {
                res.add(((ServiceAlias)items[i]).name);
            }
            if (level != null && ((ServiceStack)items[i]).isEmpty(level)) continue;
            res.add(((ServiceStack)items[i]).name);
        }
        String[] result2 = new String[res.size()];
        for (int i = 0; i < res.size(); ++i) {
            result2[i] = res.get(i).toString();
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String fname) throws Exception {
        Document doc;
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        FileReader readme = new FileReader(fname);
        try {
            doc = docBuilder.parse(new InputSource(readme));
        }
        finally {
            readme.close();
        }
        Element root2 = doc.getDocumentElement();
        if (!root2.getNodeName().equals("CONFIGURATION")) {
            throw new RuntimeException("Illegal file specified");
        }
        NodeList services = doc.getElementsByTagName("SERVICE");
        for (int i = 0; i < services.getLength(); ++i) {
            ServiceInterface S2;
            block11: {
                Node N = services.item(i);
                Hashtable<String, Object> H = new Hashtable<String, Object>();
                NodeList children2 = N.getChildNodes();
                for (int j = 0; j < children2.getLength(); ++j) {
                    Node C = children2.item(j);
                    if (C.getNodeType() == 3) continue;
                    NodeList subchildren = C.getChildNodes();
                    if (subchildren.getLength() == 1 && C.getFirstChild().getNodeType() == 3) {
                        H.put(C.getNodeName(), C.getFirstChild().getNodeValue());
                        continue;
                    }
                    H.put(C.getNodeName(), XMLToVinci.xmlToVinciFrame(new StringReader(ServiceRegistry.constructXMLString(C, true))));
                }
                if (H.get("TARGET") == null || H.get("NAME") == null) {
                    try {
                        S2 = new Service(H);
                        break block11;
                    }
                    catch (RuntimeException e) {
                        System.err.println("Got exception while adding Service : " + H.get("NAME").toString());
                        System.err.println("Exception generated : " + e);
                        continue;
                    }
                }
                S2 = new ServiceAlias((String)H.get("NAME"), (String)H.get("TARGET"));
            }
            this.addEntry(S2);
        }
    }

    static String constructXMLString(Node C, boolean include) {
        if (C.getNodeType() == 3 || C.getNodeType() == 4) {
            if (C.getNodeType() == 4) {
                return "<![CDATA[" + C.getNodeValue() + "]]>";
            }
            return C.getNodeValue();
        }
        String result2 = "";
        if (include) {
            result2 = result2 + "<" + C.getNodeName() + ">";
        }
        NodeList N = C.getChildNodes();
        for (int i = 0; i < N.getLength(); ++i) {
            result2 = result2 + ServiceRegistry.constructXMLString(N.item(i), true);
        }
        if (include) {
            result2 = result2 + "</" + C.getNodeName() + ">";
        }
        return result2;
    }

    public void save(Writer F) throws IOException {
        F.write("<CONFIGURATION>\n");
        Object[] objs = this.listServices("", -1);
        if (objs != null) {
            for (int i = 0; i < objs.length; ++i) {
                if (objs[i] == null) continue;
                if (ServiceAlias.isAlias(objs[i])) {
                    F.write(((ServiceAlias)objs[i]).toXML());
                } else {
                    F.write(((Service)objs[i]).toXML());
                }
                F.write("\n");
            }
        }
        F.write("</CONFIGURATION>\n");
    }

    public static void main(String[] args) throws Exception {
        ServiceRegistry SR = new ServiceRegistry();
        SR.load(args[0]);
        FileWriter F = new FileWriter(args[0] + ".bak");
        SR.save(F);
        F.close();
    }

    public static void pr(String s) {
        System.out.println(s);
    }

    class PortRange {
        int minPort;
        int maxPort;

        PortRange(int min2, int max2) {
            this.minPort = min2;
            this.maxPort = max2;
        }

        public boolean equals(Object o) {
            if (!(o instanceof PortRange)) {
                return false;
            }
            PortRange p = (PortRange)o;
            return p.minPort == this.minPort && p.maxPort == this.maxPort;
        }
    }
}

