/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util.impl;

import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import org.apache.uima.internal.util.I18nUtil;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Log4jLogger_impl
implements Logger {
    private static final String EXCEPTION_MESSAGE = "Exception occurred";
    private org.apache.log4j.Logger logger = null;
    private ResourceManager mResourceManager = null;

    private Log4jLogger_impl(Class<?> component) {
        this.logger = component != null ? org.apache.log4j.Logger.getLogger(component) : org.apache.log4j.Logger.getLogger("org.apache.uima");
    }

    private Log4jLogger_impl() {
        this(null);
    }

    public static synchronized Logger getInstance(Class<?> component) {
        return new Log4jLogger_impl(component);
    }

    public static synchronized Logger getInstance() {
        return new Log4jLogger_impl();
    }

    @Override
    @Deprecated
    public void log(String aMessage) {
        if (this.isLoggable(Level.INFO)) {
            if (aMessage == null || aMessage.equals("")) {
                return;
            }
            String[] sourceInfo = this.getStackTraceInfo(new Throwable());
            org.apache.log4j.Logger.getLogger(sourceInfo[0]).info(aMessage);
        }
    }

    @Override
    @Deprecated
    public void log(String aResourceBundleName, String aMessageKey, Object[] aArguments) {
        if (this.isLoggable(Level.INFO)) {
            if (aMessageKey == null || aMessageKey.equals("")) {
                return;
            }
            String[] sourceInfo = this.getStackTraceInfo(new Throwable());
            org.apache.log4j.Logger.getLogger(sourceInfo[0]).info(I18nUtil.localizeMessage(aResourceBundleName, aMessageKey, aArguments, this.getExtensionClassLoader()));
        }
    }

    @Override
    @Deprecated
    public void logException(Exception aException) {
        if (this.isLoggable(Level.INFO)) {
            if (aException == null) {
                return;
            }
            String[] sourceInfo = this.getStackTraceInfo(new Throwable());
            org.apache.log4j.Logger.getLogger(sourceInfo[0]).info(EXCEPTION_MESSAGE, aException);
        }
    }

    @Override
    @Deprecated
    public void setOutputStream(OutputStream out) {
        throw new UnsupportedOperationException("Method setOutputStream(OutputStream out) not supported");
    }

    @Override
    @Deprecated
    public void setOutputStream(PrintStream out) {
        throw new UnsupportedOperationException("Method setOutputStream(PrintStream out) not supported");
    }

    @Override
    public boolean isLoggable(Level level) {
        org.apache.log4j.Level log4jLevel = this.getLog4jLevel(level);
        return this.logger.isEnabledFor(log4jLevel);
    }

    @Override
    public void setLevel(Level level) {
        org.apache.log4j.Level log4jLevel = this.getLog4jLevel(level);
        this.logger.setLevel(log4jLevel);
    }

    @Override
    public void log(Level level, String aMessage) {
        if (this.isLoggable(level)) {
            if (aMessage == null || aMessage.equals("")) {
                return;
            }
            org.apache.log4j.Level log4jLevel = this.getLog4jLevel(level);
            this.logger.log(log4jLevel, aMessage);
        }
    }

    @Override
    public void log(Level level, String aMessage, Object param1) {
        if (this.isLoggable(level)) {
            if (aMessage == null || aMessage.equals("")) {
                return;
            }
            org.apache.log4j.Level log4jLevel = this.getLog4jLevel(level);
            this.logger.log(log4jLevel, MessageFormat.format(aMessage, param1));
        }
    }

    @Override
    public void log(Level level, String aMessage, Object[] params) {
        if (this.isLoggable(level)) {
            if (aMessage == null || aMessage.equals("")) {
                return;
            }
            org.apache.log4j.Level log4jLevel = this.getLog4jLevel(level);
            this.logger.log(log4jLevel, MessageFormat.format(aMessage, params));
        }
    }

    @Override
    public void log(Level level, String aMessage, Throwable thrown) {
        if (this.isLoggable(level)) {
            org.apache.log4j.Level log4jLevel = this.getLog4jLevel(level);
            if (aMessage != null && !aMessage.equals("")) {
                this.logger.log(log4jLevel, aMessage, thrown);
            }
            if (thrown != null && (aMessage == null || aMessage.equals(""))) {
                this.logger.log(log4jLevel, EXCEPTION_MESSAGE, thrown);
            }
        }
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msgKey, Object param1) {
        if (this.isLoggable(level)) {
            if (msgKey == null || msgKey.equals("")) {
                return;
            }
            if (sourceClass == null) {
                sourceClass = "";
            }
            org.apache.log4j.Level log4jLevel = this.getLog4jLevel(level);
            this.logger.log(log4jLevel, I18nUtil.localizeMessage(bundleName, msgKey, new Object[]{param1}, this.getExtensionClassLoader()));
        }
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msgKey, Object[] params) {
        if (this.isLoggable(level)) {
            if (msgKey == null || msgKey.equals("")) {
                return;
            }
            if (sourceClass == null) {
                sourceClass = "";
            }
            org.apache.log4j.Level log4jLevel = this.getLog4jLevel(level);
            this.logger.log(log4jLevel, I18nUtil.localizeMessage(bundleName, msgKey, params, this.getExtensionClassLoader()));
        }
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msgKey, Throwable thrown) {
        if (this.isLoggable(level)) {
            org.apache.log4j.Level log4jLevel = this.getLog4jLevel(level);
            if (sourceClass == null) {
                sourceClass = "";
            }
            if (msgKey != null && !msgKey.equals("")) {
                org.apache.log4j.Logger.getLogger(sourceClass).log(log4jLevel, I18nUtil.localizeMessage(bundleName, msgKey, null, this.getExtensionClassLoader()), thrown);
            }
            if (thrown != null && (msgKey == null || msgKey.equals(""))) {
                org.apache.log4j.Logger.getLogger(sourceClass).log(log4jLevel, EXCEPTION_MESSAGE, thrown);
            }
        }
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msgKey) {
        if (this.isLoggable(level)) {
            if (msgKey == null || msgKey.equals("")) {
                return;
            }
            if (sourceClass == null) {
                sourceClass = "";
            }
            org.apache.log4j.Level log4jLevel = this.getLog4jLevel(level);
            org.apache.log4j.Logger.getLogger(sourceClass).log(log4jLevel, I18nUtil.localizeMessage(bundleName, msgKey, null, this.getExtensionClassLoader()));
        }
    }

    @Override
    public void setResourceManager(ResourceManager resourceManager) {
        this.mResourceManager = resourceManager;
    }

    private ClassLoader getExtensionClassLoader() {
        if (this.mResourceManager == null) {
            return null;
        }
        return this.mResourceManager.getExtensionClassLoader();
    }

    private org.apache.log4j.Level getLog4jLevel(Level level) {
        switch (level.toInteger()) {
            case 0x7FFFFFFF: {
                return org.apache.log4j.Level.OFF;
            }
            case 70000: {
                return org.apache.log4j.Level.ERROR;
            }
            case 60000: {
                return org.apache.log4j.Level.WARN;
            }
            case 50000: {
                return org.apache.log4j.Level.INFO;
            }
            case 40000: {
                return org.apache.log4j.Level.INFO;
            }
            case 30000: {
                return org.apache.log4j.Level.DEBUG;
            }
            case 20000: {
                return org.apache.log4j.Level.ALL;
            }
            case 10000: {
                return org.apache.log4j.Level.ALL;
            }
        }
        return org.apache.log4j.Level.ALL;
    }

    private String[] getStackTraceInfo(Throwable thrown) {
        StackTraceElement[] stackTraceElement = thrown.getStackTrace();
        String sourceMethod = "";
        String sourceClass = "";
        int lineNumber = 0;
        try {
            lineNumber = stackTraceElement[1].getLineNumber();
            sourceMethod = stackTraceElement[1].getMethodName();
            sourceClass = stackTraceElement[1].getClassName();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (lineNumber > 0) {
            StringBuffer buffer = new StringBuffer(25);
            buffer.append(sourceMethod);
            buffer.append("(");
            buffer.append(lineNumber);
            buffer.append(")");
            sourceMethod = buffer.toString();
        }
        return new String[]{sourceClass, sourceMethod};
    }
}

