/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.uimacpp;

import org.apache.uima.UIMARuntimeException;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.TypeOrFeature;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.admin.CASMgr;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CASMgrSerializer;
import org.apache.uima.cas.impl.CASSerializer;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.Serialization;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.uimacpp.InternalTafException;
import org.apache.uima.uimacpp.UimacppException;

public class UimacppEngine {
    private static String[] compatibleTafJniVersions;
    long cppEnginePointer = 0L;
    CAS cas = null;
    boolean hasNext = false;
    private static final int FSHEAP = 10;
    private static final int STRINGSYMBOL = 11;
    private static final int INDEXEDFSS = 30;
    private static final int BYTEHEAP = 12;
    private static final int SHORTHEAP = 13;
    private static final int LONGHEAP = 14;

    private static native void createResourceManagerJNI() throws InternalTafException;

    private static native void configureResourceManagerJNI(String var0, String var1) throws InternalTafException;

    private native void constructorJNI() throws InternalTafException;

    private native void destructorJNI() throws InternalTafException;

    private native void initializeJNI(String var1) throws InternalTafException;

    private native void typeSystemInitJNI(String[] var1, String[] var2, int[] var3, int[] var4, int var5, int[] var6, int[] var7, int[] var8, String[] var9, int[] var10, String[] var11, int[] var12, int[] var13, int[] var14, int[] var15) throws InternalTafException;

    private native void destroyJNI() throws InternalTafException;

    private native void resetJNI() throws InternalTafException;

    private native void fillCASJNI(int[] var1, int[] var2, String[] var3, byte[] var4, short[] var5, long[] var6);

    private native void processJNI(int var1, String var2, int[] var3, int[] var4) throws InternalTafException;

    private native void serializeCASJNI(boolean var1) throws InternalTafException;

    private native Object getSerializedDataJNI(int var1) throws InternalTafException;

    private native void batchProcessCompleteJNI() throws InternalTafException;

    private native void collectionProcessCompleteJNI() throws InternalTafException;

    private native boolean hasNextSegmentJNI() throws InternalTafException;

    private native void nextSegmentJNI() throws InternalTafException;

    private native void serializeSegmentJNI(boolean var1) throws InternalTafException;

    private native Object getSerializedSegmentDataJNI(int var1) throws InternalTafException;

    private native void releaseSegmentJNI() throws InternalTafException;

    private static native String getErrorMessageJNI(long var0) throws InternalTafException;

    private static native String getVersionJNI() throws InternalTafException;

    private static void createResourceManager() throws UimacppException {
        try {
            UimacppEngine.createResourceManagerJNI();
        }
        catch (Exception exc) {
            UimacppEngine.throwJTafException(exc);
        }
    }

    public static void configureResourceManager(String workDirectory, String dataDirectory) throws UimacppException {
        try {
            UimacppEngine.configureResourceManagerJNI(workDirectory, dataDirectory);
        }
        catch (Exception exc) {
            UimacppEngine.throwJTafException(exc);
        }
    }

    public UimacppEngine() throws UimacppException {
        try {
            this.constructorJNI();
        }
        catch (Exception exc) {
            UimacppEngine.throwJTafException(exc);
        }
    }

    public static UimacppEngine createJTafTAE(String configFile) throws UimacppException {
        UimacppEngine result2 = new UimacppEngine();
        result2.initialize(configFile);
        return result2;
    }

    static void printArray(String s, int[] ar) {
        System.out.println("int array " + s);
        for (int i = 0; i < ar.length; ++i) {
            System.out.println(i + ": " + ar[i]);
        }
        System.out.println();
    }

    static void printArray(String s, String[] ar) {
        System.out.println("String array " + s);
        for (int i = 0; i < ar.length; ++i) {
            System.out.println(i + ": " + ar[i]);
        }
        System.out.println();
    }

    void initialize(String config) throws UimacppException {
        try {
            this.initializeJNI(config);
        }
        catch (Exception exc) {
            UimacppEngine.throwJTafException(exc);
        }
    }

    void typeSystemInit(CASMgrSerializer casMgrSerializer) throws UimacppException {
        try {
            this.typeSystemInitJNI(casMgrSerializer.typeNames, casMgrSerializer.featureNames, casMgrSerializer.typeInheritance, casMgrSerializer.featDecls, casMgrSerializer.topTypeCode, casMgrSerializer.featureOffsets, casMgrSerializer.typeOrder, casMgrSerializer.stringSubtypes, casMgrSerializer.stringSubtypeValues, casMgrSerializer.stringSubtypeValuePos, casMgrSerializer.indexNames, casMgrSerializer.nameToIndexMap, casMgrSerializer.indexingStrategy, casMgrSerializer.comparatorIndex, casMgrSerializer.comparators);
        }
        catch (Exception exc) {
            UimacppEngine.throwJTafException(exc);
        }
    }

    public void destroy() throws UimacppException {
        try {
            this.destroyJNI();
        }
        catch (Exception exc) {
            UimacppEngine.throwJTafException(exc);
        }
    }

    private static void serializeResultSpecification(ResultSpecification rs, CASImpl cas, IntVector resultSpecTypes, IntVector resultSpecFeatures) {
        TypeOrFeature[] tofs = rs.getResultTypesAndFeatures();
        TypeSystemImpl tsImpl = cas.getTypeSystemImpl();
        for (int i = 0; i < tofs.length; ++i) {
            if (tofs[i].isType()) {
                TypeImpl t = (TypeImpl)tsImpl.getType(tofs[i].getName());
                resultSpecTypes.add(t.getCode());
                continue;
            }
            FeatureImpl f2 = (FeatureImpl)tsImpl.getFeatureByFullName(tofs[i].getName());
            resultSpecFeatures.add(f2.getCode());
        }
    }

    public void process(ResultSpecification rs, CAS aCas, boolean casIsEmpty) throws UimacppException {
        int isTCas = 0;
        String sofaName = aCas.getViewName();
        if (sofaName != null) {
            isTCas = 1;
        }
        this.cas = aCas.getCurrentView();
        try {
            this.resetJNI();
            if (!casIsEmpty) {
                CASSerializer casSerializerIn = Serialization.serializeCAS(this.cas);
                this.fillCASJNI(casSerializerIn.heapArray, casSerializerIn.fsIndex, casSerializerIn.stringTable, casSerializerIn.byteHeapArray, casSerializerIn.shortHeapArray, casSerializerIn.longHeapArray);
            }
            IntVector resultSpecTypes = new IntVector();
            IntVector resultSpecFeatures = new IntVector();
            if (rs != null) {
                UimacppEngine.serializeResultSpecification(rs, (CASImpl)this.cas, resultSpecTypes, resultSpecFeatures);
            }
            this.processJNI(isTCas, sofaName, resultSpecTypes.toArray(), resultSpecFeatures.toArray());
            if (this.hasNext()) {
                return;
            }
        }
        catch (Exception exc) {
            UimacppEngine.throwJTafException(exc);
        }
    }

    public boolean hasNext() throws UimacppException {
        try {
            this.hasNext = this.hasNextSegmentJNI();
            if (!this.hasNext) {
                CASSerializer casSerializerOut = new CASSerializer();
                this.serializeCASJNI(true);
                casSerializerOut.heapMetaData = null;
                casSerializerOut.heapArray = (int[])this.getSerializedDataJNI(10);
                casSerializerOut.fsIndex = (int[])this.getSerializedDataJNI(30);
                casSerializerOut.stringTable = (String[])this.getSerializedDataJNI(11);
                casSerializerOut.byteHeapArray = (byte[])this.getSerializedDataJNI(12);
                casSerializerOut.shortHeapArray = (short[])this.getSerializedDataJNI(13);
                casSerializerOut.longHeapArray = (long[])this.getSerializedDataJNI(14);
                CASMgr casMgr = (CASMgr)((Object)this.cas);
                CAS newCAS = Serialization.createCAS(casMgr, casSerializerOut);
                if (newCAS != casMgr) {
                    throw new RuntimeException("CASMgr and CAS should be identical");
                }
            }
        }
        catch (Exception exc) {
            UimacppEngine.throwJTafException(exc);
        }
        return this.hasNext;
    }

    public void next(CAS segment) throws UimacppException {
        block4: {
            try {
                if (this.hasNext) {
                    this.nextSegmentJNI();
                    CASSerializer casSerializerOut = new CASSerializer();
                    this.serializeSegmentJNI(true);
                    casSerializerOut.heapMetaData = null;
                    casSerializerOut.heapArray = (int[])this.getSerializedSegmentDataJNI(10);
                    casSerializerOut.fsIndex = (int[])this.getSerializedSegmentDataJNI(30);
                    casSerializerOut.stringTable = (String[])this.getSerializedSegmentDataJNI(11);
                    casSerializerOut.byteHeapArray = (byte[])this.getSerializedSegmentDataJNI(12);
                    casSerializerOut.shortHeapArray = (short[])this.getSerializedSegmentDataJNI(13);
                    casSerializerOut.longHeapArray = (long[])this.getSerializedSegmentDataJNI(14);
                    this.releaseSegmentJNI();
                    CASMgr casMgr = (CASMgr)((Object)segment);
                    CAS newCAS = Serialization.createCAS(casMgr, casSerializerOut);
                    if (newCAS != casMgr) {
                        throw new RuntimeException("CASMgr and CAS should be identical");
                    }
                    break block4;
                }
                throw new RuntimeException("This analysis component has no CASs to return.");
            }
            catch (Exception exc) {
                UimacppEngine.throwJTafException(exc);
            }
        }
    }

    public void batchProcessComplete() throws UimacppException {
        try {
            this.batchProcessCompleteJNI();
        }
        catch (Exception exc) {
            UimacppEngine.throwJTafException(exc);
        }
    }

    public void collectionProcessComplete() throws UimacppException {
        try {
            this.collectionProcessCompleteJNI();
        }
        catch (Exception exc) {
            UimacppEngine.throwJTafException(exc);
        }
    }

    public static String getErrorMessage(long errorCode) throws UimacppException {
        try {
            return UimacppEngine.getErrorMessageJNI(errorCode);
        }
        catch (Exception exc) {
            UimacppEngine.throwJTafException(exc);
            return null;
        }
    }

    public static String getTafJNIVersion() throws UimacppException {
        try {
            return UimacppEngine.getVersionJNI();
        }
        catch (Exception exc) {
            UimacppEngine.throwJTafException(exc);
            return null;
        }
    }

    static void throwJTafException(Exception exc) throws UimacppException {
        if (exc instanceof InternalTafException) {
            InternalTafException itExc = (InternalTafException)exc;
            long l = itExc.getTafErrorCode();
            switch ((int)l) {
                case 1000: 
                case 5000: 
                case 10000: {
                    throw new OutOfMemoryError();
                }
            }
            throw new UimacppException(itExc);
        }
        throw new UimacppException(exc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        UimacppEngine uimacppEngine = this;
        synchronized (uimacppEngine) {
            if (this.cppEnginePointer != 0L) {
                try {
                    this.destructorJNI();
                }
                catch (Exception exc) {
                    throw new UIMARuntimeException(exc);
                }
            }
            super.finalize();
        }
    }

    static {
        String osname;
        compatibleTafJniVersions = new String[]{"2.0"};
        String uimacpp_lib = "uima";
        String debug = System.getProperty("DEBUG_UIMACPP");
        if (debug != null && (osname = System.getProperty("os.name")).startsWith("Windows")) {
            uimacpp_lib = "uimaD";
        }
        System.loadLibrary(uimacpp_lib);
        try {
            String jniVersion = UimacppEngine.getTafJNIVersion();
            boolean compatible = false;
            for (int i = 0; i < compatibleTafJniVersions.length; ++i) {
                if (!jniVersion.equals(compatibleTafJniVersions[i])) continue;
                compatible = true;
                break;
            }
            if (!compatible) {
                throw new UIMARuntimeException("incompatible_taf_jni_library", new Object[]{jniVersion});
            }
            UimacppEngine.createResourceManager();
        }
        catch (UimacppException exc) {
            throw new UIMARuntimeException(exc.getEmbeddedException());
        }
    }
}

