/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.viewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.Scrollable;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.uima.cas.ArrayFS;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.SofaFS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.BooleanArrayFSImpl;
import org.apache.uima.cas.impl.ByteArrayFSImpl;
import org.apache.uima.cas.impl.CommonArrayFSImpl;
import org.apache.uima.cas.impl.CommonAuxArrayFSImpl;
import org.apache.uima.cas.impl.DoubleArrayFSImpl;
import org.apache.uima.cas.impl.FeatureStructureImplC;
import org.apache.uima.cas.impl.FloatArrayFSImpl;
import org.apache.uima.cas.impl.IntArrayFSImpl;
import org.apache.uima.cas.impl.LongArrayFSImpl;
import org.apache.uima.cas.impl.ShortArrayFSImpl;
import org.apache.uima.cas.impl.StringArrayFSImpl;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.tools.viewer.EntityResolver;

public class CasAnnotationViewer
extends JPanel
implements ActionListener,
MouseListener,
TreeWillExpandListener,
TreeExpansionListener,
ItemListener {
    private static final long serialVersionUID = 3559118488371946999L;
    private static final short MODE_ANNOTATIONS = 0;
    private static final short MODE_ENTITIES = 1;
    private ArrayList userTypes = null;
    private static final float BRIGHT = 0.95f;
    private static final Color[] COLORS = new Color[]{Color.getHSBColor(0.15277778f, 0.25f, 0.95f), Color.getHSBColor(0.0f, 0.25f, 0.95f), Color.getHSBColor(0.5833333f, 0.25f, 0.95f), Color.getHSBColor(0.33333334f, 0.25f, 0.95f), Color.getHSBColor(0.8055556f, 0.25f, 0.95f), Color.getHSBColor(0.083333336f, 0.25f, 0.95f), Color.getHSBColor(0.22222222f, 0.25f, 0.95f), Color.getHSBColor(0.9166667f, 0.25f, 0.95f), Color.getHSBColor(0.44444445f, 0.25f, 0.95f), Color.getHSBColor(0.6944444f, 0.25f, 0.95f), Color.getHSBColor(0.15277778f, 0.5f, 0.95f), Color.getHSBColor(0.0f, 0.5f, 0.95f), Color.getHSBColor(0.5833333f, 0.5f, 0.95f), Color.getHSBColor(0.33333334f, 0.5f, 0.95f), Color.getHSBColor(0.8055556f, 0.5f, 0.95f), Color.getHSBColor(0.083333336f, 0.5f, 0.95f), Color.getHSBColor(0.22222222f, 0.5f, 0.95f), Color.getHSBColor(0.9166667f, 0.5f, 0.95f), Color.getHSBColor(0.44444445f, 0.5f, 0.95f), Color.getHSBColor(0.6944444f, 0.5f, 0.95f), Color.getHSBColor(0.15277778f, 0.75f, 0.95f), Color.getHSBColor(0.0f, 0.75f, 0.95f), Color.getHSBColor(0.5833333f, 0.75f, 0.95f), Color.getHSBColor(0.33333334f, 0.75f, 0.95f), Color.getHSBColor(0.8055556f, 0.75f, 0.95f), Color.getHSBColor(0.083333336f, 0.75f, 0.95f), Color.getHSBColor(0.22222222f, 0.75f, 0.95f), Color.getHSBColor(0.9166667f, 0.75f, 0.95f), Color.getHSBColor(0.44444445f, 0.75f, 0.95f), Color.getHSBColor(0.6944444f, 0.75f, 0.95f)};
    private static String[] DEFAULT_HIDDEN_FEATURES = new String[]{"sofa"};
    private Map mTypeNameToColorMap = new HashMap();
    private HashSet noCheckSet = new HashSet();
    private List mHighFrequencyTypes = new ArrayList();
    private Set mDisplayedTypeNames = null;
    private Set mHiddenTypeNames = new HashSet();
    private Set mInitiallySelectedTypeNames = null;
    private Map mTypeToCheckboxMap = new HashMap();
    private Map mEntityToCheckboxMap = new HashMap();
    private CAS mCAS;
    private Type mStringType;
    private Type mFsArrayType;
    private boolean mConsistentColors = true;
    private Set mHiddenFeatureNames = new HashSet();
    private boolean mEntityViewEnabled = false;
    private short mViewMode = 0;
    private boolean mHideUnselectedCheckboxes = false;
    private JSplitPane horizSplitPane;
    private JSplitPane vertSplitPane;
    private JScrollPane textScrollPane;
    private JTextPane textPane;
    private JPanel legendPanel;
    private JLabel legendLabel;
    private JScrollPane legendScrollPane;
    private JPanel annotationCheckboxPanel;
    private JPanel entityCheckboxPanel;
    private JPanel buttonPanel;
    private JButton selectAllButton;
    private JButton deselectAllButton;
    private JButton showHideUnselectedButton;
    private JTree selectedAnnotationTree;
    private DefaultTreeModel selectedAnnotationTreeModel;
    private JPanel viewModePanel;
    private JRadioButton annotationModeButton;
    private JRadioButton entityModeButton;
    private String[] mBoldfaceKeywords = new String[0];
    private int[] mBoldfaceSpans = new int[0];
    private JPanel sofaSelectionPanel;
    private JComboBox sofaSelectionComboBox;
    private EntityResolver mEntityResolver = new DefaultEntityResolver();

    public ArrayList getUserTypes() {
        return this.userTypes;
    }

    public void setUserTypes(ArrayList userTypes) {
        this.userTypes = userTypes;
    }

    public CasAnnotationViewer() {
        this.horizSplitPane = new JSplitPane(1);
        this.horizSplitPane.setResizeWeight(0.6);
        this.setLayout(new BorderLayout());
        this.add(this.horizSplitPane);
        this.vertSplitPane = new JSplitPane(0);
        this.vertSplitPane.setResizeWeight(0.8);
        this.vertSplitPane.setPreferredSize(new Dimension(620, 600));
        this.vertSplitPane.setMinimumSize(new Dimension(200, 200));
        this.horizSplitPane.setLeftComponent(this.vertSplitPane);
        this.textPane = new JTextPane();
        this.textPane.setEditable(false);
        this.textPane.setPreferredSize(new Dimension(620, 400));
        this.textPane.setMinimumSize(new Dimension(200, 100));
        this.textScrollPane = new JScrollPane(this.textPane);
        this.vertSplitPane.setTopComponent(this.textScrollPane);
        this.legendPanel = new JPanel();
        this.legendPanel.setPreferredSize(new Dimension(620, 200));
        this.legendPanel.setLayout(new BorderLayout());
        this.legendLabel = new JLabel("Legend");
        this.legendPanel.add((Component)this.legendLabel, "North");
        this.legendScrollPane = new JScrollPane();
        this.legendScrollPane.setHorizontalScrollBarPolicy(31);
        this.legendPanel.add((Component)this.legendScrollPane, "Center");
        this.annotationCheckboxPanel = new VerticallyScrollablePanel();
        this.annotationCheckboxPanel.setLayout(new GridLayout(0, 5));
        this.entityCheckboxPanel = new VerticallyScrollablePanel();
        this.entityCheckboxPanel.setLayout(new GridLayout(0, 4));
        this.legendScrollPane.setViewportView(this.annotationCheckboxPanel);
        this.buttonPanel = new JPanel();
        this.selectAllButton = new JButton("Select All");
        this.selectAllButton.addActionListener(this);
        this.buttonPanel.add(this.selectAllButton);
        this.deselectAllButton = new JButton("Deselect All");
        this.deselectAllButton.addActionListener(this);
        this.buttonPanel.add(this.deselectAllButton);
        this.showHideUnselectedButton = new JButton("Hide Unselected");
        this.showHideUnselectedButton.addActionListener(this);
        this.buttonPanel.add(this.showHideUnselectedButton);
        this.sofaSelectionPanel = new JPanel();
        JLabel sofaSelectionLabel = new JLabel("Sofa:");
        this.sofaSelectionPanel.add(sofaSelectionLabel);
        this.sofaSelectionComboBox = new JComboBox();
        this.sofaSelectionPanel.add(this.sofaSelectionComboBox);
        this.sofaSelectionComboBox.addItemListener(this);
        this.buttonPanel.add(this.sofaSelectionPanel);
        this.viewModePanel = new JPanel();
        this.viewModePanel.add(new JLabel("Mode: "));
        this.annotationModeButton = new JRadioButton("Annotations");
        this.annotationModeButton.setSelected(true);
        this.annotationModeButton.addActionListener(this);
        this.viewModePanel.add(this.annotationModeButton);
        this.entityModeButton = new JRadioButton("Entities");
        this.entityModeButton.addActionListener(this);
        this.viewModePanel.add(this.entityModeButton);
        ButtonGroup group = new ButtonGroup();
        group.add(this.annotationModeButton);
        group.add(this.entityModeButton);
        this.buttonPanel.add(this.viewModePanel);
        this.viewModePanel.setVisible(false);
        this.add((Component)this.buttonPanel, "South");
        this.textPane.setMinimumSize(new Dimension(200, 100));
        this.vertSplitPane.setBottomComponent(this.legendPanel);
        this.selectedAnnotationTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode("Annotations"));
        this.selectedAnnotationTree = new JTree(this.selectedAnnotationTreeModel){
            private static final long serialVersionUID = -7882967150283952907L;

            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(230, 500);
            }
        };
        this.selectedAnnotationTree.setMinimumSize(new Dimension(50, 100));
        this.selectedAnnotationTree.setScrollsOnExpand(true);
        this.selectedAnnotationTree.setRootVisible(true);
        this.selectedAnnotationTree.setCellRenderer(new AnnotationTreeCellRenderer());
        this.selectedAnnotationTree.addTreeWillExpandListener(this);
        this.selectedAnnotationTree.addTreeExpansionListener(this);
        JPanel treePanel = new JPanel();
        treePanel.setLayout(new BorderLayout());
        treePanel.add((Component)new JLabel("Click In Text to See Annotation Detail"), "North");
        treePanel.add((Component)new JScrollPane(this.selectedAnnotationTree), "Center");
        this.horizSplitPane.setRightComponent(treePanel);
        this.textPane.addMouseListener(this);
        this.mHiddenFeatureNames.addAll(Arrays.asList(DEFAULT_HIDDEN_FEATURES));
    }

    @Deprecated
    public CasAnnotationViewer(boolean aEntityViewEnabled) {
        this();
    }

    public void setHighFrequencyTypes(String[] aTypeNames) {
        this.mHighFrequencyTypes.clear();
        this.mHighFrequencyTypes.addAll(Arrays.asList(aTypeNames));
        this.mTypeNameToColorMap.clear();
        this.assignColors(this.mHighFrequencyTypes);
    }

    public void setDisplayedTypes(String[] aDisplayedTypeNames) {
        if (aDisplayedTypeNames == null) {
            this.mDisplayedTypeNames = null;
        } else {
            this.mDisplayedTypeNames = new HashSet();
            this.mDisplayedTypeNames.addAll(Arrays.asList(aDisplayedTypeNames));
        }
    }

    public void setHiddenTypes(String[] aTypeNames) {
        this.mHiddenTypeNames.clear();
        this.mHiddenTypeNames.addAll(Arrays.asList(aTypeNames));
    }

    public void setInitiallySelectedTypes(String[] aTypeNames) {
        this.mInitiallySelectedTypeNames = new HashSet();
        for (int i = 0; i < aTypeNames.length; ++i) {
            this.mInitiallySelectedTypeNames.add(aTypeNames[i]);
        }
        for (Map.Entry entry : this.mTypeToCheckboxMap.entrySet()) {
            String type = ((Type)entry.getKey()).getName();
            JCheckBox checkbox = (JCheckBox)entry.getValue();
            checkbox.setSelected(this.typeNamesContains(this.mInitiallySelectedTypeNames, type));
        }
        if (this.mCAS != null) {
            this.display();
        }
    }

    public void setHiddenFeatures(String[] aFeatureNames) {
        this.mHiddenFeatureNames.clear();
        this.mHiddenFeatureNames.addAll(Arrays.asList(DEFAULT_HIDDEN_FEATURES));
        this.mHiddenFeatureNames.addAll(Arrays.asList(aFeatureNames));
    }

    public void setEntityViewEnabled(boolean aEnabled) {
        this.mEntityViewEnabled = aEnabled;
        this.viewModePanel.setVisible(aEnabled);
    }

    public void setEntityResolver(EntityResolver aEntityResolver) {
        this.mEntityResolver = aEntityResolver;
    }

    public void setConsistentColors(boolean aConsistent) {
        this.mConsistentColors = aConsistent;
    }

    public void setRightToLeftTextOrientation(boolean aRightToLeft) {
        this.textPane.applyComponentOrientation(aRightToLeft ? ComponentOrientation.RIGHT_TO_LEFT : ComponentOrientation.LEFT_TO_RIGHT);
    }

    public void setHideUnselectedCheckboxes(boolean aHideUnselected) {
        this.mHideUnselectedCheckboxes = aHideUnselected;
        this.display();
    }

    public void setCAS(CAS aCAS) {
        this.mCAS = aCAS;
        this.mStringType = this.mCAS.getTypeSystem().getType("uima.cas.String");
        this.mFsArrayType = this.mCAS.getTypeSystem().getType("uima.cas.FSArray");
        this.annotationCheckboxPanel.removeAll();
        this.entityCheckboxPanel.removeAll();
        this.mTypeToCheckboxMap.clear();
        this.mEntityToCheckboxMap.clear();
        this.updateSelectedAnnotationTree(-1);
        if (!this.mConsistentColors) {
            this.mTypeNameToColorMap.clear();
            this.assignColors(this.mHighFrequencyTypes);
        }
        this.mBoldfaceKeywords = new String[0];
        this.mBoldfaceSpans = new int[0];
        this.viewModePanel.setVisible(this.mEntityViewEnabled);
        this.sofaSelectionComboBox.removeAllItems();
        FSIterator<SofaFS> sofas = aCAS.getSofaIterator();
        Feature sofaIdFeat = aCAS.getTypeSystem().getFeatureByFullName("uima.cas.Sofa:sofaID");
        boolean nonDefaultSofaFound = false;
        while (sofas.hasNext()) {
            SofaFS sofa = (SofaFS)sofas.next();
            if (sofa.getLocalStringData() == null) continue;
            String sofaId = sofa.getStringValue(sofaIdFeat);
            if ("_InitialView".equals(sofaId)) {
                sofaId = "DEFAULT";
            } else {
                nonDefaultSofaFound = true;
            }
            this.sofaSelectionComboBox.addItem(sofaId);
            CAS viewOfSofa = aCAS.getView(sofa);
            if (viewOfSofa != aCAS) continue;
            this.sofaSelectionComboBox.setSelectedIndex(this.sofaSelectionComboBox.getItemCount() - 1);
        }
        if (this.sofaSelectionComboBox.getItemCount() == 0) {
            throw new RuntimeException("This CAS contains no document to view.");
        }
        this.sofaSelectionPanel.setVisible(nonDefaultSofaFound);
    }

    public void applyBoldfaceToKeywords(String[] aWords) {
        this.mBoldfaceKeywords = aWords;
        this.doBoldface();
    }

    public void applyBoldfaceToSpans(int[] aSpans) {
        this.mBoldfaceSpans = aSpans;
        this.doBoldface();
    }

    public void configureViewForXmlFragmentsQuery(String aQuery, String aTypeNamespace) {
        ArrayList<String> typeList = new ArrayList<String>();
        ArrayList<String> keywordList = new ArrayList<String>();
        String delims = "<>+-*\" \t\n";
        StringTokenizer tokenizer = new StringTokenizer(aQuery, delims, true);
        boolean inTag = false;
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            if ("<".equals(tok)) {
                inTag = true;
                continue;
            }
            if (">".equals(tok) && inTag) {
                inTag = false;
                continue;
            }
            if (delims.indexOf(tok) != -1) continue;
            if (inTag) {
                if (tok.startsWith("/")) continue;
                if (tok.endsWith("/")) {
                    tok = tok.substring(0, tok.length() - 1);
                }
                typeList.add(aTypeNamespace + '.' + tok);
                continue;
            }
            keywordList.add(tok);
        }
        this.setInitiallySelectedTypes(typeList.toArray(new String[0]));
        this.display();
        this.applyBoldfaceToKeywords(keywordList.toArray(new String[0]));
    }

    public void configureViewForXmlFragmentsQuery(String aQuery) {
        this.configureViewForXmlFragmentsQuery(aQuery, "*");
    }

    public void assignCheckedFromList(ArrayList aNotChecked) {
        for (String typeName : aNotChecked) {
            this.noCheckSet.add(typeName);
        }
    }

    public void assignColorsFromList(List aColors, ArrayList aTypeNames) {
        Iterator iter2 = aTypeNames.iterator();
        Iterator iterC = aColors.iterator();
        while (iter2.hasNext() && iterC.hasNext()) {
            String typeName = (String)iter2.next();
            Color color = (Color)iterC.next();
            this.mTypeNameToColorMap.put(typeName, color);
        }
        this.setUserTypes(aTypeNames);
        this.annotationCheckboxPanel.removeAll();
        this.mTypeToCheckboxMap.clear();
    }

    private void assignColors(List aTypeNames) {
        for (String typeName : aTypeNames) {
            Color c = COLORS[this.mTypeNameToColorMap.size() % COLORS.length];
            this.mTypeNameToColorMap.put(typeName, c);
        }
        this.annotationCheckboxPanel.removeAll();
        this.mTypeToCheckboxMap.clear();
    }

    private void display() {
        int dividerLoc = this.vertSplitPane.getDividerLocation();
        int caretPos = this.textPane.getCaretPosition();
        int verticalScrollPos = this.textScrollPane.getVerticalScrollBar().getValue();
        switch (this.mViewMode) {
            case 0: {
                this.displayAnnotations();
                break;
            }
            case 1: {
                this.displayEntities();
            }
        }
        this.doBoldface();
        if (this.mHideUnselectedCheckboxes) {
            this.showHideUnselectedButton.setText("Show Unselected");
        } else {
            this.showHideUnselectedButton.setText("Hide Unselected");
        }
        this.textPane.setCaretPosition(caretPos);
        this.textScrollPane.getVerticalScrollBar().setValue(verticalScrollPos);
        this.textScrollPane.revalidate();
        this.vertSplitPane.setDividerLocation(dividerLoc);
    }

    private void displayAnnotations() {
        StyledDocument doc = (StyledDocument)this.textPane.getDocument();
        DefaultStyledDocument blank = new DefaultStyledDocument();
        this.textPane.setDocument(blank);
        if (this.legendScrollPane.getViewport().getView() != this.annotationCheckboxPanel) {
            this.legendScrollPane.setViewportView(this.annotationCheckboxPanel);
        }
        try {
            doc.remove(0, doc.getLength());
            doc.insertString(0, this.mCAS.getDocumentText(), new SimpleAttributeSet());
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        FSIterator iter2 = this.mCAS.getAnnotationIndex().iterator();
        Hashtable<String, JCheckBox> checkBoxes = new Hashtable<String, JCheckBox>();
        HashSet<JCheckBox> checkBoxesDone = new HashSet<JCheckBox>();
        while (iter2.isValid()) {
            AnnotationFS fs = (AnnotationFS)iter2.get();
            iter2.moveToNext();
            Type type = fs.getType();
            JCheckBox checkbox = (JCheckBox)this.mTypeToCheckboxMap.get(type);
            if (checkbox == null) {
                if (this.mDisplayedTypeNames != null && !this.typeNamesContains(this.mDisplayedTypeNames, type.getName()) || this.typeNamesContains(this.mHiddenTypeNames, type.getName())) continue;
                Color c = (Color)this.mTypeNameToColorMap.get(type.getName());
                if (c == null) {
                    c = COLORS[this.mTypeNameToColorMap.size() % COLORS.length];
                    this.mTypeNameToColorMap.put(type.getName(), c);
                }
                String[] noCheckArray = new String[]{};
                for (int i = 0; i < noCheckArray.length; ++i) {
                    this.noCheckSet.add(noCheckArray[i]);
                }
                boolean selected = this.mInitiallySelectedTypeNames == null && !"uima.tcas.DocumentAnnotation".equals(type.getName()) && !this.noCheckSet.contains(type.getName()) || this.mInitiallySelectedTypeNames != null && this.typeNamesContains(this.mInitiallySelectedTypeNames, type.getName());
                checkbox = new JCheckBox(type.getShortName(), selected);
                checkbox.setToolTipText(type.getName());
                checkbox.addActionListener(this);
                checkbox.setBackground(c);
                checkBoxes.put(type.getName(), checkbox);
                checkBoxesDone.add(checkbox);
                this.mTypeToCheckboxMap.put(type, checkbox);
            }
            if (!checkbox.isSelected()) continue;
            int begin = fs.getBegin();
            int end = fs.getEnd();
            if (begin == 0 && end == this.mCAS.getDocumentText().length()) {
                --end;
            }
            if (begin >= end) continue;
            SimpleAttributeSet attrs = new SimpleAttributeSet();
            StyleConstants.setBackground(attrs, checkbox.getBackground());
            doc.setCharacterAttributes(begin, end - begin, attrs, false);
        }
        ArrayList aTypeNames = this.getUserTypes();
        if (aTypeNames != null) {
            for (String typeName : aTypeNames) {
                JCheckBox cb = (JCheckBox)checkBoxes.get(typeName);
                if (cb == null) continue;
                this.annotationCheckboxPanel.add(cb);
                checkBoxesDone.remove(cb);
            }
        }
        LinkedList checkboxes = new LinkedList(checkBoxesDone);
        Collections.sort(checkboxes, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((JCheckBox)o1).getText().toLowerCase().compareTo(((JCheckBox)o2).getText().toLowerCase());
            }
        });
        for (JCheckBox cb : checkboxes) {
            this.annotationCheckboxPanel.add(cb);
        }
        for (JCheckBox cb : this.mTypeToCheckboxMap.values()) {
            if (this.mHideUnselectedCheckboxes && !cb.isSelected()) {
                if (cb.getParent() != this.annotationCheckboxPanel) continue;
                this.annotationCheckboxPanel.remove(cb);
                continue;
            }
            if (cb.getParent() == this.annotationCheckboxPanel) continue;
            this.annotationCheckboxPanel.add(cb);
        }
        this.textPane.setDocument(doc);
    }

    private void displayEntities() {
        JCas jcas;
        StyledDocument doc = (StyledDocument)this.textPane.getDocument();
        DefaultStyledDocument blank = new DefaultStyledDocument();
        this.textPane.setDocument(blank);
        if (this.legendScrollPane.getViewport().getView() != this.entityCheckboxPanel) {
            this.legendScrollPane.setViewportView(this.entityCheckboxPanel);
        }
        try {
            doc.remove(0, doc.getLength());
            doc.insertString(0, this.mCAS.getDocumentText(), new SimpleAttributeSet());
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        try {
            jcas = this.mCAS.getJCas();
        }
        catch (CASException e) {
            throw new RuntimeException(e);
        }
        FSIterator iter2 = jcas.getAnnotationIndex().iterator();
        while (iter2.isValid()) {
            int end;
            int begin;
            Annotation annot = (Annotation)iter2.get();
            iter2.moveToNext();
            EntityResolver.Entity entity = this.mEntityResolver.getEntity(annot);
            if (entity == null) continue;
            JCheckBox checkbox = (JCheckBox)this.mEntityToCheckboxMap.get(entity);
            if (checkbox == null) {
                Color c = COLORS[this.mEntityToCheckboxMap.size() % COLORS.length];
                checkbox = new JCheckBox(entity.getCanonicalForm(), true);
                checkbox.setToolTipText(entity.getCanonicalForm());
                checkbox.addActionListener(this);
                checkbox.setBackground(c);
                this.entityCheckboxPanel.add(checkbox);
                this.mEntityToCheckboxMap.put(entity, checkbox);
            }
            if (!checkbox.isSelected() || (begin = annot.getBegin()) == (end = annot.getEnd())) continue;
            SimpleAttributeSet attrs = new SimpleAttributeSet();
            StyleConstants.setBackground(attrs, checkbox.getBackground());
            doc.setCharacterAttributes(begin, end - begin, attrs, false);
        }
        for (JCheckBox cb : this.mEntityToCheckboxMap.values()) {
            if (this.mHideUnselectedCheckboxes && !cb.isSelected()) {
                if (cb.getParent() != this.entityCheckboxPanel) continue;
                this.entityCheckboxPanel.remove(cb);
                continue;
            }
            if (cb.getParent() == this.entityCheckboxPanel) continue;
            this.entityCheckboxPanel.add(cb);
        }
        this.textPane.setDocument(doc);
    }

    private void updateSelectedAnnotationTree(int aPosition) {
        DefaultMutableTreeNode root2 = (DefaultMutableTreeNode)this.selectedAnnotationTreeModel.getRoot();
        root2.removeAllChildren();
        FSIterator annotIter = this.mCAS.getAnnotationIndex().iterator();
        while (annotIter.isValid()) {
            AnnotationFS annot = (AnnotationFS)annotIter.get();
            if (annot.getBegin() <= aPosition && annot.getEnd() > aPosition) {
                JCheckBox checkbox = (JCheckBox)this.mTypeToCheckboxMap.get(annot.getType());
                if (checkbox != null && checkbox.isSelected()) {
                    this.addAnnotationToTree(annot);
                }
            } else if (annot.getBegin() > aPosition) break;
            annotIter.moveToNext();
        }
        this.selectedAnnotationTreeModel.nodeStructureChanged(root2);
        this.selectedAnnotationTree.treeDidChange();
        this.selectedAnnotationTree.revalidate();
        this.horizSplitPane.revalidate();
    }

    protected void addAnnotationToTree(AnnotationFS aAnnotation) {
        DefaultMutableTreeNode root2 = (DefaultMutableTreeNode)this.selectedAnnotationTreeModel.getRoot();
        DefaultMutableTreeNode typeNode = null;
        Enumeration<TreeNode> typeNodes = root2.children();
        while (typeNodes.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)typeNodes.nextElement();
            if (!aAnnotation.getType().equals(((TypeTreeNodeObject)node.getUserObject()).getType())) continue;
            typeNode = node;
            break;
        }
        if (typeNode == null) {
            typeNode = new DefaultMutableTreeNode(new TypeTreeNodeObject(aAnnotation.getType()));
            root2.insert(typeNode, 0);
        }
        DefaultMutableTreeNode annotationNode = new DefaultMutableTreeNode(new FsTreeNodeObject(aAnnotation, null));
        typeNode.insert(annotationNode, 0);
        this.addFeatureTreeNodes(annotationNode, aAnnotation);
    }

    private void addFeatureTreeNodes(DefaultMutableTreeNode aParentNode, FeatureStructure aFS) {
        List<Feature> aFeatures = aFS.getType().getFeatures();
        for (Feature feat : aFeatures) {
            String featVal;
            String featName;
            block39: {
                int i;
                String rangeTypeName;
                Type rangeType;
                block37: {
                    block38: {
                        featName = feat.getShortName();
                        if (this.mHiddenFeatureNames.contains(featName)) continue;
                        featVal = "null";
                        rangeType = feat.getRange();
                        rangeTypeName = rangeType.getName();
                        if (!this.mCAS.getTypeSystem().subsumes(this.mStringType, rangeType)) break block37;
                        featVal = aFS.getStringValue(feat);
                        if (featVal != null) break block38;
                        featVal = "null";
                        break block39;
                    }
                    if (featVal.length() <= 64) break block39;
                    featVal = featVal.substring(0, 64) + "...";
                    break block39;
                }
                if (rangeType.isPrimitive()) {
                    featVal = aFS.getFeatureValueAsString(feat);
                } else if (this.mCAS.getTypeSystem().subsumes(this.mFsArrayType, rangeType)) {
                    ArrayFS arrayFS = (ArrayFS)aFS.getFeatureValue(feat);
                    if (arrayFS != null) {
                        DefaultMutableTreeNode arrayNode = new DefaultMutableTreeNode(featName + " = FSArray");
                        for (i = 0; i < arrayFS.size(); ++i) {
                            FeatureStructure fsVal = arrayFS.get(i);
                            if (fsVal != null) {
                                DefaultMutableTreeNode fsValNode = new DefaultMutableTreeNode(new FsTreeNodeObject(fsVal, featName));
                                if (!fsVal.getType().getFeatures().isEmpty()) {
                                    fsValNode.add(new DefaultMutableTreeNode(null));
                                }
                                arrayNode.add(fsValNode);
                                continue;
                            }
                            arrayNode.add(new DefaultMutableTreeNode("null"));
                        }
                        aParentNode.add(arrayNode);
                        continue;
                    }
                } else if (rangeType.isArray()) {
                    FeatureStructureImplC arrayFS;
                    String[] vals = null;
                    if ("uima.cas.StringArray".equals(rangeTypeName)) {
                        arrayFS = (StringArrayFSImpl)aFS.getFeatureValue(feat);
                        if (arrayFS != null) {
                            vals = ((StringArrayFSImpl)arrayFS).toArray();
                        }
                    } else if ("uima.cas.IntegerArray".equals(rangeTypeName)) {
                        arrayFS = (IntArrayFSImpl)aFS.getFeatureValue(feat);
                        if (arrayFS != null) {
                            vals = ((CommonArrayFSImpl)arrayFS).toStringArray();
                        }
                    } else if ("uima.cas.FloatArray".equals(rangeTypeName)) {
                        arrayFS = (FloatArrayFSImpl)aFS.getFeatureValue(feat);
                        if (arrayFS != null) {
                            vals = ((CommonArrayFSImpl)arrayFS).toStringArray();
                        }
                    } else if ("uima.cas.BooleanArray".equals(rangeTypeName)) {
                        arrayFS = (BooleanArrayFSImpl)aFS.getFeatureValue(feat);
                        if (arrayFS != null) {
                            vals = ((CommonAuxArrayFSImpl)arrayFS).toStringArray();
                        }
                    } else if ("uima.cas.ByteArray".equals(rangeTypeName)) {
                        arrayFS = (ByteArrayFSImpl)aFS.getFeatureValue(feat);
                        if (arrayFS != null) {
                            vals = ((CommonAuxArrayFSImpl)arrayFS).toStringArray();
                        }
                    } else if ("uima.cas.ShortArray".equals(rangeTypeName)) {
                        arrayFS = (ShortArrayFSImpl)aFS.getFeatureValue(feat);
                        if (arrayFS != null) {
                            vals = ((CommonAuxArrayFSImpl)arrayFS).toStringArray();
                        }
                    } else if ("uima.cas.LongArray".equals(rangeTypeName) && (arrayFS = (LongArrayFSImpl)aFS.getFeatureValue(feat)) != null) {
                        vals = ((LongArrayFSImpl)arrayFS).toStringArray();
                    }
                    if ("uima.cas.DoubleArray".equals(rangeTypeName) && (arrayFS = (DoubleArrayFSImpl)aFS.getFeatureValue(feat)) != null) {
                        vals = ((CommonAuxArrayFSImpl)arrayFS).toStringArray();
                    }
                    if (vals == null) {
                        featVal = "null";
                    } else {
                        StringBuffer displayVal = new StringBuffer();
                        displayVal.append('[');
                        for (i = 0; i < vals.length - 1; ++i) {
                            displayVal.append(vals[i]);
                            displayVal.append(',');
                        }
                        if (vals.length > 0) {
                            displayVal.append(vals[vals.length - 1]);
                        }
                        displayVal.append(']');
                        featVal = displayVal.toString();
                    }
                } else {
                    FeatureStructure fsVal = aFS.getFeatureValue(feat);
                    if (fsVal != null) {
                        DefaultMutableTreeNode fsValNode = new DefaultMutableTreeNode(new FsTreeNodeObject(fsVal, featName));
                        if (!fsVal.getType().getFeatures().isEmpty()) {
                            fsValNode.add(new DefaultMutableTreeNode(null));
                        }
                        aParentNode.add(fsValNode);
                        continue;
                    }
                }
            }
            aParentNode.add(new DefaultMutableTreeNode(featName + " = " + featVal));
        }
    }

    private boolean typeNamesContains(Set names, String name) {
        if (names.contains(name)) {
            return true;
        }
        for (String otherName : names) {
            if (!(otherName.indexOf(42) != -1 ? this.wildCardMatch(name, otherName) : otherName.equalsIgnoreCase(name))) continue;
            return true;
        }
        return false;
    }

    private boolean wildCardMatch(String s, String pattern) {
        StringBuffer regexpPatternBuffer = new StringBuffer();
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == '*') {
                regexpPatternBuffer.append('.');
            } else if (c == '.') {
                regexpPatternBuffer.append('\\');
            }
            if (Character.isLetter(c)) {
                regexpPatternBuffer.append('(').append(Character.toLowerCase(c)).append('|').append(Character.toUpperCase(c)).append(')');
                continue;
            }
            regexpPatternBuffer.append(c);
        }
        return s.matches(new String(regexpPatternBuffer));
    }

    public void setSize(Dimension d) {
        super.setSize(d);
        Insets insets = this.getInsets();
        Dimension paneSize = new Dimension(d.width - insets.left - insets.right, d.height - insets.top - insets.bottom);
        this.horizSplitPane.setPreferredSize(paneSize);
        this.horizSplitPane.setSize(paneSize);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.selectAllButton) {
            Iterator cbIter;
            Iterator iterator2 = cbIter = this.mViewMode == 0 ? this.mTypeToCheckboxMap.values().iterator() : this.mEntityToCheckboxMap.values().iterator();
            while (cbIter.hasNext()) {
                ((JCheckBox)cbIter.next()).setSelected(true);
            }
            this.display();
        } else if (e.getSource() == this.deselectAllButton) {
            Iterator cbIter;
            Iterator iterator3 = cbIter = this.mViewMode == 0 ? this.mTypeToCheckboxMap.values().iterator() : this.mEntityToCheckboxMap.values().iterator();
            while (cbIter.hasNext()) {
                ((JCheckBox)cbIter.next()).setSelected(false);
            }
            this.display();
        } else if (e.getSource() == this.annotationModeButton) {
            this.mViewMode = 0;
            this.display();
        } else if (e.getSource() == this.entityModeButton) {
            this.mViewMode = 1;
            this.display();
        } else if (e.getSource() == this.showHideUnselectedButton) {
            this.mHideUnselectedCheckboxes = !this.mHideUnselectedCheckboxes;
            this.display();
        } else if (e.getSource() instanceof JCheckBox) {
            this.display();
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this.mViewMode == 0) {
            int pos = this.textPane.viewToModel(e.getPoint());
            this.updateSelectedAnnotationTree(pos);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
    }

    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        TreeNode firstChild;
        DefaultMutableTreeNode expandedNode;
        Object userObj;
        Object lastPathComponent = event.getPath().getLastPathComponent();
        if (lastPathComponent instanceof DefaultMutableTreeNode && (userObj = (expandedNode = (DefaultMutableTreeNode)lastPathComponent).getUserObject()) instanceof FsTreeNodeObject && (firstChild = expandedNode.getFirstChild()) instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)firstChild).getUserObject() == null) {
            expandedNode.removeAllChildren();
            FeatureStructure fs = ((FsTreeNodeObject)userObj).getFS();
            this.addFeatureTreeNodes(expandedNode, fs);
            ((JTree)event.getSource()).treeDidChange();
        }
    }

    public void treeCollapsed(TreeExpansionEvent event) {
    }

    public void treeExpanded(TreeExpansionEvent event) {
        DefaultMutableTreeNode expandedNode;
        Object userObj;
        Object lastPathComponent = event.getPath().getLastPathComponent();
        if (lastPathComponent instanceof DefaultMutableTreeNode && (userObj = (expandedNode = (DefaultMutableTreeNode)lastPathComponent).getUserObject()) instanceof TypeTreeNodeObject && expandedNode.getChildCount() == 1) {
            TreePath childPath = event.getPath().pathByAddingChild(expandedNode.getFirstChild());
            ((JTree)event.getSource()).expandPath(childPath);
            ((JTree)event.getSource()).treeDidChange();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.sofaSelectionComboBox) {
            String sofaId = (String)e.getItem();
            this.mCAS = "DEFAULT".equals(sofaId) ? this.mCAS.getView("_InitialView") : this.mCAS.getView(sofaId);
            this.display();
        }
    }

    private void doBoldface() {
        if (this.mBoldfaceKeywords.length > 0) {
            StringBuffer regEx = new StringBuffer();
            for (int i = 0; i < this.mBoldfaceKeywords.length; ++i) {
                if (i > 0) {
                    regEx.append('|');
                }
                regEx.append("\\b");
                String word = this.mBoldfaceKeywords[i];
                for (int j = 0; j < word.length(); ++j) {
                    char c = word.charAt(j);
                    if (Character.isLetter(c)) {
                        regEx.append('[').append(Character.toLowerCase(c)).append(Character.toUpperCase(c)).append(']');
                        continue;
                    }
                    if (c == '.' || c == '^' || c == '&' || c == '\\' || c == '(' || c == ')') {
                        regEx.append('\\').append(c);
                        continue;
                    }
                    regEx.append('c');
                }
                regEx.append("\\b");
            }
            Pattern pattern = Pattern.compile(regEx.toString());
            Matcher matcher = pattern.matcher(this.mCAS.getDocumentText());
            int pos = 0;
            while (matcher.find(pos)) {
                SimpleAttributeSet attrs = new SimpleAttributeSet();
                StyleConstants.setBold(attrs, true);
                StyledDocument doc = (StyledDocument)this.textPane.getDocument();
                doc.setCharacterAttributes(matcher.start(), matcher.end() - matcher.start(), attrs, false);
                if (pos == matcher.end()) break;
                pos = matcher.end();
            }
        }
        int docLength = this.mCAS.getDocumentText().length();
        int len = this.mBoldfaceSpans.length;
        len -= len % 2;
        for (int i = 0; i < len; i += 2) {
            int begin = this.mBoldfaceSpans[i];
            int end = this.mBoldfaceSpans[i + 1];
            if (begin < 0 || begin > docLength || end < 0 || end > docLength) continue;
            SimpleAttributeSet attrs = new SimpleAttributeSet();
            StyleConstants.setBold(attrs, true);
            StyledDocument doc = (StyledDocument)this.textPane.getDocument();
            doc.setCharacterAttributes(begin, end - begin, attrs, false);
        }
    }

    protected JTree getSelectedAnnotationTree() {
        return this.selectedAnnotationTree;
    }

    static class DefaultEntityResolver
    implements EntityResolver {
        DefaultEntityResolver() {
        }

        public EntityResolver.Entity getEntity(final Annotation aAnnotation) {
            return new EntityResolver.Entity(){

                public String getCanonicalForm() {
                    return aAnnotation.getCoveredText();
                }

                public boolean equals(Object obj) {
                    if (obj instanceof EntityResolver.Entity) {
                        String canon = ((EntityResolver.Entity)obj).getCanonicalForm();
                        return this.getCanonicalForm().equals(canon);
                    }
                    return false;
                }

                public int hashCode() {
                    return this.getCanonicalForm().hashCode();
                }
            };
        }
    }

    static class VerticallyScrollablePanel
    extends JPanel
    implements Scrollable {
        private static final long serialVersionUID = 1009744410018634511L;

        VerticallyScrollablePanel() {
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 50;
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }
    }

    class AnnotationTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = -8661556785397184756L;

        AnnotationTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value2, boolean sel, boolean expanded, boolean leaf, int row, boolean aHasFocus) {
            Color background = null;
            if (value2 instanceof DefaultMutableTreeNode) {
                JCheckBox checkbox;
                Object userObj = ((DefaultMutableTreeNode)value2).getUserObject();
                Type type = null;
                if (userObj instanceof FsTreeNodeObject) {
                    FeatureStructure fs = ((FsTreeNodeObject)userObj).getFS();
                    type = fs.getType();
                } else if (userObj instanceof TypeTreeNodeObject) {
                    type = ((TypeTreeNodeObject)userObj).getType();
                }
                if (type != null && (checkbox = (JCheckBox)CasAnnotationViewer.this.mTypeToCheckboxMap.get(type)) != null) {
                    background = checkbox.getBackground();
                }
            }
            this.setBackgroundNonSelectionColor(background);
            this.setBackgroundSelectionColor(background);
            Component component = super.getTreeCellRendererComponent(tree, value2, sel, expanded, leaf, row, aHasFocus);
            return component;
        }
    }

    static class TypeTreeNodeObject {
        private Type mType;

        public TypeTreeNodeObject(Type aType) {
            this.mType = aType;
        }

        public Type getType() {
            return this.mType;
        }

        public String toString() {
            return this.mType.getShortName();
        }
    }

    static class FsTreeNodeObject {
        private FeatureStructure mFS;
        private String mFeatureName;
        private String mCaption;

        public FsTreeNodeObject(FeatureStructure aFS, String aFeatureName) {
            this.mFS = aFS;
            this.mFeatureName = aFeatureName;
            this.mCaption = this.mFS.getType().getShortName();
            if (this.mFS instanceof AnnotationFS) {
                String coveredText = ((AnnotationFS)this.mFS).getCoveredText();
                if (coveredText.length() > 64) {
                    coveredText = coveredText.substring(0, 64) + "...";
                }
                this.mCaption = this.mCaption + " (\"" + coveredText + "\")";
            }
            if (this.mFeatureName != null) {
                this.mCaption = this.mFeatureName + " = " + this.mCaption;
            }
        }

        public FeatureStructure getFS() {
            return this.mFS;
        }

        public String toString() {
            return this.mCaption;
        }
    }
}

