/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cpm;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.uima.collection.metadata.CasProcessorConfigurationParameterSettings;
import org.apache.uima.collection.metadata.NameValuePair;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.tools.cpm.ConfigField;
import org.apache.uima.tools.util.gui.FileSelector;
import org.apache.uima.tools.util.gui.FormPanel;
import org.apache.uima.tools.util.gui.ListSelector;

public class MetaDataPanel
extends FormPanel {
    private static final long serialVersionUID = 2002216386886772644L;
    ResourceMetaData metaData;
    ArrayList fieldsList = new ArrayList();

    public MetaDataPanel() {
    }

    public MetaDataPanel(int nrColumns) {
        super(nrColumns);
    }

    public void populate(ResourceMetaData md, CasProcessorConfigurationParameterSettings overrides) {
        this.metaData = md;
        ConfigurationParameterDeclarations cpd = this.metaData.getConfigurationParameterDeclarations();
        ConfigurationParameter[] parameters = cpd.getConfigurationParameters();
        ConfigurationParameterSettings cps = this.metaData.getConfigurationParameterSettings();
        if (parameters == null || cps == null) {
            return;
        }
        for (int i = 0; i < parameters.length; ++i) {
            String name = parameters[i].getName();
            String type = parameters[i].getType();
            boolean multiValued = parameters[i].isMultiValued();
            boolean requiresFileSelector = false;
            if ((name.endsWith("Dir") || name.endsWith("Directory") || name.endsWith("Descriptor") || name.indexOf("File") != -1) && type.equals("String")) {
                requiresFileSelector = true;
            }
            boolean justDirectories = false;
            if (requiresFileSelector && (name.endsWith("Dir") || name.endsWith("Directory"))) {
                justDirectories = true;
            }
            String caption = this.getCaptionFromName(name);
            this.add(new JLabel(caption));
            JComponent field2 = null;
            Object parameterValue = cps.getParameterValue(name);
            if (type.equals("Boolean")) {
                field2 = new JCheckBox((String)null, parameterValue == null ? false : (Boolean)parameterValue);
            } else if (!multiValued) {
                if (!requiresFileSelector) {
                    String stringValue = parameterValue == null ? "" : parameterValue.toString();
                    field2 = new JTextField(stringValue, 20);
                } else {
                    String filePath;
                    if (parameterValue == null) {
                        filePath = "";
                    } else {
                        File file = new File((String)parameterValue);
                        filePath = file.getPath();
                    }
                    int selectionMode = justDirectories ? 1 : 2;
                    field2 = new FileSelector(filePath, caption, selectionMode);
                }
            } else {
                field2 = parameterValue instanceof Object[] ? new ListSelector((Object[])parameterValue) : new ListSelector(new Object[0]);
            }
            this.add(field2);
            this.fieldsList.add(new ConfigField(name, type, multiValued, field2));
        }
        if (overrides != null) {
            NameValuePair[] nvps = overrides.getParameterSettings();
            for (int i = 0; i < nvps.length; ++i) {
                this.setValue(nvps[i].getName(), nvps[i].getValue());
            }
        }
    }

    public ResourceMetaData getMetaData() {
        return this.metaData;
    }

    public List getValues() {
        return this.fieldsList;
    }

    public void setValue(String fieldName, Object fieldValue) {
        for (int i = 0; i < this.fieldsList.size(); ++i) {
            ConfigField field2 = (ConfigField)this.fieldsList.get(i);
            if (!field2.getParameterName().equals(fieldName)) continue;
            field2.setFieldValue(fieldValue);
            return;
        }
    }

    public void clearAll() {
        Component[] components = this.gridBagPanel.getComponents();
        for (int i = components.length - 1; i >= 0; --i) {
            this.gridBagPanel.remove(i);
        }
        this.componentIndex = 0;
        this.fieldsList.clear();
    }

    public boolean isModified() {
        List fields = this.getValues();
        for (ConfigField fld : fields) {
            if (!fld.isModified()) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        List fields = this.getValues();
        for (ConfigField fld : fields) {
            if (!fld.isDirty()) continue;
            return true;
        }
        return false;
    }

    public void clearDirty() {
        List fields = this.getValues();
        for (ConfigField configField : fields) {
            configField.clearDirty();
        }
    }
}

