/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource.metadata.impl;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMA_IllegalArgumentException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypePriorityList;
import org.apache.uima.resource.metadata.impl.Import_impl;
import org.apache.uima.resource.metadata.impl.MetaDataObject_impl;
import org.apache.uima.resource.metadata.impl.PropertyXmlInfo;
import org.apache.uima.resource.metadata.impl.TypePriorityList_impl;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLizable;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypePriorities_impl
extends MetaDataObject_impl
implements TypePriorities {
    static final long serialVersionUID = -4773863151055424438L;
    private String mName;
    private String mVersion;
    private String mDescription;
    private String mVendor;
    private Import[] mImports = new Import[0];
    private List<TypePriorityList> mPriorityLists = new ArrayList<TypePriorityList>();

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void setName(String aName) {
        this.mName = aName;
    }

    @Override
    public String getVersion() {
        return this.mVersion;
    }

    @Override
    public void setVersion(String aVersion) {
        this.mVersion = aVersion;
    }

    @Override
    public String getDescription() {
        return this.mDescription;
    }

    @Override
    public void setDescription(String aDescription) {
        this.mDescription = aDescription;
    }

    @Override
    public String getVendor() {
        return this.mVendor;
    }

    @Override
    public void setVendor(String aVendor) {
        this.mVendor = aVendor;
    }

    @Override
    public Import[] getImports() {
        return this.mImports;
    }

    @Override
    public void setImports(Import[] aImports) {
        if (aImports == null) {
            throw new UIMA_IllegalArgumentException("illegal_argument", new Object[]{"null", "aImports", "setImports"});
        }
        this.mImports = aImports;
    }

    @Override
    public TypePriorityList[] getPriorityLists() {
        TypePriorityList[] result2 = new TypePriorityList[this.mPriorityLists.size()];
        this.mPriorityLists.toArray(result2);
        return result2;
    }

    @Override
    public void setPriorityLists(TypePriorityList[] aPriorityLists) {
        this.mPriorityLists.clear();
        for (int i = 0; i < aPriorityLists.length; ++i) {
            this.mPriorityLists.add(aPriorityLists[i]);
        }
    }

    @Override
    public void addPriorityList(TypePriorityList aPriorityList) {
        this.mPriorityLists.add(aPriorityList);
    }

    @Override
    public TypePriorityList addPriorityList() {
        TypePriorityList_impl newPriorityList = new TypePriorityList_impl();
        this.mPriorityLists.add(newPriorityList);
        return newPriorityList;
    }

    @Override
    public void removePriorityList(TypePriorityList aPriorityList) {
        this.mPriorityLists.remove(aPriorityList);
    }

    @Override
    public void resolveImports() throws InvalidXMLException {
        this.resolveImports(new TreeSet<String>(), UIMAFramework.newDefaultResourceManager());
    }

    @Override
    public void resolveImports(ResourceManager aResourceManager) throws InvalidXMLException {
        this.resolveImports(new TreeSet<String>(), aResourceManager);
    }

    @Override
    public void resolveImports(Collection<String> aAlreadyImportedTypePrioritiesURLs, ResourceManager aResourceManager) throws InvalidXMLException {
        if (this.getSourceUrl() != null) {
            aAlreadyImportedTypePrioritiesURLs.add(this.getSourceUrl().toString());
        }
        ArrayList<TypePriorityList> importedPriorityLists = new ArrayList<TypePriorityList>();
        Import[] imports = this.getImports();
        for (int i = 0; i < imports.length; ++i) {
            URL url;
            if (imports[i] instanceof Import_impl) {
                ((Import_impl)imports[i]).setSourceUrlIfNull(this.getSourceUrl());
            }
            if (aAlreadyImportedTypePrioritiesURLs.contains((url = imports[i].findAbsoluteUrl(aResourceManager)).toString())) continue;
            aAlreadyImportedTypePrioritiesURLs.add(url.toString());
            try {
                this.resolveImport(url, aAlreadyImportedTypePrioritiesURLs, importedPriorityLists, aResourceManager);
                continue;
            }
            catch (IOException e) {
                throw new InvalidXMLException("import_failed_could_not_read_from_url", new Object[]{url, imports[i].getSourceUrlString()}, e);
            }
        }
        TypePriorityList[] existingPriorityLists = this.getPriorityLists();
        if (existingPriorityLists == null) {
            existingPriorityLists = new TypePriorityList[]{};
        }
        TypePriorityList[] newPriorityLists = new TypePriorityList[existingPriorityLists.length + importedPriorityLists.size()];
        System.arraycopy(existingPriorityLists, 0, newPriorityLists, 0, existingPriorityLists.length);
        for (int i = 0; i < importedPriorityLists.size(); ++i) {
            newPriorityLists[existingPriorityLists.length + i] = (TypePriorityList)importedPriorityLists.get(i);
        }
        this.setPriorityLists(newPriorityLists);
        this.setImports(new Import[0]);
    }

    private void resolveImport(URL aURL, Collection<String> aAlreadyImportedTypePrioritiesURLs, Collection<TypePriorityList> aResults, ResourceManager aResourceManager) throws InvalidXMLException, IOException {
        TypePriorities desc;
        String urlString = aURL.toString();
        XMLizable cachedObject = aResourceManager.getImportCache().get(urlString);
        if (cachedObject instanceof TypePriorities) {
            desc = (TypePriorities)cachedObject;
        } else {
            XMLInputSource input2 = new XMLInputSource(aURL);
            desc = UIMAFramework.getXMLParser().parseTypePriorities(input2);
            desc.resolveImports(aAlreadyImportedTypePrioritiesURLs, aResourceManager);
            aResourceManager.getImportCache().put(urlString, desc);
        }
        aResults.addAll(Arrays.asList(desc.getPriorityLists()));
    }

    @Override
    protected void writePropertyAsElement(PropertyXmlInfo aPropInfo, String aNamespace, ContentHandler aContentHandler) throws SAXException {
        if ("priorityLists".equals(aPropInfo.propertyName)) {
            this.writeArrayPropertyAsElement(aPropInfo.propertyName, TypePriorityList[].class, this.getPriorityLists(), null, aNamespace, aContentHandler);
        } else {
            super.writePropertyAsElement(aPropInfo, aNamespace, aContentHandler);
        }
    }

    @Override
    public Object clone() {
        TypePriorities_impl clone2 = (TypePriorities_impl)super.clone();
        clone2.mPriorityLists = new ArrayList<TypePriorityList>();
        for (TypePriorityList priList : this.mPriorityLists) {
            clone2.addPriorityList((TypePriorityList)priList.clone());
        }
        return clone2;
    }

    @Override
    protected XmlizationInfo getXmlizationInfo() {
        return new XmlizationInfo("typePriorities", new PropertyXmlInfo[]{new PropertyXmlInfo("name", true), new PropertyXmlInfo("description", true), new PropertyXmlInfo("version", true), new PropertyXmlInfo("vendor", true), new PropertyXmlInfo("imports", true), new PropertyXmlInfo("priorityLists", true)});
    }
}

