/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.pear.util;

import java.io.BufferedReader;
import java.io.CharConversionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.uima.pear.util.FileUtil;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLUtil {
    public static final String XML_HEADER_BEG = "<?xml version=\"1.0\"";
    public static final String XML_ENCODING_TAG = "encoding";
    public static final String XML_HEADER_END = "?>";
    public static final String CDATA_SECTION_BEG = "<![CDATA[";
    public static final String CDATA_SECTION_END = "]]>";
    public static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    public static final String NAMESPACE_PREFIXES_FEATURE_ID = "http://xml.org/sax/features/namespace-prefixes";
    public static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    public static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    public static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    public static final String DYNAMIC_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/dynamic";
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_NAMESPACE_PREFIXES = false;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_DYNAMIC_VALIDATION = false;
    protected static final String FIRST_XML_CHARS = "<?";

    public static SAXParser createSAXParser() throws SAXException {
        SAXParser parser = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setFeature(NAMESPACES_FEATURE_ID, true);
            factory.setFeature(NAMESPACE_PREFIXES_FEATURE_ID, false);
            factory.setFeature(VALIDATION_FEATURE_ID, false);
            parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException exc) {
            throw new SAXException(exc);
        }
        return parser;
    }

    public static String detectXmlFileEncoding(File xmlFile) throws IOException {
        String encoding;
        block58: {
            encoding = null;
            FileInputStream iStream = null;
            BufferedReader fReader = null;
            try {
                String xmlLine;
                int offset;
                int bytesRead;
                int i;
                if (!XMLUtil.isValidXmlFile(xmlFile)) {
                    String string2 = null;
                    return string2;
                }
                iStream = new FileInputStream(xmlFile);
                int byteCounter = 0;
                int nextByte = 0;
                int[] prefix = new int[16];
                do {
                    nextByte = iStream.read();
                    if (byteCounter < 16) {
                        prefix[byteCounter] = nextByte;
                    }
                    ++byteCounter;
                    if (nextByte >= 0) continue;
                    throw new IOException("cannot read file");
                } while (nextByte == 239 || nextByte == 187 || nextByte == 191 || nextByte == 254 || nextByte == 255 || nextByte == 0);
                int prefixLength = byteCounter < 17 ? byteCounter - 1 : 16;
                String utfSignature = prefixLength > 0 ? FileUtil.identifyUtfSignature(prefix, prefixLength) : null;
                boolean utf8Signature = false;
                boolean utf16Signature = false;
                boolean utf32Signature = false;
                if (utfSignature != null) {
                    if (utfSignature.startsWith("UTF-8")) {
                        utf8Signature = true;
                    } else if (utfSignature.startsWith("UTF-16")) {
                        utf16Signature = true;
                    } else if (utfSignature.startsWith("UTF-32")) {
                        utf32Signature = true;
                    }
                }
                byte[] buffer = null;
                int bytes2put = 0;
                if (utf16Signature) {
                    bytes2put = 14;
                    buffer = new byte[prefixLength + bytes2put];
                    for (i = 0; i < prefixLength; ++i) {
                        buffer[i] = (byte)prefix[i];
                    }
                    byteCounter = prefixLength;
                } else if (utf32Signature) {
                    bytes2put = 28;
                    buffer = new byte[prefixLength + bytes2put];
                    for (i = 0; i < prefixLength; ++i) {
                        buffer[i] = (byte)prefix[i];
                    }
                    byteCounter = prefixLength;
                } else {
                    bytes2put = 7;
                    buffer = new byte[bytes2put];
                    byteCounter = 0;
                }
                buffer[byteCounter++] = (byte)nextByte;
                for (offset = 0; offset < bytes2put - 1 && (bytesRead = iStream.read(buffer, offset + byteCounter, bytes2put - 1 - offset)) != -1; offset += bytesRead) {
                }
                if (offset != bytes2put - 1) {
                    throw new IOException("cannot read file");
                }
                if (utf8Signature) {
                    String test2 = new String(buffer, "UTF-8");
                    if (test2.startsWith(FIRST_XML_CHARS)) {
                        encoding = "UTF-8";
                    }
                } else if (utf16Signature) {
                    String test3 = new String(buffer, "UTF-16");
                    if (test3.startsWith(FIRST_XML_CHARS)) {
                        encoding = "UTF-16";
                    }
                } else if (!utf32Signature) {
                    String test4 = new String(buffer, "UTF-8");
                    if (test4.startsWith(FIRST_XML_CHARS)) {
                        encoding = "UTF-8";
                    } else {
                        test4 = new String(buffer, "UTF-16LE");
                        if (test4.startsWith(FIRST_XML_CHARS)) {
                            encoding = "UTF-16LE";
                        } else {
                            test4 = new String(buffer, "UTF-16BE");
                            if (test4.startsWith(FIRST_XML_CHARS)) {
                                encoding = "UTF-16BE";
                            }
                        }
                    }
                }
                iStream.close();
                if (encoding != null) break block58;
                fReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(xmlFile), "UTF-8"));
                String line = null;
                try {
                    while ((line = fReader.readLine()) != null) {
                        xmlLine = line.trim();
                        if (xmlLine.length() <= 0) continue;
                        if (xmlLine.charAt(0) == '<') {
                            encoding = "UTF-8";
                        }
                        break;
                    }
                }
                catch (CharConversionException err2) {
                    // empty catch block
                }
                fReader.close();
                if (encoding != null) break block58;
                fReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(xmlFile), "UTF-16"));
                try {
                    while ((line = fReader.readLine()) != null) {
                        xmlLine = line.trim();
                        if (xmlLine.length() <= 0) continue;
                        if (xmlLine.charAt(0) == '<') {
                            encoding = "UTF-16";
                        }
                        break;
                    }
                }
                catch (CharConversionException err3) {
                    // empty catch block
                }
                fReader.close();
            }
            catch (IOException exc) {
                throw exc;
            }
            catch (Throwable err4) {
                throw new IOException(err4.toString());
            }
            finally {
                if (iStream != null) {
                    try {
                        iStream.close();
                    }
                    catch (Exception e) {}
                }
                if (fReader != null) {
                    try {
                        fReader.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        return encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidXmlFile(File xmlFile) throws IOException {
        boolean isValid = true;
        FileInputStream iStream = null;
        try {
            iStream = new FileInputStream(xmlFile);
            SAXParser parser = XMLUtil.createSAXParser();
            parser.parse((InputStream)iStream, new DefaultHandler());
        }
        catch (IOException exc) {
            throw exc;
        }
        catch (SAXException err2) {
            isValid = false;
        }
        finally {
            if (iStream != null) {
                try {
                    ((InputStream)iStream).close();
                }
                catch (Exception exception) {}
            }
        }
        return isValid;
    }

    public static void printError(String type, SAXParseException ex) {
        System.err.print("[");
        System.err.print(type);
        System.err.print("] ");
        if (ex == null) {
            System.err.print("SAX Parse Exception was null! Therefore, no further details are available.");
        } else {
            String systemId = ex.getSystemId();
            if (systemId != null) {
                int index = systemId.lastIndexOf(47);
                if (index != -1) {
                    systemId = systemId.substring(index + 1);
                }
                System.err.print(systemId);
            }
            System.err.print(':');
            System.err.print(ex.getLineNumber());
            System.err.print(':');
            System.err.print(ex.getColumnNumber());
            System.err.print(": ");
            System.err.print(ex.getMessage());
        }
        System.err.println();
        System.err.flush();
    }

    public static void printAllXMLElements(Properties elements, PrintWriter oWriter, int level) throws IOException {
        XMLUtil.printAllXMLElements(elements, null, oWriter, level);
    }

    public static void printAllXMLElements(Properties elements, String valueDelimiter, String[] tagOrder, PrintWriter oWriter, int level) throws IOException {
        boolean multiValue;
        boolean bl = multiValue = valueDelimiter != null && valueDelimiter.length() > 0;
        if (elements != null) {
            String tag;
            if (tagOrder != null) {
                for (int i = 0; i < tagOrder.length; ++i) {
                    tag = tagOrder[i];
                    String eValue = elements.getProperty(tag);
                    if (eValue == null) continue;
                    if (multiValue) {
                        XMLUtil.printXMLElements(tag, eValue, valueDelimiter, oWriter, level);
                        continue;
                    }
                    XMLUtil.printXMLElement(tag, eValue, oWriter, level);
                    oWriter.println();
                }
            }
            Enumeration<Object> keys = elements.keys();
            while (keys.hasMoreElements()) {
                tag = (String)keys.nextElement();
                boolean done = false;
                if (tagOrder != null) {
                    for (int i = 0; i < tagOrder.length; ++i) {
                        if (!tag.equals(tagOrder[i])) continue;
                        done = true;
                        break;
                    }
                }
                if (done) continue;
                String eValue = elements.getProperty(tag);
                if (multiValue) {
                    XMLUtil.printXMLElements(tag, eValue, valueDelimiter, oWriter, level);
                    continue;
                }
                XMLUtil.printXMLElement(tag, eValue, oWriter, level);
                oWriter.println();
            }
        }
    }

    public static void printAllXMLElements(Properties elements, String[] tagOrder, PrintWriter oWriter, int level) throws IOException {
        XMLUtil.printAllXMLElements(elements, null, tagOrder, oWriter, level);
    }

    public static void printXMLElement(String tag, Properties attributes, PrintWriter oWriter, int level) throws IOException {
        XMLUtil.printXMLElement(tag, attributes, null, oWriter, level);
    }

    public static void printXMLElement(String tag, Properties attributes, String elemValue, PrintWriter oWriter, int level) throws IOException {
        XMLUtil.printXMLElement(tag, attributes, elemValue, false, oWriter, level, false);
    }

    public static void printXMLElement(String tag, Properties attributes, String elemValue, boolean putInCdataSection, PrintWriter oWriter, int level) throws IOException {
        XMLUtil.printXMLElement(tag, attributes, elemValue, putInCdataSection, oWriter, level, false);
    }

    public static void printXMLElement(String tag, Properties attributes, String elemValue, boolean putInCdataSection, PrintWriter oWriter, int level, boolean useNewLine4Value) throws IOException {
        XMLUtil.printXMLTag(tag, attributes, oWriter, false, level);
        if (useNewLine4Value) {
            oWriter.println();
            XMLUtil.printXMLElementValue(elemValue, putInCdataSection, oWriter, level);
            oWriter.println();
            XMLUtil.printXMLTag(tag, oWriter, true, level);
        } else {
            XMLUtil.printXMLElementValue(elemValue, putInCdataSection, oWriter, 0);
            XMLUtil.printXMLTag(tag, oWriter, true, 0);
        }
    }

    public static void printXMLElement(String tag, String elemValue, PrintWriter oWriter, int level) throws IOException {
        XMLUtil.printXMLElement(tag, null, elemValue, oWriter, level);
    }

    public static void printXMLElement(String tag, String elemValue, boolean putInCdataSection, PrintWriter oWriter, int level) throws IOException {
        XMLUtil.printXMLElement(tag, null, elemValue, putInCdataSection, oWriter, level);
    }

    public static void printXMLElements(String tag, String elemValue, String valueDelimiter, PrintWriter oWriter, int level) throws IOException {
        if (elemValue != null) {
            StringTokenizer elemTokens = new StringTokenizer(elemValue, valueDelimiter);
            while (elemTokens.hasMoreTokens()) {
                String elemToken = elemTokens.nextToken();
                XMLUtil.printXMLElement(tag, elemToken, oWriter, level);
                oWriter.println();
            }
        }
    }

    public static void printXMLElementValue(String elemValue, PrintWriter oWriter, int level) throws IOException {
        XMLUtil.printXMLElementValue(elemValue, false, oWriter, level);
    }

    public static void printXMLElementValue(String elemValue, boolean putInCdataSection, PrintWriter oWriter, int level) throws IOException {
        for (int l = 0; l < level; ++l) {
            oWriter.print('\t');
        }
        if (elemValue != null) {
            if (putInCdataSection) {
                oWriter.print(CDATA_SECTION_BEG);
            }
            oWriter.print(elemValue.trim());
            if (putInCdataSection) {
                oWriter.print(CDATA_SECTION_END);
            }
            oWriter.flush();
        }
    }

    public static void printXMLHeader(String encoding, PrintWriter oWriter) throws IOException {
        oWriter.print(XML_HEADER_BEG);
        if (encoding != null && encoding.length() > 0) {
            oWriter.print(" encoding=\"" + encoding + "\"");
        }
        oWriter.println(XML_HEADER_END);
    }

    public static void printXMLTag(String tag, PrintWriter oWriter, boolean tagEnd, int level) throws IOException {
        XMLUtil.printXMLTag(tag, null, oWriter, tagEnd, level);
    }

    public static void printXMLTag(String tag, Properties attributes, PrintWriter oWriter, boolean tagEnd, int level) throws IOException {
        for (int l = 0; l < level; ++l) {
            oWriter.print('\t');
        }
        if (tagEnd) {
            oWriter.print("</");
        } else {
            oWriter.print('<');
        }
        oWriter.print(tag);
        if (!tagEnd && attributes != null) {
            Enumeration<Object> attrNames = attributes.keys();
            while (attrNames.hasMoreElements()) {
                String name = (String)attrNames.nextElement();
                String value2 = attributes.getProperty(name);
                oWriter.print(' ');
                oWriter.print(name);
                oWriter.print("=\"");
                oWriter.print(value2);
                oWriter.print('\"');
            }
        }
        oWriter.print('>');
        oWriter.flush();
    }
}

