/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSGenerator;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.CommonArray_Type;
import org.apache.uima.jcas.cas.ShortArray;
import org.apache.uima.jcas.cas.TOP;

public final class ShortArray_Type
extends CommonArray_Type {
    public static final int typeIndexID = ShortArray.typeIndexID;
    private final FSGenerator fsGenerator = new FSGenerator(){

        public FeatureStructure createFS(int addr, CASImpl cas) {
            if (ShortArray_Type.this.useExistingInstance) {
                TOP fs = ShortArray_Type.this.jcas.getJfsFromCaddr(addr);
                if (null == fs) {
                    fs = new ShortArray(addr, ShortArray_Type.this);
                    ShortArray_Type.this.jcas.putJfsFromCaddr(addr, fs);
                    return fs;
                }
                return fs;
            }
            return new ShortArray(addr, ShortArray_Type.this);
        }
    };

    protected FSGenerator getFSGenerator() {
        return this.fsGenerator;
    }

    private ShortArray_Type() {
    }

    public ShortArray_Type(JCas jcas, Type casType) {
        super(jcas, casType);
        this.casImpl.getFSClassRegistry().addGeneratorForType((TypeImpl)this.casType, this.getFSGenerator());
    }

    public short get(int addr, int i) {
        if (this.lowLevelTypeChecks) {
            return this.ll_cas.ll_getShortArrayValue(addr, i, true);
        }
        if (this.lowLevelArrayBoundChecks) {
            this.casImpl.checkArrayBounds(addr, i);
        }
        return this.ll_cas.ll_getShortArrayValue(addr, i);
    }

    public void set(int addr, int i, short v) {
        if (this.lowLevelTypeChecks) {
            this.ll_cas.ll_setShortArrayValue(addr, i, v, true);
        }
        if (this.lowLevelArrayBoundChecks) {
            this.casImpl.checkArrayBounds(addr, i);
        }
        this.ll_cas.ll_setShortArrayValue(addr, i, v);
    }

    public void copyFromArray(int addr, short[] src, int srcOffset, int destOffset, int length) {
        if (this.lowLevelArrayBoundChecks) {
            this.casImpl.checkArrayBounds(addr, destOffset, length);
        }
        for (int i = 0; i < length; ++i) {
            this.ll_cas.ll_setShortArrayValue(addr, i + destOffset, src[i + srcOffset]);
        }
    }

    public void copyToArray(int addr, int srcOffset, short[] dest, int destOffset, int length) {
        if (this.lowLevelArrayBoundChecks) {
            this.casImpl.checkArrayBounds(addr, srcOffset, length);
        }
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = this.ll_cas.ll_getShortArrayValue(addr, i + srcOffset);
        }
    }

    public short[] toArray(int addr) {
        int size2 = this.size(addr);
        short[] outArray = new short[size2];
        this.copyToArray(addr, 0, outArray, 0, size2);
        return outArray;
    }
}

