/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import org.apache.uima.cas.BooleanArrayFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JCasRegistry;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.cas.TOP_Type;

public final class BooleanArray
extends TOP
implements BooleanArrayFS {
    public static final int typeIndexID;
    public static final int type;

    public int getTypeIndexID() {
        return typeIndexID;
    }

    private BooleanArray() {
    }

    public BooleanArray(int addr, TOP_Type type) {
        super(addr, type);
    }

    public BooleanArray(JCas jcas, int length) {
        this(jcas.getLowLevelCas().ll_createBooleanArray(length), jcas.getType(typeIndexID));
    }

    public boolean get(int i) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, i);
        return this.jcasType.ll_cas.ll_getBooleanArrayValue(this.addr, i);
    }

    public void set(int i, boolean v) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, i);
        this.jcasType.ll_cas.ll_setBooleanArrayValue(this.addr, i, v);
    }

    public void copyFromArray(boolean[] src, int srcOffset, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, destOffset, length);
        for (int i = 0; i < length; ++i) {
            this.jcasType.ll_cas.ll_setBooleanArrayValue(this.addr, i + destOffset, src[i + srcOffset]);
        }
    }

    public void copyToArray(int srcOffset, boolean[] dest, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, srcOffset, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = this.jcasType.ll_cas.ll_getBooleanArrayValue(this.addr, i + srcOffset);
        }
    }

    public boolean[] toArray() {
        int size2 = this.size();
        boolean[] outArray = new boolean[size2];
        this.copyToArray(0, outArray, 0, size2);
        return outArray;
    }

    public int size() {
        return this.jcasType.casImpl.ll_getArraySize(this.addr);
    }

    public void copyToArray(int srcOffset, String[] dest, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, srcOffset, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = Boolean.toString(this.jcasType.ll_cas.ll_getBooleanArrayValue(this.addr, i + srcOffset));
        }
    }

    public void copyFromArray(String[] src, int srcOffset, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, destOffset, length);
        for (int i = 0; i < length; ++i) {
            this.jcasType.ll_cas.ll_setBooleanArrayValue(this.addr, i + destOffset, "true".equalsIgnoreCase(src[i + srcOffset]));
        }
    }

    public String[] toStringArray() {
        int size2 = this.size();
        String[] strArray = new String[size2];
        this.copyToArray(0, strArray, 0, size2);
        return strArray;
    }

    static {
        type = typeIndexID = JCasRegistry.register(BooleanArray.class);
    }
}

