/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util.rb_trees;

import org.apache.uima.internal.util.BinaryTree;
import org.apache.uima.internal.util.rb_trees.RBTKeyValuePair;
import org.apache.uima.internal.util.rb_trees.RedBlackTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RBTNode<T> {
    private static final boolean RED = true;
    private static final boolean BLACK = false;
    private int key;
    private boolean color;
    private RBTNode<T> parent;
    RBTNode<T> left;
    RBTNode<T> right;
    T element;
    private static final int indentInc = 2;

    private RBTNode(int key, boolean color, RBTNode<T> parent, RBTNode<T> left, RBTNode<T> right, T element) {
        this.key = key;
        this.color = color;
        this.parent = parent;
        this.left = left;
        this.right = right;
        this.element = element;
    }

    RBTNode(int key, T element) {
        this(key, false, null, null, null, element);
    }

    static final <T> RBTNode<T> find(RBTNode<T> x2, int key) {
        while (x2 != null && x2.key != key) {
            if (key < x2.key) {
                x2 = x2.left;
                continue;
            }
            x2 = x2.right;
        }
        return x2;
    }

    final RBTNode<T> successor() {
        RBTNode<T> x2 = this;
        if (x2.right != null) {
            x2 = x2.right;
            while (x2.left != null) {
                x2 = x2.left;
            }
            return x2;
        }
        RBTNode<T> y = x2.parent;
        while (y != null && x2 == y.right) {
            x2 = y;
            y = x2.parent;
        }
        return y;
    }

    static final <T> boolean insert(RedBlackTree<T> tree, RBTNode<T> x2) {
        if (!RBTNode.treeInsert(tree, x2)) {
            return false;
        }
        x2.color = true;
        while (x2 != tree.root && x2.parent.color) {
            RBTNode<T> y;
            if (x2.parent == x2.parent.parent.left) {
                y = x2.parent.parent.right;
                if (RBTNode.colorOf(y)) {
                    x2.parent.color = false;
                    RBTNode.setColor(y, false);
                    x2.parent.parent.color = true;
                    x2 = x2.parent.parent;
                    continue;
                }
                if (x2 == x2.parent.right) {
                    x2 = x2.parent;
                    super.leftRotate(tree);
                }
                x2.parent.color = false;
                x2.parent.parent.color = true;
                super.rightRotate(tree);
                continue;
            }
            y = x2.parent.parent.left;
            if (RBTNode.colorOf(y)) {
                x2.parent.color = false;
                RBTNode.setColor(y, false);
                x2.parent.parent.color = true;
                x2 = x2.parent.parent;
                continue;
            }
            if (x2 == x2.parent.left) {
                x2 = x2.parent;
                super.rightRotate(tree);
            }
            x2.parent.color = false;
            x2.parent.parent.color = true;
            super.leftRotate(tree);
        }
        tree.root.color = false;
        return true;
    }

    private static final <T> boolean treeInsert(RedBlackTree<T> tree, RBTNode<T> z) {
        RBTNode y = null;
        RBTNode x2 = tree.root;
        while (x2 != null) {
            y = x2;
            if (z.key < x2.key) {
                x2 = x2.left;
                continue;
            }
            if (z.key > x2.key) {
                x2 = x2.right;
                continue;
            }
            x2.element = z.element;
            return false;
        }
        z.parent = y;
        if (y == null) {
            tree.root = z;
        } else if (z.key < y.key) {
            y.left = z;
        } else {
            y.right = z;
        }
        return true;
    }

    private final void leftRotate(RedBlackTree<T> tree) {
        RBTNode<T> y = this.right;
        this.right = y.left;
        if (y.left != null) {
            y.left.parent = this;
        }
        y.parent = this.parent;
        if (this.parent == null) {
            tree.root = y;
        } else if (this == this.parent.left) {
            this.parent.left = y;
        } else {
            this.parent.right = y;
        }
        y.left = this;
        this.parent = y;
    }

    private final void rightRotate(RedBlackTree<T> tree) {
        RBTNode<T> y = this.left;
        this.left = y.right;
        if (y.right != null) {
            y.right.parent = this;
        }
        y.parent = this.parent;
        if (this.parent == null) {
            tree.root = y;
        } else if (this == this.parent.right) {
            this.parent.right = y;
        } else {
            this.parent.left = y;
        }
        y.right = this;
        this.parent = y;
    }

    static final <T> void delete(RedBlackTree<T> tree, RBTNode<T> z) {
        RBTNode<T> xParent = null;
        RBTNode<T> y = z.left == null || z.right == null ? z : z.successor();
        RBTNode<T> x2 = y.left != null ? y.left : y.right;
        if (x2 != null) {
            x2.parent = y.parent;
        } else {
            xParent = y.parent;
        }
        if (y.parent == null) {
            tree.root = x2;
        } else if (y == y.parent.left) {
            y.parent.left = x2;
        } else {
            y.parent.right = x2;
        }
        if (y != z) {
            z.key = y.key;
            z.element = y.element;
        }
        if (!y.color) {
            if (x2 == null) {
                RBTNode.deleteFixupNull(tree, xParent);
            } else {
                RBTNode.deleteFixup(tree, x2);
            }
        }
    }

    private static final <T> void deleteFixup(RedBlackTree<T> tree, RBTNode<T> x2) {
        while (x2 != tree.root && !x2.color) {
            RBTNode<T> w;
            if (x2 == x2.parent.left) {
                w = x2.parent.right;
                if (w.color) {
                    w.color = false;
                    x2.parent.color = true;
                    super.leftRotate(tree);
                    w = x2.parent.right;
                }
                if (!RBTNode.colorOf(RBTNode.leftOf(w)) && !RBTNode.colorOf(RBTNode.rightOf(w))) {
                    w.color = true;
                    x2 = x2.parent;
                    continue;
                }
                if (!RBTNode.colorOf(RBTNode.rightOf(w))) {
                    w.color = true;
                    super.rightRotate(tree);
                    w = x2.parent.right;
                }
                w.color = x2.parent.color;
                x2.parent.color = false;
                if (w.right != null) {
                    w.right.color = false;
                }
                super.leftRotate(tree);
                x2 = tree.root;
                continue;
            }
            w = x2.parent.left;
            if (w.color) {
                w.color = false;
                x2.parent.color = true;
                super.rightRotate(tree);
                w = x2.parent.left;
            }
            if (!RBTNode.colorOf(RBTNode.rightOf(w)) && !RBTNode.colorOf(RBTNode.leftOf(w))) {
                w.color = true;
                x2 = x2.parent;
                continue;
            }
            if (!RBTNode.colorOf(RBTNode.leftOf(w))) {
                w.color = true;
                super.leftRotate(tree);
                w = x2.parent.left;
            }
            w.color = x2.parent.color;
            x2.parent.color = false;
            if (w.left != null) {
                w.left.color = false;
            }
            super.rightRotate(tree);
            x2 = tree.root;
        }
        x2.color = false;
    }

    private static final <T> void deleteFixupNull(RedBlackTree<T> tree, RBTNode<T> x2) {
        RBTNode<T> w;
        if (x2 == null) {
            return;
        }
        if (x2.left == null) {
            w = x2.right;
            if (w.color) {
                w.color = false;
                x2.color = true;
                super.leftRotate(tree);
                w = x2.right;
            }
            if (!RBTNode.colorOf(RBTNode.leftOf(w)) && !RBTNode.colorOf(RBTNode.rightOf(w))) {
                w.color = true;
            } else {
                if (!RBTNode.colorOf(RBTNode.rightOf(w))) {
                    w.color = true;
                    super.rightRotate(tree);
                    w = x2.right;
                }
                w.color = x2.color;
                x2.color = false;
                if (w.right != null) {
                    w.right.color = false;
                }
                super.leftRotate(tree);
                x2 = tree.root;
            }
        } else {
            w = x2.left;
            if (w.color) {
                w.color = false;
                x2.color = true;
                super.rightRotate(tree);
                w = x2.left;
            }
            if (!RBTNode.colorOf(RBTNode.rightOf(w)) && !RBTNode.colorOf(RBTNode.leftOf(w))) {
                w.color = true;
            } else {
                if (!RBTNode.colorOf(RBTNode.leftOf(w))) {
                    w.color = true;
                    super.leftRotate(tree);
                    w = x2.left;
                }
                w.color = x2.color;
                x2.color = false;
                if (w.left != null) {
                    w.left.color = false;
                }
                super.rightRotate(tree);
                x2 = tree.root;
            }
        }
        while (x2 != tree.root && !x2.color) {
            if (x2 == x2.parent.left) {
                w = x2.parent.right;
                if (w.color) {
                    w.color = false;
                    x2.parent.color = true;
                    super.leftRotate(tree);
                    w = x2.parent.right;
                }
                if (!RBTNode.colorOf(RBTNode.leftOf(w)) && !RBTNode.colorOf(RBTNode.rightOf(w))) {
                    w.color = true;
                    x2 = x2.parent;
                    continue;
                }
                if (!RBTNode.colorOf(RBTNode.rightOf(w))) {
                    w.color = true;
                    super.rightRotate(tree);
                    w = x2.parent.right;
                }
                w.color = x2.parent.color;
                x2.parent.color = false;
                if (w.right != null) {
                    w.right.color = false;
                }
                super.leftRotate(tree);
                x2 = tree.root;
                continue;
            }
            w = x2.parent.left;
            if (w.color) {
                w.color = false;
                x2.parent.color = true;
                super.rightRotate(tree);
                w = x2.parent.left;
            }
            if (!RBTNode.colorOf(RBTNode.rightOf(w)) && !RBTNode.colorOf(RBTNode.leftOf(w))) {
                w.color = true;
                x2 = x2.parent;
                continue;
            }
            if (!RBTNode.colorOf(RBTNode.leftOf(w))) {
                w.color = true;
                super.leftRotate(tree);
                w = x2.parent.left;
            }
            w.color = x2.parent.color;
            x2.parent.color = false;
            if (w.left != null) {
                w.left.color = false;
            }
            super.rightRotate(tree);
            x2 = tree.root;
        }
        x2.color = false;
    }

    int keys(int pos, int[] keys) {
        int cur = pos;
        if (this.left != null) {
            cur = this.left.keys(cur, keys);
        }
        keys[cur] = this.key;
        ++cur;
        if (this.right != null) {
            cur = this.right.keys(cur, keys);
        }
        return cur;
    }

    private static final <T> boolean colorOf(RBTNode<T> x2) {
        return x2 == null ? false : x2.color;
    }

    private static final <T> void setColor(RBTNode<T> x2, boolean c) {
        if (x2 != null) {
            x2.color = c;
        }
    }

    private static final <T> RBTNode<T> leftOf(RBTNode<T> x2) {
        return x2 == null ? null : x2.left;
    }

    private static final <T> RBTNode<T> rightOf(RBTNode<T> x2) {
        return x2 == null ? null : x2.right;
    }

    public void printKeys(int indent) {
        for (int i = 0; i < indent; ++i) {
            System.out.print(' ');
        }
        System.out.print(this.key);
        System.out.print(":");
        if (this.color) {
            System.out.println("red");
        } else {
            System.out.println("black");
        }
        indent += 2;
        if (this.left != null) {
            this.left.printKeys(indent);
        }
        if (this.right != null) {
            this.right.printKeys(indent);
        }
    }

    public void printElements(int indent) {
        for (int i = 0; i < indent; ++i) {
            System.out.print(' ');
        }
        System.out.println(this.element.toString());
        indent += 2;
        if (this.left != null) {
            this.left.printElements(indent);
        }
        if (this.right != null) {
            this.right.printElements(indent);
        }
    }

    void getBinaryTree(BinaryTree tree) {
        tree.setValue(new RBTKeyValuePair(this.key, this.element));
        if (this.left != null) {
            BinaryTree newLeft = tree.newLeftDtr();
            this.left.getBinaryTree(newLeft);
        }
        if (this.right != null) {
            BinaryTree newRight = tree.newRightDtr();
            this.right.getBinaryTree(newRight);
        }
    }
}

