/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util.rb_trees;

import java.util.Stack;
import org.apache.uima.internal.util.IntStack;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.rb_trees.IntRedBlackTree;

class IntRBTNode {
    private static final boolean RED = true;
    private static final boolean BLACK = false;
    private int key;
    private boolean color;
    private IntRBTNode parent;
    IntRBTNode left;
    IntRBTNode right;
    int element;
    private static final int indentInc = 2;

    private IntRBTNode(int key, boolean color, IntRBTNode parent, IntRBTNode left, IntRBTNode right, int element) {
        this.key = key;
        this.color = color;
        this.parent = parent;
        this.left = left;
        this.right = right;
        this.element = element;
    }

    IntRBTNode(int key, int element) {
        this(key, false, null, null, null, element);
    }

    static final IntRBTNode find(IntRBTNode x2, int key) {
        while (x2 != null && x2.key != key) {
            if (key < x2.key) {
                x2 = x2.left;
                continue;
            }
            x2 = x2.right;
        }
        return x2;
    }

    final IntRBTNode successor() {
        IntRBTNode x2 = this;
        if (x2.right != null) {
            x2 = x2.right;
            while (x2.left != null) {
                x2 = x2.left;
            }
            return x2;
        }
        IntRBTNode y = x2.parent;
        while (y != null && x2 == y.right) {
            x2 = y;
            y = x2.parent;
        }
        return y;
    }

    static final boolean insert(IntRedBlackTree tree, IntRBTNode x2) {
        if (!IntRBTNode.treeInsert(tree, x2)) {
            return false;
        }
        x2.color = true;
        while (x2 != tree.root && x2.parent.color) {
            IntRBTNode y;
            if (x2.parent == x2.parent.parent.left) {
                y = x2.parent.parent.right;
                if (IntRBTNode.colorOf(y)) {
                    x2.parent.color = false;
                    IntRBTNode.setColor(y, false);
                    x2.parent.parent.color = true;
                    x2 = x2.parent.parent;
                    continue;
                }
                if (x2 == x2.parent.right) {
                    x2 = x2.parent;
                    x2.leftRotate(tree);
                }
                x2.parent.color = false;
                x2.parent.parent.color = true;
                x2.parent.parent.rightRotate(tree);
                continue;
            }
            y = x2.parent.parent.left;
            if (IntRBTNode.colorOf(y)) {
                x2.parent.color = false;
                IntRBTNode.setColor(y, false);
                x2.parent.parent.color = true;
                x2 = x2.parent.parent;
                continue;
            }
            if (x2 == x2.parent.left) {
                x2 = x2.parent;
                x2.rightRotate(tree);
            }
            x2.parent.color = false;
            x2.parent.parent.color = true;
            x2.parent.parent.leftRotate(tree);
        }
        tree.root.color = false;
        return true;
    }

    private static final boolean treeInsert(IntRedBlackTree tree, IntRBTNode z) {
        IntRBTNode y = null;
        IntRBTNode x2 = tree.root;
        while (x2 != null) {
            y = x2;
            if (z.key < x2.key) {
                x2 = x2.left;
                continue;
            }
            if (z.key > x2.key) {
                x2 = x2.right;
                continue;
            }
            x2.element = z.element;
            return false;
        }
        z.parent = y;
        if (y == null) {
            tree.root = z;
        } else if (z.key < y.key) {
            y.left = z;
        } else {
            y.right = z;
        }
        return true;
    }

    private final void leftRotate(IntRedBlackTree tree) {
        IntRBTNode y = this.right;
        this.right = y.left;
        if (y.left != null) {
            y.left.parent = this;
        }
        y.parent = this.parent;
        if (this.parent == null) {
            tree.root = y;
        } else if (this == this.parent.left) {
            this.parent.left = y;
        } else {
            this.parent.right = y;
        }
        y.left = this;
        this.parent = y;
    }

    private final void rightRotate(IntRedBlackTree tree) {
        IntRBTNode y = this.left;
        this.left = y.right;
        if (y.right != null) {
            y.right.parent = this;
        }
        y.parent = this.parent;
        if (this.parent == null) {
            tree.root = y;
        } else if (this == this.parent.right) {
            this.parent.right = y;
        } else {
            this.parent.left = y;
        }
        y.right = this;
        this.parent = y;
    }

    static final void delete(IntRedBlackTree tree, IntRBTNode z) {
        IntRBTNode xParent = null;
        IntRBTNode y = z.left == null || z.right == null ? z : z.successor();
        IntRBTNode x2 = y.left != null ? y.left : y.right;
        if (x2 != null) {
            x2.parent = y.parent;
        } else {
            xParent = y.parent;
        }
        if (y.parent == null) {
            tree.root = x2;
        } else if (y == y.parent.left) {
            y.parent.left = x2;
        } else {
            y.parent.right = x2;
        }
        if (y != z) {
            z.key = y.key;
            z.element = y.element;
        }
        if (!y.color) {
            if (x2 == null) {
                IntRBTNode.deleteFixupNull(tree, xParent);
            } else {
                IntRBTNode.deleteFixup(tree, x2);
            }
        }
    }

    private static final void deleteFixup(IntRedBlackTree tree, IntRBTNode x2) {
        while (x2 != tree.root && !x2.color) {
            IntRBTNode w;
            if (x2 == x2.parent.left) {
                w = x2.parent.right;
                if (w.color) {
                    w.color = false;
                    x2.parent.color = true;
                    x2.parent.leftRotate(tree);
                    w = x2.parent.right;
                }
                if (!IntRBTNode.colorOf(IntRBTNode.leftOf(w)) && !IntRBTNode.colorOf(IntRBTNode.rightOf(w))) {
                    w.color = true;
                    x2 = x2.parent;
                    continue;
                }
                if (!IntRBTNode.colorOf(IntRBTNode.rightOf(w))) {
                    w.color = true;
                    w.rightRotate(tree);
                    w = x2.parent.right;
                }
                w.color = x2.parent.color;
                x2.parent.color = false;
                if (w.right != null) {
                    w.right.color = false;
                }
                x2.parent.leftRotate(tree);
                x2 = tree.root;
                continue;
            }
            w = x2.parent.left;
            if (w.color) {
                w.color = false;
                x2.parent.color = true;
                x2.parent.rightRotate(tree);
                w = x2.parent.left;
            }
            if (!IntRBTNode.colorOf(IntRBTNode.rightOf(w)) && !IntRBTNode.colorOf(IntRBTNode.leftOf(w))) {
                w.color = true;
                x2 = x2.parent;
                continue;
            }
            if (!IntRBTNode.colorOf(IntRBTNode.leftOf(w))) {
                w.color = true;
                w.leftRotate(tree);
                w = x2.parent.left;
            }
            w.color = x2.parent.color;
            x2.parent.color = false;
            if (w.left != null) {
                w.left.color = false;
            }
            x2.parent.rightRotate(tree);
            x2 = tree.root;
        }
        x2.color = false;
    }

    private static final void deleteFixupNull(IntRedBlackTree tree, IntRBTNode x2) {
        IntRBTNode w;
        if (x2 == null) {
            return;
        }
        if (x2.left == null) {
            w = x2.right;
            if (w.color) {
                w.color = false;
                x2.color = true;
                x2.leftRotate(tree);
                w = x2.right;
            }
            if (!IntRBTNode.colorOf(IntRBTNode.leftOf(w)) && !IntRBTNode.colorOf(IntRBTNode.rightOf(w))) {
                w.color = true;
            } else {
                if (!IntRBTNode.colorOf(IntRBTNode.rightOf(w))) {
                    w.color = true;
                    w.rightRotate(tree);
                    w = x2.right;
                }
                w.color = x2.color;
                x2.color = false;
                if (w.right != null) {
                    w.right.color = false;
                }
                x2.leftRotate(tree);
                x2 = tree.root;
            }
        } else {
            w = x2.left;
            if (w.color) {
                w.color = false;
                x2.color = true;
                x2.rightRotate(tree);
                w = x2.left;
            }
            if (!IntRBTNode.colorOf(IntRBTNode.rightOf(w)) && !IntRBTNode.colorOf(IntRBTNode.leftOf(w))) {
                w.color = true;
            } else {
                if (!IntRBTNode.colorOf(IntRBTNode.leftOf(w))) {
                    w.color = true;
                    w.leftRotate(tree);
                    w = x2.left;
                }
                w.color = x2.color;
                x2.color = false;
                if (w.left != null) {
                    w.left.color = false;
                }
                x2.rightRotate(tree);
                x2 = tree.root;
            }
        }
        while (x2 != tree.root && !x2.color) {
            if (x2 == x2.parent.left) {
                w = x2.parent.right;
                if (w.color) {
                    w.color = false;
                    x2.parent.color = true;
                    x2.parent.leftRotate(tree);
                    w = x2.parent.right;
                }
                if (!IntRBTNode.colorOf(IntRBTNode.leftOf(w)) && !IntRBTNode.colorOf(IntRBTNode.rightOf(w))) {
                    w.color = true;
                    x2 = x2.parent;
                    continue;
                }
                if (!IntRBTNode.colorOf(IntRBTNode.rightOf(w))) {
                    w.color = true;
                    w.rightRotate(tree);
                    w = x2.parent.right;
                }
                w.color = x2.parent.color;
                x2.parent.color = false;
                if (w.right != null) {
                    w.right.color = false;
                }
                x2.parent.leftRotate(tree);
                x2 = tree.root;
                continue;
            }
            w = x2.parent.left;
            if (w.color) {
                w.color = false;
                x2.parent.color = true;
                x2.parent.rightRotate(tree);
                w = x2.parent.left;
            }
            if (!IntRBTNode.colorOf(IntRBTNode.rightOf(w)) && !IntRBTNode.colorOf(IntRBTNode.leftOf(w))) {
                w.color = true;
                x2 = x2.parent;
                continue;
            }
            if (!IntRBTNode.colorOf(IntRBTNode.leftOf(w))) {
                w.color = true;
                w.leftRotate(tree);
                w = x2.parent.left;
            }
            w.color = x2.parent.color;
            x2.parent.color = false;
            if (w.left != null) {
                w.left.color = false;
            }
            x2.parent.rightRotate(tree);
            x2 = tree.root;
        }
        x2.color = false;
    }

    int keys(int pos, int[] keys) {
        int cur = pos;
        if (this.left != null) {
            cur = this.left.keys(cur, keys);
        }
        keys[cur] = this.key;
        ++cur;
        if (this.right != null) {
            cur = this.right.keys(cur, keys);
        }
        return cur;
    }

    int[] toArray(int offset) {
        IntVector v = new IntVector();
        Stack<IntRBTNode> nodeStack = new Stack<IntRBTNode>();
        IntStack addressStack = new IntStack();
        IntRBTNode node = this;
        while (true) {
            if (node.left != null || node.right != null) {
                v.add(node.key);
                v.add(node.element);
                if (node.left != null) {
                    if (node.right != null) {
                        v.add(3);
                        addressStack.push(v.size());
                        v.add(-1);
                        nodeStack.push(node.right);
                    } else {
                        v.add(1);
                    }
                    node = node.left;
                    continue;
                }
                v.add(2);
                node = node.right;
                continue;
            }
            v.add(node.key);
            v.add(node.element);
            v.add(0);
            if (addressStack.empty()) {
                node = null;
            } else {
                node = (IntRBTNode)nodeStack.pop();
                int address = addressStack.pop();
                v.set(address, v.size() + offset);
            }
            if (node == null) break;
        }
        return v.toArray();
    }

    private static final boolean colorOf(IntRBTNode x2) {
        return x2 == null ? false : x2.color;
    }

    private static final void setColor(IntRBTNode x2, boolean c) {
        if (x2 != null) {
            x2.color = c;
        }
    }

    private static final IntRBTNode leftOf(IntRBTNode x2) {
        return x2 == null ? null : x2.left;
    }

    private static final IntRBTNode rightOf(IntRBTNode x2) {
        return x2 == null ? null : x2.right;
    }

    public void printKeys(int indent) {
        for (int i = 0; i < indent; ++i) {
            System.out.print(' ');
        }
        System.out.print(this.key);
        System.out.print(":");
        if (this.color) {
            System.out.println("red");
        } else {
            System.out.println("black");
        }
        indent += 2;
        if (this.left != null) {
            this.left.printKeys(indent);
        }
        if (this.right != null) {
            this.right.printKeys(indent);
        }
    }

    public void printElements(int indent) {
        for (int i = 0; i < indent; ++i) {
            System.out.print(' ');
        }
        System.out.println(this.element);
        indent += 2;
        if (this.left != null) {
            this.left.printElements(indent);
        }
        if (this.right != null) {
            this.right.printElements(indent);
        }
    }
}

