/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util.rb_trees;

import org.apache.uima.internal.util.IntComparator;
import org.apache.uima.internal.util.rb_trees.IntArrayRBT;

public class CompIntArrayRBT
extends IntArrayRBT {
    private IntComparator comp;

    public CompIntArrayRBT(IntComparator comp) {
        this(comp, 1024);
    }

    public CompIntArrayRBT(IntComparator comp, int initialSize) {
        super(initialSize);
        this.comp = comp;
    }

    protected int treeInsert(int k) {
        int cv;
        int z;
        int x2 = this.root;
        int y = 0;
        if (this.greatestNode != 0 && this.comp.compare(this.key[this.greatestNode], k) < 0) {
            y = this.greatestNode;
            this.greatestNode = z = this.newNode(k);
        } else {
            while (x2 != 0) {
                y = x2;
                cv = this.comp.compare(k, this.key[x2]);
                if (cv < 0) {
                    x2 = this.left[x2];
                    continue;
                }
                if (cv > 0) {
                    x2 = this.right[x2];
                    continue;
                }
                return x2;
            }
            z = this.newNode(k);
        }
        if (y == 0) {
            this.root = z;
            this.greatestNode = z;
            this.parent[z] = 0;
        } else {
            this.parent[z] = y;
            cv = this.comp.compare(k, this.key[y]);
            if (cv < 0) {
                this.left[y] = z;
            } else {
                this.right[y] = z;
            }
        }
        return z;
    }

    protected int treeInsertWithDups(int k) {
        int cv;
        int x2 = this.root;
        boolean wentLeft = false;
        if (this.greatestNode != 0 && this.comp.compare(this.key[this.greatestNode], k) <= 0) {
            int z;
            int y = this.greatestNode;
            this.greatestNode = z = this.newNode(k);
            this.parent[z] = y;
            this.right[y] = z;
            return z;
        }
        int y = 0;
        while (x2 != 0) {
            y = x2;
            int xKey = this.key[x2];
            cv = this.comp.compare(k, xKey);
            if (cv < 0) {
                x2 = this.left[x2];
                continue;
            }
            if (cv > 0) {
                x2 = this.right[x2];
                continue;
            }
            if (this.rand.nextBoolean()) {
                wentLeft = true;
                x2 = this.left[x2];
                continue;
            }
            wentLeft = false;
            x2 = this.right[x2];
        }
        int z = this.newNode(k);
        if (y == 0) {
            this.root = z;
            this.greatestNode = z;
            this.parent[z] = 0;
        } else {
            this.parent[z] = y;
            cv = this.comp.compare(k, this.key[y]);
            if (cv < 0) {
                this.left[y] = z;
            } else if (cv > 0) {
                this.right[y] = z;
            } else if (wentLeft) {
                this.left[y] = z;
            } else {
                this.right[y] = z;
            }
        }
        return z;
    }

    public int findKey(int k) {
        int node = this.root;
        while (node != 0) {
            int cv = this.comp.compare(k, this.key[node]);
            if (cv < 0) {
                node = this.left[node];
                continue;
            }
            if (cv > 0) {
                node = this.right[node];
                continue;
            }
            return node;
        }
        return 0;
    }

    public int findInsertionPoint(int k) {
        int node = this.root;
        int found = this.root;
        int cv = 0;
        while (node != 0) {
            found = node;
            cv = this.comp.compare(k, this.key[node]);
            if (cv < 0) {
                node = this.left[node];
                continue;
            }
            if (cv > 0) {
                node = this.right[node];
                continue;
            }
            return node;
        }
        if (cv > 0) {
            return this.nextNode(found);
        }
        return found;
    }
}

