/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.uima.internal.util.IntArrayUtils;

public class IntVector
implements Serializable {
    private static final long serialVersionUID = 4829243434421992519L;
    private static final int default_size = 16;
    private static final int default_growth_factor = 2;
    private static final int default_multiplication_limit = 2000000;
    private int growth_factor;
    private int multiplication_limit;
    protected int pos = 0;
    protected int[] array = null;

    public IntVector() {
        this(16, 2, 2000000);
    }

    public IntVector(int[] array) {
        if (array == null) {
            array = new int[]{};
        }
        this.pos = array.length;
        this.array = array;
        this.growth_factor = 2;
        this.multiplication_limit = 2000000;
    }

    public IntVector(int capacity) {
        this(capacity, 2, 2000000);
    }

    public IntVector(int capacity, int growth_factor, int multiplication_limit) {
        if (capacity < 0) {
            capacity = 16;
        }
        if (growth_factor < 1) {
            growth_factor = 2;
        }
        if (multiplication_limit < 1) {
            multiplication_limit = 2000000;
        }
        this.growth_factor = growth_factor;
        this.multiplication_limit = multiplication_limit;
        this.array = new int[capacity];
    }

    public void setSize(int size2) {
        if (size2 > 0) {
            this.ensure_size(size2);
        }
    }

    public void add(int element) {
        int i = this.pos++;
        this.ensure_size(this.pos);
        this.array[i] = element;
    }

    public void add(int index, int element) {
        if (index >= this.pos) {
            this.ensure_size(index + 1);
        } else {
            if (this.array.length <= this.pos) {
                this.ensure_size(this.pos + 1);
            } else {
                ++this.pos;
            }
            System.arraycopy(this.array, index, this.array, index + 1, this.pos - (index + 1));
        }
        this.array[index] = element;
    }

    public void set(int index, int element) {
        if (index >= this.pos) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.array[index] = element;
    }

    public void put(int index, int element) {
        this.ensure_size(index + 1);
        this.array[index] = element;
    }

    public int get(int index) {
        if (index >= this.pos) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.array[index];
    }

    public int remove(int index) {
        if (index >= this.pos) {
            throw new ArrayIndexOutOfBoundsException();
        }
        --this.pos;
        int retval = this.array[index];
        for (int i = index; i < this.pos; ++i) {
            this.array[i] = this.array[i + 1];
        }
        return retval;
    }

    public void removeAllElements() {
        this.pos = 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        IntVector v = (IntVector)o;
        if (this.size() != v.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.array[i] == v.get(i)) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.pos;
    }

    public boolean contains(int elem2) {
        return this.position(elem2) >= 0;
    }

    public int position(int elem2) {
        for (int i = 0; i < this.pos; ++i) {
            if (this.array[i] != elem2) continue;
            return i;
        }
        return -1;
    }

    public void fill(int value2) {
        Arrays.fill(this.array, value2);
    }

    public int[] toArray() {
        this.trimToSize();
        return this.array;
    }

    public int[] toArrayCopy() {
        int max2 = this.size();
        int[] copy = new int[max2];
        System.arraycopy(this.array, 0, copy, 0, max2);
        return copy;
    }

    public int[] getArray() {
        return this.array;
    }

    public int indexOf(int element) {
        int index = -1;
        for (int i = 0; i < this.pos; ++i) {
            if (element != this.array[i]) continue;
            index = i;
            break;
        }
        return index;
    }

    public void trimToSize() {
        if (this.pos == this.array.length) {
            return;
        }
        int[] new_array = new int[this.pos];
        System.arraycopy(this.array, 0, new_array, 0, this.pos);
        this.array = new_array;
    }

    public IntVector copy() {
        IntVector copy = new IntVector(this.array.length, this.growth_factor, this.multiplication_limit);
        copy.pos = this.pos;
        for (int i = 0; i < this.pos; ++i) {
            copy.array[i] = this.array[i];
        }
        return copy;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        for (int i = 0; i < this.pos; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.array[i]);
        }
        buf.append("]");
        return buf.toString();
    }

    public void ensure_size(int req) {
        this.array = IntArrayUtils.ensure_size(this.array, req, this.growth_factor, this.multiplication_limit);
        if (this.pos < req) {
            this.pos = req;
        }
    }

    public int hashCode() {
        if (this.array == null) {
            return 0;
        }
        int sum2 = 0;
        for (int i = 0; i < this.size(); ++i) {
            sum2 += this.get(i);
        }
        return sum2;
    }
}

