/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

public final class IntArrayUtils {
    private static final int default_growth_factor = 2;
    private static final int default_multiplication_limit = 1024;

    public static final int[] ensure_size(int[] array, int req) {
        return IntArrayUtils.ensure_size(array, req, 2, 1024);
    }

    public static final int[] ensure_size(int[] array, int req, int growth_factor, int multiplication_limit) {
        if (array.length < req) {
            return IntArrayUtils.expand_size(array, req, growth_factor, multiplication_limit);
        }
        return array;
    }

    private static final int[] expand_size(int[] array, int req, int growth_factor, int multiplication_limit) {
        if (array.length == 0) {
            return new int[req];
        }
        int new_array_size = array.length;
        while (new_array_size < req) {
            if (new_array_size < multiplication_limit) {
                new_array_size *= growth_factor;
                continue;
            }
            new_array_size += multiplication_limit;
        }
        int[] new_array = new int[new_array_size];
        System.arraycopy(array, 0, new_array, 0, array.length);
        return new_array;
    }

    public static final boolean[] ensure_size(boolean[] array, int req, int growth_factor, int multiplication_limit) {
        if (array.length < req) {
            int new_array_size;
            if (array.length > 0) {
                new_array_size = array.length;
            } else {
                return new boolean[req];
            }
            while (new_array_size < req) {
                if (new_array_size < multiplication_limit) {
                    new_array_size *= growth_factor;
                    continue;
                }
                new_array_size += multiplication_limit;
            }
            boolean[] new_array = new boolean[new_array_size];
            System.arraycopy(array, 0, new_array, 0, array.length);
            array = new_array;
        }
        return array;
    }

    public static final char[] ensure_size(char[] array, int req, int growth_factor, int multiplication_limit) {
        if (array.length < req) {
            int new_array_size;
            if (array.length > 0) {
                new_array_size = array.length;
            } else {
                return new char[req];
            }
            while (new_array_size < req) {
                if (new_array_size < multiplication_limit) {
                    new_array_size *= growth_factor;
                    continue;
                }
                new_array_size += multiplication_limit;
            }
            char[] new_array = new char[new_array_size];
            System.arraycopy(array, 0, new_array, 0, array.length);
            array = new_array;
        }
        return array;
    }

    public static final int binarySearch(int[] array, int ele, int start, int end) {
        --end;
        while (start <= end) {
            int i = (int)(((long)start + (long)end) / 2L);
            int current = array[i];
            if (ele == current) {
                return i;
            }
            if (start == end) {
                if (ele < current) {
                    return -i - 1;
                }
                return -i - 2;
            }
            if (ele < current) {
                end = i - 1;
                continue;
            }
            start = i + 1;
        }
        return -start - 1;
    }

    public static final int find(int x2, int[] a) {
        int max2 = a.length;
        for (int i = 0; i < max2; ++i) {
            if (a[i] != x2) continue;
            return i;
        }
        return -1;
    }
}

