/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.util.ArrayList;
import org.apache.uima.internal.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterUtils {
    private static final boolean isType(char c, int[] types) {
        int charType = Character.getType(c);
        int max2 = types.length;
        for (int i = 0; i < max2; ++i) {
            if (charType != types[i]) continue;
            return true;
        }
        return false;
    }

    private static ArrayList<CharRange> getCharacterRanges(int[] charSpecs) {
        ArrayList<CharRange> ranges = new ArrayList<CharRange>();
        for (char c = '\u0000'; c <= '\uffff'; c = (char)(c + '\u0001')) {
            if (CharacterUtils.isType(c, charSpecs)) {
                CharRange range2 = new CharRange();
                range2.start = c;
                range2.end = c;
                if (c == '\uffff') break;
                for (c = (char)(c + '\u0001'); c <= '\uffff' && CharacterUtils.isType(c, charSpecs); c = (char)(c + '\u0001')) {
                    range2.end = c;
                    if (c == '\uffff') break;
                }
                ranges.add(range2);
            }
            if (c == '\uffff') break;
        }
        return ranges;
    }

    public static String toUnicodeChar(char c) {
        String prefix = "\\u";
        String code = Integer.toHexString(c);
        switch (code.length()) {
            case 1: {
                return prefix + "000" + code;
            }
            case 2: {
                return prefix + "00" + code;
            }
            case 3: {
                return prefix + "0" + code;
            }
        }
        return prefix + code;
    }

    public static String toHexString(char c) {
        String prefix = "0x";
        String code = Integer.toHexString(c);
        switch (code.length()) {
            case 1: {
                return prefix + "000" + code;
            }
            case 2: {
                return prefix + "00" + code;
            }
            case 3: {
                return prefix + "0" + code;
            }
        }
        return prefix + code;
    }

    public static ArrayList<CharRange> getLetterRange() {
        int[] types = new int[]{1, 2, 3, 4, 5};
        return CharacterUtils.getCharacterRanges(types);
    }

    public static ArrayList<CharRange> getDigitRange() {
        int[] types = new int[]{9};
        return CharacterUtils.getCharacterRanges(types);
    }

    public static void printAntlrLexRule(String name, ArrayList<CharRange> charRanges) {
        System.out.print(name + " : ");
        StringBuffer spaceBuffer = new StringBuffer();
        StringUtils.printSpaces(name.length(), spaceBuffer);
        String spaces2 = spaceBuffer.toString();
        for (int i = 0; i < charRanges.size(); ++i) {
            CharRange range2;
            if (i != 0) {
                System.out.print("\n" + spaces2 + " | ");
            }
            if ((range2 = charRanges.get(i)).start == range2.end) {
                System.out.print(" '" + CharacterUtils.toUnicodeChar(range2.start) + "'");
                continue;
            }
            System.out.print(" '" + CharacterUtils.toUnicodeChar(range2.start) + "' .. '" + CharacterUtils.toUnicodeChar(range2.end) + "' ");
        }
        System.out.println("\n" + spaces2 + " ;");
    }

    public static void printJavaCCLexRule(String name, ArrayList<CharRange> charRanges) {
        System.out.print(name + " = ");
        StringBuffer spaceBuffer = new StringBuffer();
        StringUtils.printSpaces(name.length(), spaceBuffer);
        String spaces2 = spaceBuffer.toString();
        for (int i = 0; i < charRanges.size(); ++i) {
            CharRange range2;
            if (i != 0) {
                System.out.print("\n" + spaces2 + " | ");
            }
            if ((range2 = charRanges.get(i)).start == range2.end) {
                System.out.print(CharacterUtils.toHexString(range2.start));
                continue;
            }
            System.out.print("[" + CharacterUtils.toHexString(range2.start) + ".." + CharacterUtils.toHexString(range2.end) + "]");
        }
        System.out.println("\n" + spaces2 + " ;");
    }

    public static void main(String[] args) {
        ArrayList<CharRange> letters = CharacterUtils.getDigitRange();
        CharacterUtils.printJavaCCLexRule("udigit", letters);
    }

    private static class CharRange {
        private char start;
        private char end;

        private CharRange() {
        }
    }
}

