/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

public class CharArrayString {
    private final int start;
    private final int len;
    private final int end;
    private final char[] chars;
    private static final int SEED1 = 31415;
    private static final int SEED2 = 27183;

    public CharArrayString(String string2) {
        this.len = string2.length();
        this.start = 0;
        this.end = this.len;
        this.chars = new char[this.len];
        string2.getChars(0, this.len, this.chars, 0);
    }

    public CharArrayString(char[] charArray) {
        this(charArray, 0, charArray.length);
    }

    public CharArrayString(char[] charArray, int startPos, int length) {
        this.start = startPos;
        this.len = length;
        this.end = this.start + this.len;
        this.chars = charArray;
    }

    public int length() {
        return this.len;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public char[] getChars() {
        return this.chars;
    }

    public CharArrayString trim() {
        int newStart;
        int newEnd = this.end - 1;
        for (newStart = this.start; newStart <= newEnd && Character.isWhitespace(this.chars[newStart]); ++newStart) {
        }
        while (newEnd >= newStart && Character.isWhitespace(this.chars[newEnd])) {
            --newEnd;
        }
        if (this.start != newStart || this.end != ++newEnd) {
            return new CharArrayString(this.chars, newStart, newEnd - newStart);
        }
        return this;
    }

    public CharArrayString substring(int startPos, int endPos) throws IndexOutOfBoundsException {
        if (startPos >= this.len || startPos > endPos || startPos < 0) {
            throw new IndexOutOfBoundsException();
        }
        return new CharArrayString(this.chars, this.start + startPos, endPos - startPos);
    }

    public CharArrayString substring(int startPos) {
        return this.substring(startPos, this.len);
    }

    public int lastIndexOf(char c) {
        int last2;
        for (int pos = last2 = this.end - 1; pos >= this.start; --pos) {
            if (this.chars[pos] != c) continue;
            return pos - this.start;
        }
        return -1;
    }

    public String toString() {
        return new String(this.chars, this.start, this.len);
    }

    public boolean endsWith(CharArrayString string2) {
        if (string2.len > this.len) {
            return false;
        }
        int thisPos = this.end;
        int stringPos = string2.end;
        while (stringPos > string2.start) {
            if (this.chars[--thisPos] == string2.chars[--stringPos]) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(char c) {
        if (this.len <= 0) {
            return false;
        }
        return this.chars[this.start + this.len - 1] == c;
    }

    public char charAt(int pos) {
        if (pos < this.start || pos >= this.len) {
            throw new IndexOutOfBoundsException();
        }
        return this.chars[pos + this.start];
    }

    public int indexOf(char c, int offset) throws IndexOutOfBoundsException {
        if (offset < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int pos = this.start + offset; pos < this.end; ++pos) {
            if (this.chars[pos] != c) continue;
            return pos - this.start;
        }
        return -1;
    }

    public int indexOf(char c) {
        return this.indexOf(c, 0);
    }

    public void setChar(int pos, char c) throws IndexOutOfBoundsException {
        if ((pos += this.start) < this.start || pos >= this.end) {
            throw new IndexOutOfBoundsException();
        }
        this.chars[pos] = c;
    }

    public CharArrayString copy() {
        char[] newChars = new char[this.len];
        System.arraycopy(this.chars, 0, newChars, 0, this.len);
        return new CharArrayString(newChars, 0, this.len);
    }

    public int hashCode() {
        return CharArrayString.hashCode(this.chars, this.start, this.end);
    }

    public static final int hashCode(char[] charArray, int startPos, int endPos) {
        int hash = 0;
        int a = 31415;
        int b = 27183;
        for (int i = startPos; i < endPos; ++i) {
            hash = a * hash + charArray[i];
            a *= b;
        }
        return Math.abs(hash);
    }

    public static final int hashCode(String s) {
        if (s == null) {
            return 0;
        }
        int hash = 0;
        int a = 31415;
        int b = 27183;
        int strLen = s.length();
        for (int i = 0; i < strLen; ++i) {
            hash = a * hash + s.charAt(i);
            a *= 27183;
        }
        return Math.abs(hash);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof CharArrayString) {
            CharArrayString s = (CharArrayString)o;
            if (this.len != s.len) {
                return false;
            }
            int j = s.start;
            for (int i = this.start; i < this.end; ++i) {
                if (this.chars[i] != s.chars[j]) {
                    return false;
                }
                ++j;
            }
            return true;
        }
        return false;
    }
}

