/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.examples.cpe;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.examples.SourceDocumentInformation;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.DocumentAnnotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.FileUtils;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;

public class FileSystemCollectionReader
extends CollectionReader_ImplBase {
    public static final String PARAM_INPUTDIR = "InputDirectory";
    public static final String PARAM_ENCODING = "Encoding";
    public static final String PARAM_LANGUAGE = "Language";
    public static final String PARAM_SUBDIR = "BrowseSubdirectories";
    private ArrayList<File> mFiles;
    private String mEncoding;
    private String mLanguage;
    private Boolean mRecursive;
    private int mCurrentIndex;

    public void initialize() throws ResourceInitializationException {
        File directory = new File(((String)this.getConfigParameterValue(PARAM_INPUTDIR)).trim());
        this.mEncoding = (String)this.getConfigParameterValue(PARAM_ENCODING);
        this.mLanguage = (String)this.getConfigParameterValue(PARAM_LANGUAGE);
        this.mRecursive = (Boolean)this.getConfigParameterValue(PARAM_SUBDIR);
        if (null == this.mRecursive) {
            this.mRecursive = Boolean.FALSE;
        }
        this.mCurrentIndex = 0;
        if (!directory.exists() || !directory.isDirectory()) {
            throw new ResourceInitializationException("directory_not_found", new Object[]{PARAM_INPUTDIR, this.getMetaData().getName(), directory.getPath()});
        }
        this.mFiles = new ArrayList();
        this.addFilesFromDir(directory);
    }

    private void addFilesFromDir(File dir2) {
        File[] files = dir2.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) {
                this.mFiles.add(files[i]);
                continue;
            }
            if (!this.mRecursive.booleanValue()) continue;
            this.addFilesFromDir(files[i]);
        }
    }

    public boolean hasNext() {
        return this.mCurrentIndex < this.mFiles.size();
    }

    public void getNext(CAS aCAS) throws IOException, CollectionException {
        JCas jcas;
        try {
            jcas = aCAS.getJCas();
        }
        catch (CASException e) {
            throw new CollectionException(e);
        }
        File file = this.mFiles.get(this.mCurrentIndex++);
        String text2 = FileUtils.file2String(file, this.mEncoding);
        jcas.setDocumentText(text2);
        if (this.mLanguage != null) {
            ((DocumentAnnotation)jcas.getDocumentAnnotationFs()).setLanguage(this.mLanguage);
        }
        SourceDocumentInformation srcDocInfo = new SourceDocumentInformation(jcas);
        srcDocInfo.setUri(file.getAbsoluteFile().toURL().toString());
        srcDocInfo.setOffsetInSource(0);
        srcDocInfo.setDocumentSize((int)file.length());
        srcDocInfo.setLastSegment(this.mCurrentIndex == this.mFiles.size());
        srcDocInfo.addToIndexes();
    }

    public void close() throws IOException {
    }

    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(this.mCurrentIndex, this.mFiles.size(), "entities")};
    }

    public int getNumberOfDocuments() {
        return this.mFiles.size();
    }
}

