/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.examples.cpe;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.collection.base_cpm.CasObjectProcessor;
import org.apache.uima.examples.SourceDocumentInformation;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.util.ProcessTrace;

public class AnnotationPrinter
extends CasConsumer_ImplBase
implements CasObjectProcessor {
    File outFile;
    FileWriter fileWriter;

    public void initialize() throws ResourceInitializationException {
        String oPath = (String)this.getUimaContext().getConfigParameterValue("outputFile");
        if (oPath == null) {
            throw new ResourceInitializationException("config_setting_absent", new Object[]{"outputFile"});
        }
        this.outFile = new File(oPath.trim());
        if (this.outFile.getParentFile() != null && !this.outFile.getParentFile().exists() && !this.outFile.getParentFile().mkdirs()) {
            throw new ResourceInitializationException("resource_data_not_valid", new Object[]{oPath, "outputFile"});
        }
        try {
            this.fileWriter = new FileWriter(this.outFile);
        }
        catch (IOException e) {
            throw new ResourceInitializationException(e);
        }
    }

    public synchronized void processCas(CAS aCAS) throws ResourceProcessException {
        JCas jcas;
        try {
            jcas = aCAS.getJCas();
        }
        catch (CASException e) {
            throw new ResourceProcessException(e);
        }
        boolean titleP = false;
        String docUri = null;
        FSIterator it = jcas.getAnnotationIndex(SourceDocumentInformation.type).iterator();
        if (it.hasNext()) {
            SourceDocumentInformation srcDocInfo = (SourceDocumentInformation)it.next();
            docUri = srcDocInfo.getUri();
        }
        for (Annotation annot : jcas.getAnnotationIndex()) {
            if (!titleP) {
                try {
                    this.fileWriter.write("\n\n<++++NEW DOCUMENT++++>\n");
                    if (docUri != null) {
                        this.fileWriter.write("DOCUMENT URI:" + docUri + "\n");
                    }
                    this.fileWriter.write("\n");
                }
                catch (IOException e) {
                    throw new ResourceProcessException(e);
                }
                titleP = true;
            }
            String aText = annot.getCoveredText();
            aText = aText.replace('\n', ' ');
            aText = aText.replace('\r', ' ');
            try {
                this.fileWriter.write(annot.getType().getName() + " " + aText + "\n");
                this.fileWriter.flush();
            }
            catch (IOException e) {
                throw new ResourceProcessException(e);
            }
        }
    }

    public void batchProcessComplete(ProcessTrace aTrace) throws ResourceProcessException, IOException {
    }

    public void collectionProcessComplete(ProcessTrace aTrace) throws ResourceProcessException, IOException {
        if (this.fileWriter != null) {
            this.fileWriter.close();
        }
    }

    public void reconfigure() throws ResourceConfigurationException {
        super.reconfigure();
        String oPath = (String)this.getUimaContext().getConfigParameterValue("outputFile");
        File oFile = new File(oPath.trim());
        if (!oFile.equals(this.outFile)) {
            this.outFile = oFile;
            try {
                this.fileWriter.close();
                if (oFile.getParentFile() != null && !oFile.getParentFile().exists() && !oFile.getParentFile().mkdirs()) {
                    throw new ResourceConfigurationException("resource_data_not_valid", new Object[]{oPath, "outputFile"});
                }
                this.fileWriter = new FileWriter(oFile);
            }
            catch (IOException e) {
                throw new ResourceConfigurationException();
            }
        }
    }

    public void destroy() {
        if (this.fileWriter != null) {
            try {
                this.fileWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

