/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.examples;

import java.io.IOException;
import org.apache.uima.UIMAException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.util.XMLInputSource;

public class SofaExampleApplication {
    public static void main(String[] args) throws UIMAException, IOException {
        XMLInputSource input2 = new XMLInputSource("descriptors/analysis_engine/SofaExampleAnnotator.xml");
        AnalysisEngineDescription desc = UIMAFramework.getXMLParser().parseAnalysisEngineDescription(input2);
        AnalysisEngine seAnnotator = UIMAFramework.produceAnalysisEngine(desc);
        CAS cas = seAnnotator.newCAS();
        CAS englishView = cas.createView("EnglishDocument");
        englishView.setDocumentText("this beer is good");
        seAnnotator.process(cas);
        AnnotationIndex<AnnotationFS> anIndex = englishView.getAnnotationIndex();
        FSIterator anIter = anIndex.iterator();
        System.out.println("---Printing all annotations for English Sofa---");
        while (anIter.isValid()) {
            AnnotationFS annot = (AnnotationFS)anIter.get();
            System.out.println(" " + annot.getType().getName() + ": " + annot.getCoveredText());
            anIter.moveToNext();
        }
        System.out.println();
        CAS germanView = cas.getView("GermanDocument");
        anIndex = germanView.getAnnotationIndex();
        anIter = anIndex.iterator();
        Type cross = germanView.getTypeSystem().getType("sofa.test.CrossAnnotation");
        Feature other = cross.getFeatureByBaseName("otherAnnotation");
        System.out.println("---Printing all annotations for German Sofa---");
        while (anIter.isValid()) {
            AnnotationFS annot = (AnnotationFS)anIter.get();
            System.out.println(" " + annot.getType().getName() + ": " + annot.getCoveredText());
            if (annot.getType() == cross) {
                AnnotationFS crossAnnot = (AnnotationFS)annot.getFeatureValue(other);
                System.out.println("   other annotation feature: " + crossAnnot.getCoveredText());
            }
            anIter.moveToNext();
        }
        seAnnotator.destroy();
    }
}

