/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.metadata.cpe;

import org.apache.uima.collection.metadata.CpeCheckpoint;
import org.apache.uima.collection.metadata.CpeDescriptorException;
import org.apache.uima.resource.metadata.impl.MetaDataObject_impl;
import org.apache.uima.resource.metadata.impl.PropertyXmlInfo;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLParser;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class CpeCheckpointImpl
extends MetaDataObject_impl
implements CpeCheckpoint {
    private static final long serialVersionUID = 9155094513948815121L;
    private String file;
    private String time;
    private int batch;
    private static final XmlizationInfo XMLIZATION_INFO = new XmlizationInfo("checkpoint", new PropertyXmlInfo[0]);

    public void setFilePath(String aCheckpointFilePath) throws CpeDescriptorException {
        this.file = aCheckpointFilePath;
    }

    public String getFilePath() {
        return this.file;
    }

    public void setFrequency(int aFrequency, boolean aTimeBased) {
        this.time = String.valueOf(aFrequency) + "ms";
    }

    private int convert2Number(Object anObject) {
        int convertedTime = 1;
        if (anObject != null && anObject instanceof String) {
            int i;
            int len = ((String)anObject).length();
            for (i = 0; i < len && Character.isDigit(((String)anObject).charAt(i)); ++i) {
            }
            if (i > 0) {
                convertedTime = Integer.parseInt(((String)anObject).substring(0, i));
            }
        }
        return convertedTime;
    }

    public int getFrequency() {
        return this.convert2Number(this.time);
    }

    public boolean isTimeBased() {
        return true;
    }

    public void setBatchSize(int aBatchSize) {
        this.batch = aBatchSize;
    }

    public int getBatchSize() {
        return this.batch;
    }

    public void buildFromXMLElement(Element aElement, XMLParser aParser, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        this.setFile(aElement.getAttribute("file"));
        String batch = aElement.getAttribute("batch");
        if (batch != null && batch.trim().length() > 0) {
            this.setBatch(Integer.parseInt(batch));
        }
        this.setTime(aElement.getAttribute("time"));
    }

    protected AttributesImpl getXMLAttributes() {
        AttributesImpl attrs = super.getXMLAttributes();
        attrs.addAttribute("", "batch", "batch", "CDATA", String.valueOf(this.getBatch()));
        if (this.getFile() != null && this.getFile().trim().length() > 0) {
            attrs.addAttribute("", "file", "file", "CDATA", this.getFile());
        }
        if (this.getTime() != null && this.getTime().trim().length() > 0) {
            attrs.addAttribute("", "time", "time", "CDATA", this.getTime());
        }
        return attrs;
    }

    protected XmlizationInfo getXmlizationInfo() {
        return XMLIZATION_INFO;
    }

    public int getBatch() {
        return this.batch;
    }

    public String getFile() {
        return this.file;
    }

    public String getTime() {
        return this.time;
    }

    public void setBatch(int i) {
        this.batch = i;
    }

    public void setFile(String string2) {
        this.file = string2;
    }

    public void setTime(String i) {
        this.time = i;
    }
}

