/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm.container;

import java.io.IOException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas_data.CasData;
import org.apache.uima.collection.base_cpm.CasDataProcessor;
import org.apache.uima.collection.impl.base_cpm.container.ServiceConnectionException;
import org.apache.uima.collection.impl.cpm.container.deployer.VinciTAP;
import org.apache.uima.collection.impl.cpm.utils.CpmLocalizedMessage;
import org.apache.uima.collection.metadata.CpeCasProcessor;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.resource.ResourceServiceException;
import org.apache.uima.resource.metadata.OperationalProperties;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.resource.metadata.impl.ConfigurationParameterSettings_impl;
import org.apache.uima.resource.metadata.impl.OperationalProperties_impl;
import org.apache.uima.resource.metadata.impl.ProcessingResourceMetaData_impl;
import org.apache.uima.util.Level;
import org.apache.uima.util.ProcessTrace;
import org.apache.uima.util.impl.ProcessTrace_impl;
import org.apache.vinci.transport.ServiceException;

public class NetworkCasProcessorImpl
implements CasDataProcessor {
    private static final int DEFAULT_RETRY_COUNT = 3;
    private String name = "";
    private VinciTAP textAnalysisProxy = null;
    private CpeCasProcessor casProcessorType;
    private ProcessingResourceMetaData metadata = null;
    private int retryCount;
    private long totalTime = 0L;
    private ProcessingResourceMetaData resourceMetadata = null;

    public NetworkCasProcessorImpl(CpeCasProcessor aCasProcessorType) {
        this.casProcessorType = aCasProcessorType;
        this.retryCount = this.casProcessorType.getErrorHandling().getMaxConsecutiveRestarts().getRestartCount();
        if (this.retryCount == 0) {
            this.retryCount = 3;
        }
        this.metadata = new ProcessingResourceMetaData_impl();
        this.name = this.casProcessorType.getName();
        this.metadata.setName(this.name);
        OperationalProperties_impl operationalProperties = new OperationalProperties_impl();
        operationalProperties.setModifiesCas(true);
        operationalProperties.setMultipleDeploymentAllowed(true);
        this.metadata.setOperationalProperties(operationalProperties);
        ConfigurationParameterSettings_impl settings = new ConfigurationParameterSettings_impl();
        settings.setParameterValue("processorConfig", this.casProcessorType);
        this.metadata.setConfigurationParameterSettings(settings);
    }

    public void setProxy(VinciTAP aTap) {
        this.textAnalysisProxy = aTap;
    }

    public VinciTAP getProxy() {
        return this.textAnalysisProxy;
    }

    public CasData process(CasData aCas) throws ResourceProcessException {
        if (this.textAnalysisProxy == null) {
            throw new ResourceProcessException(new Exception(Thread.currentThread().getName() + CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_no_proxy__WARNING", new Object[]{Thread.currentThread().getName()})));
        }
        CasData casWithAnalysis = null;
        ProcessTrace_impl pt = new ProcessTrace_impl();
        try {
            long pStart = System.currentTimeMillis();
            casWithAnalysis = this.textAnalysisProxy.analyze(aCas, (ProcessTrace)pt, this.name);
            long pEnd = System.currentTimeMillis();
            this.totalTime += pEnd - pStart;
        }
        catch (ServiceException e) {
            if (!this.textAnalysisProxy.isConnected()) {
                if (UIMAFramework.getLogger().isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_service_down__INFO", new Object[]{Thread.currentThread().getName(), this.name});
                }
                throw new ResourceProcessException(new ServiceConnectionException(Thread.currentThread().getName() + CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_service_down__WARNING", new Object[]{Thread.currentThread().getName(), this.name})));
            }
            throw new ResourceProcessException(e);
        }
        catch (ServiceConnectionException e) {
            throw new ResourceProcessException(e);
        }
        catch (Exception e) {
            throw new ResourceProcessException(e);
        }
        return casWithAnalysis;
    }

    public CasData[] process(CasData[] aCasList) throws ResourceProcessException {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).log(Level.FINEST, Thread.currentThread().getName() + " ===================================Calling Proxy");
        }
        if (this.textAnalysisProxy == null) {
            throw new ResourceProcessException(new Exception(Thread.currentThread().getName() + CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_no_proxy__WARNING", new Object[]{Thread.currentThread().getName()})));
        }
        try {
            ProcessTrace_impl pt = new ProcessTrace_impl();
            return this.textAnalysisProxy.analyze(aCasList, (ProcessTrace)pt, this.name);
        }
        catch (ServiceConnectionException e) {
            throw new ResourceProcessException(e);
        }
        catch (ServiceException e) {
            throw new ResourceProcessException(e);
        }
    }

    public boolean isStateless() {
        OperationalProperties opProps;
        if (this.resourceMetadata == null) {
            try {
                this.resourceMetadata = this.textAnalysisProxy.getAnalysisEngineMetaData();
            }
            catch (ResourceServiceException e) {
                UIMAFramework.getLogger(this.getClass()).log(Level.SEVERE, e.getMessage(), e);
                return true;
            }
        }
        if ((opProps = this.resourceMetadata.getOperationalProperties()) != null) {
            return !opProps.isMultipleDeploymentAllowed();
        }
        return true;
    }

    public boolean isReadOnly() {
        OperationalProperties opProps;
        if (this.resourceMetadata == null) {
            try {
                this.resourceMetadata = this.textAnalysisProxy.getAnalysisEngineMetaData();
            }
            catch (ResourceServiceException e) {
                UIMAFramework.getLogger(this.getClass()).log(Level.SEVERE, e.getMessage(), e);
                return false;
            }
        }
        if ((opProps = this.resourceMetadata.getOperationalProperties()) != null) {
            return !opProps.getModifiesCas();
        }
        return false;
    }

    public ProcessingResourceMetaData getProcessingResourceMetaData() {
        if (this.textAnalysisProxy == null) {
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_use_default_metadata__FINEST", new Object[]{Thread.currentThread().getName(), this.name});
            }
            if (this.metadata == null) {
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_no_metadata__FINEST", new Object[]{Thread.currentThread().getName(), this.name});
                }
            } else if (this.metadata.getConfigurationParameterSettings().getParameterValue("processorConfig") == null && UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_no_cp_configuration_in_metadata__FINEST", new Object[]{Thread.currentThread().getName(), this.name});
            }
            return this.metadata;
        }
        try {
            if (!this.textAnalysisProxy.isConnected()) {
                if (UIMAFramework.getLogger().isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_service_down__INFO", new Object[]{Thread.currentThread().getName(), this.name});
                }
                throw new ResourceProcessException(new ServiceConnectionException("Service::" + this.name + " appears to be down"));
            }
            if (this.resourceMetadata == null) {
                this.resourceMetadata = this.textAnalysisProxy.getAnalysisEngineMetaData();
            }
            return this.resourceMetadata;
        }
        catch (Exception e) {
            if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_unable_to_read_meta__SEVERE", new Object[]{Thread.currentThread().getName(), e});
            }
            return this.metadata;
        }
    }

    public void batchProcessComplete(ProcessTrace aTrace) throws ResourceProcessException, IOException {
        if (!this.doSendNotification()) {
            return;
        }
        if (this.textAnalysisProxy != null) {
            try {
                this.textAnalysisProxy.batchProcessComplete();
            }
            catch (Exception e) {
                throw new ResourceProcessException(e);
            }
        }
    }

    public void collectionProcessComplete(ProcessTrace aTrace) throws ResourceProcessException, IOException {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_stopping_cp__FINEST", new Object[]{Thread.currentThread().getName(), this.name});
        }
        if (this.textAnalysisProxy != null) {
            if ("local".equals(this.casProcessorType.getDeployment().toLowerCase())) {
                this.textAnalysisProxy.shutdown(true, this.doSendNotification());
            } else {
                this.textAnalysisProxy.shutdown(false, this.doSendNotification());
            }
        }
        this.textAnalysisProxy = null;
        this.metadata = null;
    }

    private boolean doSendNotification() {
        return this.casProcessorType.getCheckpoint() == null || this.casProcessorType.getCheckpoint().getBatchSize() != 0;
    }
}

