/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas_data.impl;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.uima.cas_data.CasData;
import org.apache.uima.cas_data.FeatureStructure;
import org.apache.uima.cas_data.FeatureValue;
import org.apache.uima.cas_data.PrimitiveArrayFS;
import org.apache.uima.cas_data.PrimitiveValue;
import org.apache.uima.cas_data.ReferenceArrayFS;
import org.apache.uima.cas_data.ReferenceValue;
import org.apache.uima.internal.util.StringUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class CasDataToXCas {
    private String mDocumentTextTypeName = "uima.cpm.DocumentText";
    private String mDocumentTextFeatureName = "value";
    private String mXCasDocTextTag = "uima.cpm.DocumentText";
    private boolean mIncludeAnnotationSpannedText = false;
    private List<String> mTypesToFilter = null;
    private ContentHandler mHandler;

    public String getDocumentTextTypeName() {
        return this.mDocumentTextTypeName;
    }

    public void setDocumentTextTypeName(String aDocumentTextTypeName) {
        this.mDocumentTextTypeName = aDocumentTextTypeName;
    }

    public String getDocumentTextFeatureName() {
        return this.mDocumentTextFeatureName;
    }

    public void setDocumentTextFeatureName(String aDocumentTextFeatureName) {
        this.mDocumentTextFeatureName = aDocumentTextFeatureName;
    }

    public void setXCasDocumentTextTagName(String aXCasDocTextTag) {
        this.mXCasDocTextTag = aXCasDocTextTag;
    }

    public void setIncludeAnnotationSpannedText(boolean aIncludeAnnotationSpannedText) {
        this.mIncludeAnnotationSpannedText = aIncludeAnnotationSpannedText;
    }

    public void setTypesToFilter(String[] aTypesToFilter) {
        this.mTypesToFilter = Arrays.asList(aTypesToFilter);
    }

    public void setContentHandler(ContentHandler aHandler) {
        this.mHandler = aHandler;
    }

    public void generateXCas(CasData aCasData) throws SAXException {
        this.generateXCas(aCasData, null, true);
    }

    public void generateXCas(CasData aCasData, String aUEID) throws SAXException {
        this.generateXCas(aCasData, aUEID, true);
    }

    public void generateXCas(CasData aCasData, String aUEID, boolean aSendStartAndEndDocEvents) throws SAXException {
        if (aSendStartAndEndDocEvents) {
            this.mHandler.startDocument();
        }
        DocTextHolder docTextHolder = new DocTextHolder();
        this.mHandler.startElement("", "CAS", "CAS", new AttributesImpl());
        if (aUEID != null) {
            this.mHandler.startElement("", "UEID", "UEID", new AttributesImpl());
            this.mHandler.characters(aUEID.toCharArray(), 0, aUEID.length());
            this.mHandler.endElement("", "UEID", "UEID");
        }
        Iterator<FeatureStructure> iter2 = aCasData.getFeatureStructures();
        while (iter2.hasNext()) {
            FeatureStructure fs = iter2.next();
            if (this.mTypesToFilter != null && this.mTypesToFilter.contains(fs.getType())) continue;
            this._generate(fs, docTextHolder);
        }
        this.mHandler.endElement("", "CAS", "CAS");
        if (aSendStartAndEndDocEvents) {
            this.mHandler.endDocument();
        }
    }

    private void _generate(FeatureStructure aFS, DocTextHolder aDocTextHolder) throws SAXException {
        if (aFS.getType().equals(this.getDocumentTextTypeName())) {
            this._generateDocFS(aFS, aDocTextHolder);
        } else {
            int i;
            int[] indexed;
            AttributesImpl attrs = new AttributesImpl();
            String contentValue = null;
            if (aFS.getId() != null) {
                attrs.addAttribute("", "_id", "_id", "CDATA", aFS.getId());
            }
            if ((indexed = aFS.getIndexed()).length > 0) {
                StringBuffer indexedStr = new StringBuffer();
                indexedStr.append(indexed[0]);
                for (i = 1; i < indexed.length; ++i) {
                    indexedStr.append(' ').append(indexed[i]);
                }
                attrs.addAttribute("", "_indexed", "_indexed", "CDATA", indexedStr.toString());
            }
            String[] features = aFS.getFeatureNames();
            for (i = 0; i < features.length; ++i) {
                FeatureValue featVal = aFS.getFeatureValue(features[i]);
                if (featVal instanceof PrimitiveValue) {
                    if (!"value".equals(features[i])) {
                        attrs.addAttribute("", features[i], features[i], "CDATA", featVal.toString());
                        continue;
                    }
                    contentValue = featVal.toString();
                    continue;
                }
                if (!"value".equals(features[i])) {
                    attrs.addAttribute("", "_ref_" + features[i], "_ref_" + features[i], "CDATA", ((ReferenceValue)featVal).getTargetId());
                    continue;
                }
                contentValue = ((ReferenceValue)featVal).getTargetId();
            }
            String xcasElementName = this.getXCasElementName(aFS);
            this.mHandler.startElement("", xcasElementName, xcasElementName, attrs);
            String[] arrayElems = null;
            if (aFS instanceof PrimitiveArrayFS) {
                arrayElems = ((PrimitiveArrayFS)aFS).toStringArray();
            } else if (aFS instanceof ReferenceArrayFS) {
                arrayElems = ((ReferenceArrayFS)aFS).getIdRefArray();
            }
            if (arrayElems != null) {
                for (int j = 0; j < arrayElems.length; ++j) {
                    this.mHandler.startElement("", "i", "i", new AttributesImpl());
                    if (arrayElems[j] != null) {
                        this.mHandler.characters(arrayElems[j].toCharArray(), 0, arrayElems[j].length());
                    }
                    this.mHandler.endElement("", "i", "i");
                }
            }
            if (contentValue != null) {
                this.mHandler.characters(contentValue.toCharArray(), 0, contentValue.length());
            } else if (this.mIncludeAnnotationSpannedText && aDocTextHolder.docText != null && aDocTextHolder.docText.length > 0) {
                FeatureValue begin = aFS.getFeatureValue("begin");
                FeatureValue end = aFS.getFeatureValue("end");
                if (begin instanceof PrimitiveValue && end instanceof PrimitiveValue) {
                    int beginChar = ((PrimitiveValue)begin).toInt();
                    int endChar = ((PrimitiveValue)end).toInt();
                    if (beginChar >= 0 && endChar > beginChar && endChar <= aDocTextHolder.docText.length && (beginChar > 0 || endChar < aDocTextHolder.docText.length)) {
                        this.mHandler.characters(aDocTextHolder.docText, beginChar, endChar - beginChar);
                    }
                }
            }
            this.mHandler.endElement("", xcasElementName, xcasElementName);
        }
    }

    private String getXCasElementName(FeatureStructure aFS) {
        return StringUtils.replaceAll(StringUtils.replaceAll(aFS.getType(), "_colon_", ":"), "_dash_", "-");
    }

    private void _generateDocFS(FeatureStructure aFS, DocTextHolder aDocTextHolder) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        String textFeature = this.getDocumentTextFeatureName();
        FeatureValue docTextValue = aFS.getFeatureValue(textFeature);
        if (docTextValue != null) {
            String text2 = docTextValue.toString();
            aDocTextHolder.docText = text2.toCharArray();
            if (!textFeature.equals("value")) {
                attrs.addAttribute("", "_content", "_content", "CDATA", textFeature);
            }
            this.mHandler.startElement("", this.mXCasDocTextTag, this.mXCasDocTextTag, attrs);
            this.mHandler.characters(aDocTextHolder.docText, 0, aDocTextHolder.docText.length);
            this.mHandler.endElement("", this.mXCasDocTextTag, this.mXCasDocTextTag);
        } else {
            this.mHandler.startElement("", this.mXCasDocTextTag, this.mXCasDocTextTag, attrs);
            this.mHandler.endElement("", this.mXCasDocTextTag, this.mXCasDocTextTag);
        }
    }

    private static class DocTextHolder {
        char[] docText;

        private DocTextHolder() {
        }
    }
}

