/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.LongArrayFS;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CommonAuxArrayFSImpl;
import org.apache.uima.cas.impl.FSGenerator;

public class LongArrayFSImpl
extends CommonAuxArrayFSImpl
implements LongArrayFS {
    public LongArrayFSImpl(int addr, CASImpl cas) {
        super(cas, addr);
    }

    static FSGenerator generator() {
        return new LongArrayGenerator();
    }

    public int size() {
        return this.casImpl.ll_getArraySize(this.addr);
    }

    public long get(int i) {
        if (i < 0 || i >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.casImpl.ll_getLongArrayValue(this.addr, i);
    }

    public void set(int i, long val) throws ArrayIndexOutOfBoundsException {
        this.casImpl.ll_setLongArrayValue(this.addr, i, val);
    }

    public void copyFromArray(long[] src, int srcOffset, int destOffset, int length) throws ArrayIndexOutOfBoundsException {
        if (destOffset < 0 || destOffset + length > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int startoffset = this.casImpl.getHeap().heap[this.casImpl.getArrayStartAddress(this.addr)];
        destOffset += startoffset;
        for (int i = 0; i < length; ++i) {
            this.casImpl.ll_setLongArrayValue(this.addr, destOffset, src[srcOffset]);
            ++destOffset;
            ++srcOffset;
        }
    }

    public void copyToArray(int srcOffset, long[] dest, int destOffset, int length) throws ArrayIndexOutOfBoundsException {
        if (srcOffset < 0 || srcOffset + length > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = 0; i < length; ++i) {
            dest[destOffset] = this.casImpl.ll_getLongArrayValue(this.addr, srcOffset);
            ++destOffset;
            ++srcOffset;
        }
    }

    public long[] toArray() {
        int size2 = this.size();
        long[] outArray = new long[size2];
        this.copyToArray(0, outArray, 0, size2);
        return outArray;
    }

    public String[] toStringArray() {
        int size2 = this.size();
        String[] strArray = new String[size2];
        this.copyToArray(0, strArray, 0, size2);
        return strArray;
    }

    public void copyToArray(int srcOffset, String[] dest, int destOffset, int length) throws ArrayIndexOutOfBoundsException {
        if (srcOffset < 0 || srcOffset + length > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        long[] bDest = new long[dest.length];
        this.copyToArray(srcOffset, bDest, destOffset, length);
        for (int i = 0; i < length; ++i) {
            dest[destOffset] = Long.toString(bDest[destOffset]);
            ++destOffset;
        }
    }

    public void copyFromArray(String[] src, int srcOffset, int destOffset, int length) throws ArrayIndexOutOfBoundsException {
        long[] bArray = new long[length];
        for (int i = 0; i < length; ++i) {
            bArray[i] = Long.parseLong(src[i]);
        }
        this.copyFromArray(bArray, srcOffset, destOffset, length);
    }

    private static class LongArrayGenerator
    implements FSGenerator {
        private LongArrayGenerator() {
        }

        public FeatureStructure createFS(int addr, CASImpl cas) {
            return new LongArrayFSImpl(addr, cas);
        }
    }
}

