/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.List;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.SofaFS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.ByteArrayFSImpl;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CommonAuxArrayFSImpl;
import org.apache.uima.cas.impl.DoubleArrayFSImpl;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.LongArrayFSImpl;
import org.apache.uima.cas.impl.LowLevelCAS;
import org.apache.uima.cas.impl.LowLevelTypeSystem;
import org.apache.uima.cas.impl.ShortArrayFSImpl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.internal.util.IntSet;
import org.apache.uima.internal.util.StringUtils;
import org.apache.uima.internal.util.rb_trees.RedBlackTree;

public abstract class FeatureStructureImpl
implements FeatureStructure,
Cloneable {
    public abstract int getAddress();

    protected abstract CASImpl getCASImpl();

    public Type getType() {
        return this.getCASImpl().getTypeSystemImpl().ll_getTypeForCode(this.getCASImpl().getHeapValue(this.getAddress()));
    }

    public void setFeatureValue(Feature feat, FeatureStructure fs) {
        int valueAddr = this.getCASImpl().ll_getFSRef(fs);
        int featCode = ((FeatureImpl)feat).getCode();
        int rangeType = this.getCASImpl().getTypeSystemImpl().range(featCode);
        if (valueAddr == 0) {
            this.setNullValue(featCode, rangeType);
            return;
        }
        int thisType = this.getCASImpl().getHeapValue(this.getAddress());
        int valueType = this.getCASImpl().getHeapValue(valueAddr);
        if (!this.getCASImpl().getTypeSystemImpl().isApprop(thisType, featCode)) {
            CASRuntimeException e = new CASRuntimeException("INAPPROP_TYPE", new String[]{feat.getName(), this.getType().getName()});
            throw e;
        }
        if (!this.getCASImpl().getTypeSystemImpl().subsumes(rangeType, valueType)) {
            CASRuntimeException e = new CASRuntimeException("INAPPROP_RANGE", new String[]{feat.getName(), feat.getRange().getName(), fs.getType().getName()});
            throw e;
        }
        this.getCASImpl().setFeatureValue(this.getAddress(), featCode, valueAddr);
    }

    private final void setNullValue(int featCode, int rangeType) {
        if (this.getCASImpl().isIntType(rangeType) || this.getCASImpl().isFloatType(rangeType) || this.getCASImpl().isStringType(rangeType)) {
            CASRuntimeException e = new CASRuntimeException("PRIMITIVE_VAL_FEAT", new String[]{this.getCASImpl().getTypeSystemImpl().ll_getFeatureForCode(featCode).getName()});
            throw e;
        }
        this.getCASImpl().setFeatureValue(this.getAddress(), featCode, 0);
    }

    public void setIntValue(Feature feat, int val) {
        TypeSystemImpl ts = this.getCASImpl().getTypeSystemImpl();
        if (!ts.subsumes(((TypeImpl)feat.getDomain()).getCode(), this.getCASImpl().getHeapValue(this.getAddress()))) {
            FeatureStructureImpl.throwUndefinedFeatureExc(feat, this.getType());
        }
        if (!ts.subsumes(((TypeImpl)feat.getRange()).getCode(), ((TypeImpl)ts.getType("uima.cas.Integer")).getCode())) {
            FeatureStructureImpl.throwIllegalRangeExc(feat, ts.getType("uima.cas.Integer"));
        }
        int featCode = ((FeatureImpl)feat).getCode();
        this.getCASImpl().setFeatureValue(this.getAddress(), featCode, val);
    }

    public void setFloatValue(Feature feat, float val) {
        TypeSystemImpl ts = this.getCASImpl().getTypeSystemImpl();
        if (!ts.subsumes(((TypeImpl)feat.getDomain()).getCode(), this.getCASImpl().getHeapValue(this.getAddress()))) {
            FeatureStructureImpl.throwUndefinedFeatureExc(feat, this.getType());
        }
        if (!ts.subsumes(((TypeImpl)feat.getRange()).getCode(), ((TypeImpl)ts.getType("uima.cas.Float")).getCode())) {
            FeatureStructureImpl.throwIllegalRangeExc(feat, ts.getType("uima.cas.Float"));
        }
        int featCode = ((FeatureImpl)feat).getCode();
        this.getCASImpl().setFloatValue(this.getAddress(), featCode, val);
    }

    public void setStringValue(Feature feat, String val) {
        TypeSystemImpl ts = this.getCASImpl().getTypeSystemImpl();
        int featCode = ((FeatureImpl)feat).getCode();
        int rangeType = ts.range(featCode);
        int thisType = this.getCASImpl().getHeapValue(this.getAddress());
        int stringType = ((TypeImpl)this.getCASImpl().getTypeSystem().getType("uima.cas.String")).getCode();
        if (!ts.isApprop(thisType, featCode)) {
            CASRuntimeException e = new CASRuntimeException("INAPPROP_FEAT", new String[]{feat.getName(), this.getType().getName()});
            throw e;
        }
        if (!ts.subsumes(stringType, rangeType)) {
            CASRuntimeException e = new CASRuntimeException("INAPPROP_TYPE", new String[]{feat.getRange().getName(), this.getCAS().getTypeSystem().getType("uima.cas.String").getName()});
            throw e;
        }
        this.getCAS().getLowLevelCAS().ll_setStringValue(this.getAddress(), featCode, val);
    }

    public void setByteValue(Feature feat, byte val) throws CASRuntimeException {
        TypeSystemImpl ts = this.getCASImpl().getTypeSystemImpl();
        if (!ts.subsumes(((TypeImpl)feat.getDomain()).getCode(), this.getCASImpl().getHeapValue(this.getAddress()))) {
            FeatureStructureImpl.throwUndefinedFeatureExc(feat, this.getType());
        }
        if (!ts.subsumes(((TypeImpl)feat.getRange()).getCode(), ((TypeImpl)ts.getType("uima.cas.Byte")).getCode())) {
            FeatureStructureImpl.throwIllegalRangeExc(feat, ts.getType("uima.cas.Byte"));
        }
        int featCode = ((FeatureImpl)feat).getCode();
        this.getCASImpl().setFeatureValue(this.getAddress(), featCode, val);
    }

    public void setBooleanValue(Feature feat, boolean b) throws CASRuntimeException {
        TypeSystemImpl ts = this.getCASImpl().getTypeSystemImpl();
        if (!ts.subsumes(((TypeImpl)feat.getDomain()).getCode(), this.getCASImpl().getHeapValue(this.getAddress()))) {
            FeatureStructureImpl.throwUndefinedFeatureExc(feat, this.getType());
        }
        if (!ts.subsumes(((TypeImpl)feat.getRange()).getCode(), ((TypeImpl)ts.getType("uima.cas.Boolean")).getCode())) {
            FeatureStructureImpl.throwIllegalRangeExc(feat, ts.getType("uima.cas.Boolean"));
        }
        int featCode = ((FeatureImpl)feat).getCode();
        this.getCASImpl().setFeatureValue(this.getAddress(), featCode, b);
    }

    public void setShortValue(Feature feat, short val) throws CASRuntimeException {
        TypeSystemImpl ts = this.getCASImpl().getTypeSystemImpl();
        if (!ts.subsumes(((TypeImpl)feat.getDomain()).getCode(), this.getCASImpl().getHeapValue(this.getAddress()))) {
            FeatureStructureImpl.throwUndefinedFeatureExc(feat, this.getType());
        }
        if (!ts.subsumes(((TypeImpl)feat.getRange()).getCode(), ((TypeImpl)ts.getType("uima.cas.Short")).getCode())) {
            FeatureStructureImpl.throwIllegalRangeExc(feat, ts.getType("uima.cas.Short"));
        }
        int featCode = ((FeatureImpl)feat).getCode();
        this.getCASImpl().setFeatureValue(this.getAddress(), featCode, val);
    }

    public void setLongValue(Feature feat, long val) throws CASRuntimeException {
        TypeSystemImpl ts = this.getCASImpl().getTypeSystemImpl();
        if (!ts.subsumes(((TypeImpl)feat.getDomain()).getCode(), this.getCASImpl().getHeapValue(this.getAddress()))) {
            FeatureStructureImpl.throwUndefinedFeatureExc(feat, this.getType());
        }
        if (!ts.subsumes(((TypeImpl)feat.getRange()).getCode(), ((TypeImpl)ts.getType("uima.cas.Long")).getCode())) {
            FeatureStructureImpl.throwIllegalRangeExc(feat, ts.getType("uima.cas.Long"));
        }
        int featCode = ((FeatureImpl)feat).getCode();
        this.getCASImpl().setFeatureValue(this.getAddress(), featCode, val);
    }

    public void setDoubleValue(Feature feat, double val) throws CASRuntimeException {
        TypeSystemImpl ts = this.getCASImpl().getTypeSystemImpl();
        if (!ts.subsumes(((TypeImpl)feat.getDomain()).getCode(), this.getCASImpl().getHeapValue(this.getAddress()))) {
            FeatureStructureImpl.throwUndefinedFeatureExc(feat, this.getType());
        }
        if (!ts.subsumes(((TypeImpl)feat.getRange()).getCode(), ((TypeImpl)ts.getType("uima.cas.Double")).getCode())) {
            FeatureStructureImpl.throwIllegalRangeExc(feat, ts.getType("uima.cas.Double"));
        }
        int featCode = ((FeatureImpl)feat).getCode();
        this.getCASImpl().setFeatureValue(this.getAddress(), featCode, val);
    }

    public void setFeatureValueFromString(Feature feat, String s) throws CASRuntimeException {
        this.getCASImpl().setFeatureValueFromString(this.getAddress(), ((FeatureImpl)feat).getCode(), s);
    }

    public FeatureStructure getFeatureValue(Feature feat) throws CASRuntimeException {
        TypeSystemImpl ts = this.getCASImpl().getTypeSystemImpl();
        int featCode = ((FeatureImpl)feat).getCode();
        if (!ts.isApprop(this.getCASImpl().getHeapValue(this.getAddress()), featCode)) {
            CASRuntimeException e = new CASRuntimeException("INAPPROP_FEAT", new String[]{feat.getName(), this.getType().getName()});
            throw e;
        }
        int rangeTypeCode = ts.ll_getRangeType(featCode);
        if (!this.getCASImpl().ll_isRefType(rangeTypeCode)) {
            CASRuntimeException e = new CASRuntimeException("PRIMITIVE_VAL_FEAT", new String[]{feat.getName()});
            throw e;
        }
        int valAddr = this.getCASImpl().getFeatureValue(this.getAddress(), featCode);
        return this.getCASImpl().createFS(valAddr);
    }

    public int getIntValue(Feature feat) {
        TypeSystemImpl ts = this.getCASImpl().getTypeSystemImpl();
        if (!ts.subsumes(feat.getDomain(), this.getType())) {
            FeatureStructureImpl.throwUndefinedFeatureExc(feat, this.getType());
        }
        if (!ts.subsumes(feat.getRange(), ts.getType("uima.cas.Integer"))) {
            FeatureStructureImpl.throwIllegalRangeExc(feat, ts.getType("uima.cas.Integer"));
        }
        int featCode = ((FeatureImpl)feat).getCode();
        return this.getCASImpl().getFeatureValue(this.getAddress(), featCode);
    }

    public float getFloatValue(Feature feat) throws CASRuntimeException {
        TypeSystemImpl ts = this.getCASImpl().getTypeSystemImpl();
        if (!ts.subsumes(feat.getDomain(), this.getType())) {
            FeatureStructureImpl.throwUndefinedFeatureExc(feat, this.getType());
        }
        if (!ts.subsumes(feat.getRange(), ts.getType("uima.cas.Float"))) {
            FeatureStructureImpl.throwIllegalRangeExc(feat, ts.getType("uima.cas.Float"));
        }
        int featCode = ((FeatureImpl)feat).getCode();
        return this.getCASImpl().getFloatValue(this.getAddress(), featCode);
    }

    public String getStringValue(Feature f2) throws CASRuntimeException {
        int thisType = ((TypeImpl)this.getType()).getCode();
        int domType = ((TypeImpl)f2.getDomain()).getCode();
        int stringType = ((TypeImpl)this.getCASImpl().getTypeSystem().getType("uima.cas.String")).getCode();
        int rangeType = ((TypeImpl)f2.getRange()).getCode();
        TypeSystemImpl ts = (TypeSystemImpl)this.getCASImpl().getTypeSystem();
        if (!ts.subsumes(domType, thisType)) {
            FeatureStructureImpl.throwUndefinedFeatureExc(f2, this.getType());
        }
        if (!ts.subsumes(stringType, rangeType)) {
            FeatureStructureImpl.throwIllegalRangeExc(f2, this.getCASImpl().getTypeSystem().getType("uima.cas.String"));
        }
        return this.getCASImpl().getStringValue(this.getAddress(), ((FeatureImpl)f2).getCode());
    }

    public byte getByteValue(Feature feat) throws CASRuntimeException {
        TypeSystemImpl ts = this.getCASImpl().getTypeSystemImpl();
        if (!ts.subsumes(feat.getDomain(), this.getType())) {
            FeatureStructureImpl.throwUndefinedFeatureExc(feat, this.getType());
        }
        if (!ts.subsumes(feat.getRange(), ts.getType("uima.cas.Byte"))) {
            FeatureStructureImpl.throwIllegalRangeExc(feat, ts.getType("uima.cas.Byte"));
        }
        int featCode = ((FeatureImpl)feat).getCode();
        return this.getCASImpl().getByteValue(this.getAddress(), featCode);
    }

    public boolean getBooleanValue(Feature feat) throws CASRuntimeException {
        TypeSystemImpl ts = this.getCASImpl().getTypeSystemImpl();
        if (!ts.subsumes(feat.getDomain(), this.getType())) {
            FeatureStructureImpl.throwUndefinedFeatureExc(feat, this.getType());
        }
        if (!ts.subsumes(feat.getRange(), ts.getType("uima.cas.Boolean"))) {
            FeatureStructureImpl.throwIllegalRangeExc(feat, ts.getType("uima.cas.Boolean"));
        }
        int featCode = ((FeatureImpl)feat).getCode();
        return this.getCASImpl().getBooleanValue(this.getAddress(), featCode);
    }

    public short getShortValue(Feature feat) throws CASRuntimeException {
        TypeSystemImpl ts = this.getCASImpl().getTypeSystemImpl();
        if (!ts.subsumes(feat.getDomain(), this.getType())) {
            FeatureStructureImpl.throwUndefinedFeatureExc(feat, this.getType());
        }
        if (!ts.subsumes(feat.getRange(), ts.getType("uima.cas.Short"))) {
            FeatureStructureImpl.throwIllegalRangeExc(feat, ts.getType("uima.cas.Short"));
        }
        int featCode = ((FeatureImpl)feat).getCode();
        return this.getCASImpl().getShortValue(this.getAddress(), featCode);
    }

    public long getLongValue(Feature feat) throws CASRuntimeException {
        TypeSystemImpl ts = this.getCASImpl().getTypeSystemImpl();
        if (!ts.subsumes(feat.getDomain(), this.getType())) {
            FeatureStructureImpl.throwUndefinedFeatureExc(feat, this.getType());
        }
        if (!ts.subsumes(feat.getRange(), ts.getType("uima.cas.Long"))) {
            FeatureStructureImpl.throwIllegalRangeExc(feat, ts.getType("uima.cas.Long"));
        }
        int featCode = ((FeatureImpl)feat).getCode();
        return this.getCASImpl().getLongValue(this.getAddress(), featCode);
    }

    public double getDoubleValue(Feature feat) throws CASRuntimeException {
        TypeSystemImpl ts = this.getCASImpl().getTypeSystemImpl();
        if (!ts.subsumes(feat.getDomain(), this.getType())) {
            FeatureStructureImpl.throwUndefinedFeatureExc(feat, this.getType());
        }
        if (!ts.subsumes(feat.getRange(), ts.getType("uima.cas.Double"))) {
            FeatureStructureImpl.throwIllegalRangeExc(feat, ts.getType("uima.cas.Double"));
        }
        int featCode = ((FeatureImpl)feat).getCode();
        return this.getCASImpl().getDoubleValue(this.getAddress(), featCode);
    }

    public String getFeatureValueAsString(Feature feat) throws CASRuntimeException {
        return this.getCASImpl().getFeatureValueAsString(this.getAddress(), ((FeatureImpl)feat).getCode());
    }

    private static final void throwIllegalRangeExc(Feature f2, Type t) throws CASRuntimeException {
        CASRuntimeException e = new CASRuntimeException("INAPPROP_RANGE", new String[]{f2.getName(), t.getName(), f2.getRange().getName()});
        throw e;
    }

    private static final void throwUndefinedFeatureExc(Feature f2, Type t) throws CASRuntimeException {
        CASRuntimeException e = new CASRuntimeException("INAPPROP_FEAT", new String[]{f2.getName(), t.getName()});
        throw e;
    }

    private final void getPrintRefs(PrintReferences printRefs) {
        this.getPrintRefs(printRefs, this.getAddress());
    }

    private final void getPrintRefs(PrintReferences printRefs, int ref2) {
        boolean seenBefore = printRefs.addReference(ref2);
        if (seenBefore) {
            return;
        }
        LowLevelCAS llcas = this.getCASImpl().getLowLevelCAS();
        LowLevelTypeSystem llts = llcas.ll_getTypeSystem();
        int typeCode = llcas.ll_getFSRefType(ref2, true);
        int[] feats = llts.ll_getAppropriateFeatures(typeCode);
        for (int i = 0; i < feats.length; ++i) {
            int valRef;
            if (!llcas.ll_isRefType(llts.ll_getRangeType(feats[i])) || (valRef = llcas.ll_getRefValue(ref2, feats[i])) == 0) continue;
            this.getPrintRefs(printRefs, valRef);
        }
    }

    public String toString() {
        return this.toString(3);
    }

    public String toString(int indent) {
        StringBuffer buf = new StringBuffer();
        this.prettyPrint(0, indent, buf, true, null);
        return buf.toString();
    }

    public void prettyPrint(int indent, int incr, StringBuffer buf, boolean useShortNames) {
        this.prettyPrint(indent, incr, buf, useShortNames, null);
    }

    public void prettyPrint(int indent, int incr, StringBuffer buf, boolean useShortNames, String s) {
        PrintReferences printRefs = new PrintReferences();
        this.getPrintRefs(printRefs);
        this.prettyPrint(indent, incr, buf, useShortNames, s, printRefs);
    }

    public void prettyPrint(int indent, int incr, StringBuffer buf, boolean useShortNames, String s, PrintReferences printRefs) {
        int i;
        int arrayLen;
        indent += incr;
        int printInfo = printRefs.printInfo(this.getAddress());
        if (printInfo != 0) {
            buf.append(printRefs.getLabel(this.getAddress()));
            if (printInfo == 2) {
                buf.append('\n');
                return;
            }
            buf.append(' ');
        }
        if (useShortNames) {
            buf.append(this.getType().getShortName());
        } else {
            buf.append(this.getType().getName());
        }
        if (s != null) {
            buf.append(" \"" + s + "\"");
        }
        buf.append("\n");
        CommonAuxArrayFSImpl arrayFS = null;
        LowLevelTypeSystem llts = this.getCASImpl().ll_getTypeSystem();
        int typeClass = this.getCASImpl().ll_getTypeClass(llts.ll_getCodeForType(this.getType()));
        if (typeClass == 6) {
            arrayLen = this.getCASImpl().ll_getArraySize(this.getAddress());
            StringUtils.printSpaces(indent, buf);
            buf.append("Array length: " + arrayLen + "\n");
            if (arrayLen > 0) {
                StringUtils.printSpaces(indent, buf);
                buf.append("Array elements: [");
                for (i = 0; i < arrayLen; ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    String element = this.getCASImpl().ll_getStringArrayValue(this.getAddress(), i);
                    buf.append("\"" + element + "\"");
                }
                buf.append("]\n");
            }
        } else if (typeClass == 4) {
            arrayLen = this.getCASImpl().ll_getArraySize(this.getAddress());
            StringUtils.printSpaces(indent, buf);
            buf.append("Array length: " + arrayLen + "\n");
            if (arrayLen > 0) {
                StringUtils.printSpaces(indent, buf);
                buf.append("Array elements: [");
                for (i = 0; i < arrayLen; ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    int element = this.getCASImpl().ll_getIntArrayValue(this.getAddress(), i);
                    buf.append(element);
                }
                buf.append("]\n");
            }
        } else if (typeClass == 5) {
            arrayLen = this.getCASImpl().ll_getArraySize(this.getAddress());
            StringUtils.printSpaces(indent, buf);
            buf.append("Array length: " + arrayLen + "\n");
            if (arrayLen > 0) {
                StringUtils.printSpaces(indent, buf);
                buf.append("Array elements: [");
                for (i = 0; i < arrayLen; ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    float element = this.getCASImpl().ll_getFloatArrayValue(this.getAddress(), i);
                    buf.append(element);
                }
                buf.append("]\n");
            }
        } else if (typeClass == 15 || typeClass == 14 || typeClass == 16 || typeClass == 17 || typeClass == 18) {
            if (typeClass == 14) {
                arrayFS = new ByteArrayFSImpl(this.getAddress(), this.getCASImpl());
            } else if (typeClass == 15) {
                arrayFS = new ByteArrayFSImpl(this.getAddress(), this.getCASImpl());
            } else if (typeClass == 16) {
                arrayFS = new ShortArrayFSImpl(this.getAddress(), this.getCASImpl());
            } else if (typeClass == 17) {
                arrayFS = new LongArrayFSImpl(this.getAddress(), this.getCASImpl());
            } else if (typeClass == 18) {
                arrayFS = new DoubleArrayFSImpl(this.getAddress(), this.getCASImpl());
            }
            arrayLen = this.getCASImpl().ll_getArraySize(this.getAddress());
            StringUtils.printSpaces(indent, buf);
            buf.append("Array length: " + arrayLen + "\n");
            if (arrayLen > 0) {
                int numToPrint = arrayLen;
                if (arrayLen > 15) {
                    numToPrint = 15;
                }
                String[] dest = new String[numToPrint];
                arrayFS.copyToArray(0, dest, 0, numToPrint);
                StringUtils.printSpaces(indent, buf);
                buf.append("Array elements: [");
                for (int i2 = 0; i2 < numToPrint; ++i2) {
                    if (i2 > 0) {
                        buf.append(", ");
                    }
                    buf.append(dest[i2]);
                }
                if (arrayLen > numToPrint) {
                    buf.append(", ...");
                }
                buf.append("]\n");
            }
        }
        List<Feature> feats = this.getType().getFeatures();
        for (int i3 = 0; i3 < feats.size(); ++i3) {
            StringUtils.printSpaces(indent, buf);
            Feature feat = feats.get(i3);
            buf.append(feat.getShortName() + ": ");
            Type approp = feat.getRange();
            if (approp.equals(this.getCASImpl().getTypeSystem().getType("uima.cas.String")) || this.getCAS().getTypeSystem().getParent(approp) != null && this.getCAS().getTypeSystem().getParent(approp).equals(this.getCASImpl().getTypeSystem().getType("uima.cas.String"))) {
                String stringVal2 = this.getStringValue(feat);
                stringVal2 = stringVal2 == null ? "<null>" : "\"" + stringVal2 + "\"";
                buf.append(stringVal2 + "\n");
                continue;
            }
            if (!approp.isPrimitive()) {
                FeatureStructureImpl val = (FeatureStructureImpl)this.getFeatureValue(feat);
                if (val == null) {
                    buf.append("<null>\n");
                    continue;
                }
                if (!approp.getName().equals("uima.cas.Sofa")) {
                    val.prettyPrint(indent, incr, buf, useShortNames, null, printRefs);
                    continue;
                }
                buf.append(((SofaFS)((Object)val)).getSofaID() + "\n");
                continue;
            }
            buf.append(this.getFeatureValueAsString(feat) + "\n");
        }
    }

    public Object clone() throws CASRuntimeException {
        if (this.getType().getName().equals("uima.cas.Sofa")) {
            throw new CASRuntimeException("CANNOT_CLONE_SOFA");
        }
        CASImpl casImpl = this.getCASImpl();
        FeatureStructure newFS = this.getCAS().createFS(this.getType());
        casImpl.copyFeatures(((FeatureStructureImpl)newFS).getAddress(), this.getAddress());
        return newFS;
    }

    private static class PrintReferences {
        static final int NO_LABEL = 0;
        static final int WITH_LABEL = 1;
        static final int JUST_LABEL = 2;
        private static final String refNamePrefix = "#";
        private RedBlackTree<String> tree = new RedBlackTree();
        private IntSet seen = new IntSet();
        private int count = 0;

        private PrintReferences() {
        }

        boolean addReference(int ref2) {
            if (this.tree.containsKey(ref2)) {
                String refName = this.tree.get(ref2);
                if (refName == null) {
                    refName = refNamePrefix + Integer.toString(this.count);
                    ++this.count;
                    this.tree.put(ref2, refName);
                }
                return true;
            }
            this.tree.put(ref2, null);
            return false;
        }

        String getLabel(int ref2) {
            return this.tree.get(ref2);
        }

        int printInfo(int ref2) {
            if (this.tree.get(ref2) == null) {
                return 0;
            }
            if (this.seen.contains(ref2)) {
                return 2;
            }
            this.seen.add(ref2);
            return 1;
        }
    }
}

