/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.uima.cas.ArrayFS;
import org.apache.uima.cas.BooleanArrayFS;
import org.apache.uima.cas.ByteArrayFS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.DoubleArrayFS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeaturePath;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.FloatArrayFS;
import org.apache.uima.cas.IntArrayFS;
import org.apache.uima.cas.LongArrayFS;
import org.apache.uima.cas.ShortArrayFS;
import org.apache.uima.cas.StringArrayFS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeClass;
import org.apache.uima.cas.impl.FeaturePathValue;
import org.apache.uima.cas.impl.LowLevelCAS;
import org.apache.uima.cas.impl.LowLevelTypeSystem;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemUtils;
import org.apache.uima.cas.text.AnnotationFS;

class FeaturePathImpl
implements FeaturePath {
    private static final String MESSAGE_DIGEST = "org.apache.uima.cas.impl.annot_impl";
    private static final String FEATURE_PATH_SEPARATOR = "/";
    private static final String BUILT_IN_FUNCTION_SEPARATOR = ":";
    private static final byte NO_BUILT_IN_FUNCTION = 0;
    private static final byte FUNCTION_COVERED_TEXT = 1;
    private static final byte FUNCTION_ID = 2;
    private static final byte FUNCTION_TYPE_NAME = 3;
    private static final String FUNCTION_NAME_COVERED_TEXT = "coveredtext()";
    private static final String FUNCTION_NAME_ID = "fsid()";
    private static final String FUNCTION_NAME_TYPE_NAME = "typename()";
    private byte builtInFunction = 0;
    private String featurePathString;
    private ArrayList<String> featurePathElementNames = new ArrayList();
    private ArrayList<Feature> featurePathElements = new ArrayList();
    private ArrayList<Integer> ll_featurePathElements = null;
    private Type featurePathBaseType = null;
    private int featurePathBaseTypeCode = 0;

    public void addFeature(Feature feat) {
        if (this.builtInFunction > 0) {
            throw new CASRuntimeException(MESSAGE_DIGEST, "INVALID_FEATURE_PATH_SYNTAX_ADD", new Object[]{this.featurePathString, feat.getShortName()});
        }
        this.featurePathElementNames.add(feat.getShortName());
        this.featurePathString = this.featurePathString == null ? FEATURE_PATH_SEPARATOR + feat.getShortName() : this.featurePathString + FEATURE_PATH_SEPARATOR + feat.getShortName();
        this.featurePathElements.add(feat);
        if (this.ll_featurePathElements != null) {
            TypeSystemUtils.PathValid pathValid = TypeSystemUtils.isPathValid(this.featurePathBaseType, this.featurePathElementNames);
            if (TypeSystemUtils.PathValid.ALWAYS == pathValid) {
                LowLevelTypeSystem llTypeSystem = ((TypeImpl)this.featurePathBaseType).getTypeSystem().getLowLevelTypeSystem();
                this.ll_featurePathElements.add(llTypeSystem.ll_getCodeForFeature(feat));
            } else {
                this.ll_featurePathElements = null;
            }
        }
    }

    public Feature getFeature(int i) {
        if (this.featurePathElementNames.size() == this.featurePathElements.size()) {
            return this.featurePathElements.get(i);
        }
        return null;
    }

    public int size() {
        return this.featurePathElementNames.size();
    }

    public void initialize(String featurePath) throws CASException {
        this.featurePathString = featurePath;
        this.builtInFunction = 0;
        if (featurePath == null) {
            throw new CASException(MESSAGE_DIGEST, "INVALID_FEATURE_PATH_SYNTAX", new Object[]{featurePath, null});
        }
        if (this.featurePathString.indexOf("//") > -1) {
            throw new CASException(MESSAGE_DIGEST, "INVALID_FEATURE_PATH_SYNTAX", new Object[]{this.featurePathString, "//"});
        }
        StringTokenizer tokenizer = new StringTokenizer(this.featurePathString, FEATURE_PATH_SEPARATOR);
        while (tokenizer.hasMoreTokens()) {
            String token2 = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                this.featurePathElementNames.add(token2);
                continue;
            }
            int index = -1;
            index = token2.indexOf(BUILT_IN_FUNCTION_SEPARATOR);
            if (index != -1) {
                String builtInFunctionName;
                if (index > 0) {
                    this.featurePathElementNames.add(token2.substring(0, index));
                }
                if ((builtInFunctionName = token2.substring(index + 1).toLowerCase()).equals(FUNCTION_NAME_COVERED_TEXT)) {
                    this.builtInFunction = 1;
                    continue;
                }
                if (builtInFunctionName.equals(FUNCTION_NAME_ID)) {
                    this.builtInFunction = (byte)2;
                    continue;
                }
                if (builtInFunctionName.equals(FUNCTION_NAME_TYPE_NAME)) {
                    this.builtInFunction = (byte)3;
                    continue;
                }
                throw new CASException(MESSAGE_DIGEST, "INVALID_FEATURE_PATH_SYNTAX", new Object[]{this.featurePathString, builtInFunctionName});
            }
            this.featurePathElementNames.add(token2);
        }
    }

    public void typeInit(Type featurePathType) throws CASException {
        if (this.featurePathElementNames.size() > 0) {
            LowLevelTypeSystem llTypeSystem = ((TypeImpl)featurePathType).getTypeSystem().getLowLevelTypeSystem();
            this.featurePathBaseType = featurePathType;
            this.featurePathBaseTypeCode = llTypeSystem.ll_getCodeForType(featurePathType);
            TypeSystemUtils.PathValid pathValid = TypeSystemUtils.isPathValid(featurePathType, this.featurePathElementNames);
            if (TypeSystemUtils.PathValid.NEVER == pathValid) {
                throw new CASException(MESSAGE_DIGEST, "ERROR_VALIDATE_FEATURE_PATH", new Object[]{this.featurePathString, featurePathType.getName()});
            }
            if (TypeSystemUtils.PathValid.ALWAYS == pathValid) {
                this.ll_featurePathElements = new ArrayList();
                this.featurePathElements = new ArrayList();
                Type currentType = featurePathType;
                for (int i = 0; i < this.featurePathElementNames.size(); ++i) {
                    Feature feature = currentType.getFeatureByBaseName(this.featurePathElementNames.get(i));
                    this.ll_featurePathElements.add(llTypeSystem.ll_getCodeForFeature(feature));
                    this.featurePathElements.add(feature);
                    currentType = feature.getRange();
                }
            }
        }
    }

    public String getFeaturePath() {
        return this.featurePathString;
    }

    public Boolean getBooleanValue(FeatureStructure fs) {
        LowLevelCAS llCas;
        FeaturePathValue featurePathValue;
        if (fs != null && (featurePathValue = this.getValue((llCas = fs.getCAS().getLowLevelCAS()).ll_getFSRef(fs), llCas)) != null && featurePathValue.getTypeClass() == 9) {
            return featurePathValue.getBooleanValue();
        }
        return null;
    }

    public Byte getByteValue(FeatureStructure fs) {
        LowLevelCAS llCas;
        FeaturePathValue featurePathValue;
        if (fs != null && (featurePathValue = this.getValue((llCas = fs.getCAS().getLowLevelCAS()).ll_getFSRef(fs), llCas)) != null && featurePathValue.getTypeClass() == 10) {
            return featurePathValue.getByteValue();
        }
        return null;
    }

    public Double getDoubleValue(FeatureStructure fs) {
        LowLevelCAS llCas;
        FeaturePathValue featurePathValue;
        if (fs != null && (featurePathValue = this.getValue((llCas = fs.getCAS().getLowLevelCAS()).ll_getFSRef(fs), llCas)) != null && featurePathValue.getTypeClass() == 13) {
            return featurePathValue.getDoubleValue();
        }
        return null;
    }

    public Float getFloatValue(FeatureStructure fs) {
        LowLevelCAS llCas;
        FeaturePathValue featurePathValue;
        if (fs != null && (featurePathValue = this.getValue((llCas = fs.getCAS().getLowLevelCAS()).ll_getFSRef(fs), llCas)) != null && featurePathValue.getTypeClass() == 2) {
            return Float.valueOf(featurePathValue.getFloatValue());
        }
        return null;
    }

    public FeatureStructure getFSValue(FeatureStructure fs) {
        LowLevelCAS llCas;
        FeaturePathValue featurePathValue;
        if (fs != null && (featurePathValue = this.getValue((llCas = fs.getCAS().getLowLevelCAS()).ll_getFSRef(fs), llCas)) != null && (featurePathValue.getTypeClass() == 8 || featurePathValue.getTypeClass() == 15 || featurePathValue.getTypeClass() == 18 || featurePathValue.getTypeClass() == 5 || featurePathValue.getTypeClass() == 7 || featurePathValue.getTypeClass() == 4 || featurePathValue.getTypeClass() == 17 || featurePathValue.getTypeClass() == 16 || featurePathValue.getTypeClass() == 6 || featurePathValue.getTypeClass() == 14)) {
            return featurePathValue.getFs();
        }
        return null;
    }

    public Integer getIntValue(FeatureStructure fs) {
        LowLevelCAS llCas;
        FeaturePathValue featurePathValue;
        if (fs != null && (featurePathValue = this.getValue((llCas = fs.getCAS().getLowLevelCAS()).ll_getFSRef(fs), llCas)) != null && featurePathValue.getTypeClass() == 1) {
            return featurePathValue.getIntValue();
        }
        return null;
    }

    public Long getLongValue(FeatureStructure fs) {
        LowLevelCAS llCas;
        FeaturePathValue featurePathValue;
        if (fs != null && (featurePathValue = this.getValue((llCas = fs.getCAS().getLowLevelCAS()).ll_getFSRef(fs), llCas)) != null && featurePathValue.getTypeClass() == 12) {
            return featurePathValue.getLongValue();
        }
        return null;
    }

    public Short getShortValue(FeatureStructure fs) {
        LowLevelCAS llCas;
        FeaturePathValue featurePathValue;
        if (fs != null && (featurePathValue = this.getValue((llCas = fs.getCAS().getLowLevelCAS()).ll_getFSRef(fs), llCas)) != null && featurePathValue.getTypeClass() == 11) {
            return featurePathValue.getShortValue();
        }
        return null;
    }

    public String getStringValue(FeatureStructure fs) {
        LowLevelCAS llCas;
        FeaturePathValue featurePathValue;
        if (fs != null && (featurePathValue = this.getValue((llCas = fs.getCAS().getLowLevelCAS()).ll_getFSRef(fs), llCas)) != null && featurePathValue.getTypeClass() == 3) {
            return featurePathValue.getStringValue();
        }
        return null;
    }

    public Type getType(FeatureStructure fs) {
        LowLevelCAS llCas;
        FeaturePathValue featurePathValue;
        if (fs != null && (featurePathValue = this.getValue((llCas = fs.getCAS().getLowLevelCAS()).ll_getFSRef(fs), llCas)) != null) {
            return featurePathValue.getFeatureType();
        }
        return null;
    }

    public TypeClass getTypClass(FeatureStructure fs) {
        LowLevelCAS llCas;
        FeaturePathValue featurePathValue;
        if (fs != null && (featurePathValue = this.getValue((llCas = fs.getCAS().getLowLevelCAS()).ll_getFSRef(fs), llCas)) != null) {
            switch (featurePathValue.getTypeClass()) {
                case 3: {
                    return TypeClass.TYPE_CLASS_STRING;
                }
                case 1: {
                    return TypeClass.TYPE_CLASS_INT;
                }
                case 9: {
                    return TypeClass.TYPE_CLASS_BOOLEAN;
                }
                case 10: {
                    return TypeClass.TYPE_CLASS_BYTE;
                }
                case 13: {
                    return TypeClass.TYPE_CLASS_DOUBLE;
                }
                case 2: {
                    return TypeClass.TYPE_CLASS_FLOAT;
                }
                case 12: {
                    return TypeClass.TYPE_CLASS_LONG;
                }
                case 11: {
                    return TypeClass.TYPE_CLASS_SHORT;
                }
                case 0: {
                    return TypeClass.TYPE_CLASS_INVALID;
                }
                case 8: {
                    return TypeClass.TYPE_CLASS_FS;
                }
                case 14: {
                    return TypeClass.TYPE_CLASS_BOOLEANARRAY;
                }
                case 15: {
                    return TypeClass.TYPE_CLASS_BYTEARRAY;
                }
                case 18: {
                    return TypeClass.TYPE_CLASS_DOUBLEARRAY;
                }
                case 5: {
                    return TypeClass.TYPE_CLASS_FLOATARRAY;
                }
                case 7: {
                    return TypeClass.TYPE_CLASS_FSARRAY;
                }
                case 4: {
                    return TypeClass.TYPE_CLASS_INTARRAY;
                }
                case 17: {
                    return TypeClass.TYPE_CLASS_LONGARRAY;
                }
                case 16: {
                    return TypeClass.TYPE_CLASS_SHORTARRAY;
                }
                case 6: {
                    return TypeClass.TYPE_CLASS_STRINGARRAY;
                }
            }
        }
        return null;
    }

    public String getValueAsString(FeatureStructure fs) {
        if (fs != null) {
            LowLevelCAS llCas = fs.getCAS().getLowLevelCAS();
            return this.ll_getValueAsString(llCas.ll_getFSRef(fs), llCas);
        }
        return null;
    }

    public String ll_getValueAsString(int fsRef, LowLevelCAS llCas) {
        FeaturePathValue featurePathValue = this.getValue(fsRef, llCas);
        if (featurePathValue != null) {
            switch (featurePathValue.getTypeClass()) {
                case 3: {
                    if (this.builtInFunction > 0) {
                        this.throwBuiltInFunctionException(featurePathValue.getFeatureType().getName());
                    }
                    return featurePathValue.getStringValue();
                }
                case 1: {
                    if (this.builtInFunction > 0) {
                        this.throwBuiltInFunctionException(featurePathValue.getFeatureType().getName());
                    }
                    return Integer.toString(featurePathValue.getIntValue());
                }
                case 9: {
                    if (this.builtInFunction > 0) {
                        this.throwBuiltInFunctionException(featurePathValue.getFeatureType().getName());
                    }
                    return Boolean.toString(featurePathValue.getBooleanValue());
                }
                case 10: {
                    if (this.builtInFunction > 0) {
                        this.throwBuiltInFunctionException(featurePathValue.getFeatureType().getName());
                    }
                    return Byte.toString(featurePathValue.getByteValue());
                }
                case 13: {
                    if (this.builtInFunction > 0) {
                        this.throwBuiltInFunctionException(featurePathValue.getFeatureType().getName());
                    }
                    return Double.toString(featurePathValue.getDoubleValue());
                }
                case 2: {
                    if (this.builtInFunction > 0) {
                        this.throwBuiltInFunctionException(featurePathValue.getFeatureType().getName());
                    }
                    return Float.toString(featurePathValue.getFloatValue());
                }
                case 12: {
                    if (this.builtInFunction > 0) {
                        this.throwBuiltInFunctionException(featurePathValue.getFeatureType().getName());
                    }
                    return Long.toString(featurePathValue.getLongValue());
                }
                case 11: {
                    if (this.builtInFunction > 0) {
                        this.throwBuiltInFunctionException(featurePathValue.getFeatureType().getName());
                    }
                    return Short.toString(featurePathValue.getShortValue());
                }
                case 0: {
                    return null;
                }
                case 8: {
                    FeatureStructure returnFS = featurePathValue.getFs();
                    if (returnFS == null) {
                        return null;
                    }
                    if (this.builtInFunction > 0) {
                        return this.evaluateBuiltInFunction(returnFS);
                    }
                    return returnFS.toString();
                }
                case 14: {
                    BooleanArrayFS returnFS = (BooleanArrayFS)featurePathValue.getFs();
                    if (returnFS == null) {
                        return null;
                    }
                    if (this.builtInFunction > 0) {
                        return this.evaluateBuiltInFunction(returnFS);
                    }
                    return FeaturePathImpl.convertToString(returnFS.toStringArray());
                }
                case 15: {
                    ByteArrayFS returnFS = (ByteArrayFS)featurePathValue.getFs();
                    if (returnFS == null) {
                        return null;
                    }
                    if (this.builtInFunction > 0) {
                        return this.evaluateBuiltInFunction(returnFS);
                    }
                    return FeaturePathImpl.convertToString(returnFS.toStringArray());
                }
                case 18: {
                    DoubleArrayFS returnFS = (DoubleArrayFS)featurePathValue.getFs();
                    if (returnFS == null) {
                        return null;
                    }
                    if (this.builtInFunction > 0) {
                        return this.evaluateBuiltInFunction(returnFS);
                    }
                    return FeaturePathImpl.convertToString(returnFS.toStringArray());
                }
                case 5: {
                    FloatArrayFS returnFS = (FloatArrayFS)featurePathValue.getFs();
                    if (returnFS == null) {
                        return null;
                    }
                    return FeaturePathImpl.convertToString(returnFS.toStringArray());
                }
                case 7: {
                    ArrayFS returnFS = (ArrayFS)featurePathValue.getFs();
                    if (returnFS == null) {
                        return null;
                    }
                    if (this.builtInFunction > 0) {
                        return this.evaluateBuiltInFunction(returnFS);
                    }
                    return FeaturePathImpl.convertToString(returnFS.toStringArray());
                }
                case 4: {
                    IntArrayFS returnFS = (IntArrayFS)featurePathValue.getFs();
                    if (returnFS == null) {
                        return null;
                    }
                    if (this.builtInFunction > 0) {
                        return this.evaluateBuiltInFunction(returnFS);
                    }
                    return FeaturePathImpl.convertToString(returnFS.toStringArray());
                }
                case 17: {
                    LongArrayFS returnFS = (LongArrayFS)featurePathValue.getFs();
                    if (returnFS == null) {
                        return null;
                    }
                    if (this.builtInFunction > 0) {
                        return this.evaluateBuiltInFunction(returnFS);
                    }
                    return FeaturePathImpl.convertToString(returnFS.toStringArray());
                }
                case 16: {
                    ShortArrayFS returnFS = (ShortArrayFS)featurePathValue.getFs();
                    if (returnFS == null) {
                        return null;
                    }
                    if (this.builtInFunction > 0) {
                        return this.evaluateBuiltInFunction(returnFS);
                    }
                    return FeaturePathImpl.convertToString(returnFS.toStringArray());
                }
                case 6: {
                    StringArrayFS returnFS = (StringArrayFS)featurePathValue.getFs();
                    if (returnFS == null) {
                        return null;
                    }
                    if (this.builtInFunction > 0) {
                        return this.evaluateBuiltInFunction(returnFS);
                    }
                    return FeaturePathImpl.convertToString(returnFS.toStringArray());
                }
            }
        }
        return null;
    }

    private void throwBuiltInFunctionException(String typeName) {
        String functionName = null;
        if (this.builtInFunction == 1) {
            functionName = FUNCTION_NAME_COVERED_TEXT;
        } else if (this.builtInFunction == 2) {
            functionName = FUNCTION_NAME_ID;
        } else if (this.builtInFunction == 3) {
            functionName = FUNCTION_NAME_TYPE_NAME;
        }
        throw new CASRuntimeException(MESSAGE_DIGEST, "BUILT_IN_FUNCTION_NOT_SUPPORTED", new Object[]{functionName, typeName});
    }

    private String evaluateBuiltInFunction(FeatureStructure returnFS) {
        if (this.builtInFunction == 1) {
            if (returnFS instanceof AnnotationFS) {
                return ((AnnotationFS)returnFS).getCoveredText();
            }
            throw new CASRuntimeException(MESSAGE_DIGEST, "BUILT_IN_FUNCTION_NOT_SUPPORTED", new Object[]{FUNCTION_NAME_COVERED_TEXT, returnFS.getType().getName()});
        }
        if (this.builtInFunction == 2) {
            return Integer.toString(returnFS.getCAS().getLowLevelCAS().ll_getFSRef(returnFS));
        }
        if (this.builtInFunction == 3) {
            return returnFS.getType().getName();
        }
        return null;
    }

    private static String convertToString(String[] array) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(array[i]);
        }
        return buffer.toString();
    }

    private FeaturePathValue getValue(int fsRef, LowLevelCAS llCas) {
        FeaturePathValue featurePathValue = new FeaturePathValue();
        if (this.featurePathElementNames.size() == 0) {
            if (fsRef == 0) {
                return null;
            }
            featurePathValue.setFs(fsRef, llCas);
            int typeCode = llCas.ll_getFSRefType(fsRef, true);
            featurePathValue.setTypeClass(llCas.ll_getTypeClass(typeCode));
            featurePathValue.setFeatureType(llCas.ll_getTypeSystem().ll_getTypeForCode(typeCode));
            return featurePathValue;
        }
        boolean noFurtherElementsPossible = false;
        int currentFsRef = fsRef;
        int currentFeatureCode = 0;
        int currentRangeTypeCode = 0;
        block13: for (int i = 0; i < this.featurePathElementNames.size(); ++i) {
            if (noFurtherElementsPossible) {
                if (currentFsRef == 0) {
                    return null;
                }
                throw new CASRuntimeException(MESSAGE_DIGEST, "INVALID_FEATURE_PATH", new Object[]{this.featurePathString, this.featurePathElementNames.get(i - 1)});
            }
            boolean isInitSubType = false;
            if (this.featurePathBaseTypeCode > 0) {
                isInitSubType = llCas.ll_getTypeSystem().ll_subsumes(this.featurePathBaseTypeCode, llCas.ll_getFSRefType(fsRef, true));
            }
            if (isInitSubType && this.ll_featurePathElements != null) {
                currentFeatureCode = this.ll_featurePathElements.get(i);
            } else {
                int fsRefTypeCode = llCas.ll_getFSRefType(fsRef, true);
                Type currentType = llCas.ll_getTypeSystem().ll_getTypeForCode(fsRefTypeCode);
                Feature feature = currentType.getFeatureByBaseName(this.featurePathElementNames.get(i));
                if (feature == null) {
                    throw new CASRuntimeException(MESSAGE_DIGEST, "INVALID_FEATURE_PATH_FEATURE_NOT_DEFINED", new Object[]{this.featurePathString, currentType.getName(), this.featurePathElementNames.get(i)});
                }
                currentFeatureCode = llCas.ll_getTypeSystem().ll_getCodeForFeature(feature);
            }
            currentRangeTypeCode = llCas.ll_getTypeSystem().ll_getRangeType(currentFeatureCode);
            switch (llCas.ll_getTypeClass(currentRangeTypeCode)) {
                case 3: {
                    featurePathValue.setStringValue(llCas.ll_getStringValue(currentFsRef, currentFeatureCode, true));
                    noFurtherElementsPossible = true;
                    continue block13;
                }
                case 1: {
                    featurePathValue.setIntValue(llCas.ll_getIntValue(currentFsRef, currentFeatureCode, true));
                    noFurtherElementsPossible = true;
                    continue block13;
                }
                case 9: {
                    featurePathValue.setBooleanValue(llCas.ll_getBooleanValue(currentFsRef, currentFeatureCode, true));
                    noFurtherElementsPossible = true;
                    continue block13;
                }
                case 10: {
                    featurePathValue.setByteValue(llCas.ll_getByteValue(currentFsRef, currentFeatureCode, true));
                    noFurtherElementsPossible = true;
                    continue block13;
                }
                case 13: {
                    featurePathValue.setDoubleValue(llCas.ll_getDoubleValue(currentFsRef, currentFeatureCode, true));
                    noFurtherElementsPossible = true;
                    continue block13;
                }
                case 2: {
                    featurePathValue.setFloatValue(llCas.ll_getFloatValue(currentFsRef, currentFeatureCode, true));
                    noFurtherElementsPossible = true;
                    continue block13;
                }
                case 12: {
                    featurePathValue.setLongValue(llCas.ll_getLongValue(currentFsRef, currentFeatureCode, true));
                    noFurtherElementsPossible = true;
                    continue block13;
                }
                case 11: {
                    featurePathValue.setShortValue(llCas.ll_getShortValue(currentFsRef, currentFeatureCode, true));
                    noFurtherElementsPossible = true;
                    continue block13;
                }
                case 0: {
                    noFurtherElementsPossible = true;
                    continue block13;
                }
                case 8: {
                    currentFsRef = llCas.ll_getRefValue(currentFsRef, currentFeatureCode, true);
                    if (currentFsRef == 0) {
                        noFurtherElementsPossible = true;
                        featurePathValue.setFs(0, null);
                        continue block13;
                    }
                    featurePathValue.setFs(currentFsRef, llCas);
                    continue block13;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    currentFsRef = llCas.ll_getRefValue(currentFsRef, currentFeatureCode, true);
                    featurePathValue.setFs(currentFsRef, llCas);
                    noFurtherElementsPossible = true;
                }
            }
        }
        featurePathValue.setTypeClass(llCas.ll_getTypeClass(currentRangeTypeCode));
        featurePathValue.setFeatureType(llCas.ll_getTypeSystem().ll_getTypeForCode(currentRangeTypeCode));
        return featurePathValue;
    }
}

