/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.NoSuchElementException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.admin.FSIndexComparator;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSIndexComparatorImpl;
import org.apache.uima.cas.impl.FSLeafIndexImpl;
import org.apache.uima.cas.impl.FeatureStructureImpl;
import org.apache.uima.cas.impl.LowLevelIndex;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.internal.util.ComparableIntPointerIterator;
import org.apache.uima.internal.util.IntComparator;
import org.apache.uima.internal.util.IntPointerIterator;
import org.apache.uima.internal.util.IntVector;

public class FSBagIndex
extends FSLeafIndexImpl {
    private IntVector index;
    private int initialSize;

    FSBagIndex(CASImpl cas, Type type, int initialSize, int indexType) {
        super(cas, type, indexType);
        this.initialSize = initialSize;
        this.index = new IntVector(initialSize);
    }

    boolean init(FSIndexComparator comp) {
        FSIndexComparator newComp;
        if (comp.getNumberOfKeys() > 0) {
            newComp = new FSIndexComparatorImpl(this.lowLevelCAS);
            newComp.setType(comp.getType());
        } else {
            newComp = comp;
        }
        return super.init(newComp);
    }

    IntVector getVector() {
        return this.index;
    }

    public void flush() {
        this.index = new IntVector(this.initialSize);
    }

    public final boolean insert(int fs) {
        this.index.add(fs);
        return true;
    }

    private final int find(int ele) {
        int[] array = this.index.getArray();
        int max2 = this.index.size();
        for (int i = 0; i < max2; ++i) {
            if (this.compare(ele, array[i]) != 0) continue;
            return i;
        }
        return -1;
    }

    public int compare(int fs1, int fs2) {
        if (fs1 < fs2) {
            return -1;
        }
        if (fs1 > fs2) {
            return 1;
        }
        return 0;
    }

    public ComparableIntPointerIterator pointerIterator(IntComparator comp, int[] detectIllegalIndexUpdates, int typeCode) {
        IntVectorIterator ivi = new IntVectorIterator(comp);
        ivi.modificationSnapshot = detectIllegalIndexUpdates[typeCode];
        IntVectorIterator.access$402(ivi, detectIllegalIndexUpdates);
        ivi.typeCode = typeCode;
        return ivi;
    }

    protected IntPointerIterator refIterator() {
        return new IntVectorIterator();
    }

    public LowLevelIterator ll_iterator() {
        return new IntVectorIterator();
    }

    protected IntPointerIterator refIterator(int fsCode) {
        IntVectorIterator it = new IntVectorIterator();
        int pos = this.find(fsCode);
        if (pos >= 0) {
            it.itPos = pos;
        } else {
            it.itPos = -(pos + 1);
        }
        return it;
    }

    public boolean contains(FeatureStructure fs) {
        return this.find(((FeatureStructureImpl)fs).getAddress()) >= 0;
    }

    public FeatureStructure find(FeatureStructure fs) {
        FeatureStructureImpl fsi = (FeatureStructureImpl)fs;
        int resultAddr = this.find(fsi.getAddress());
        if (resultAddr > 0) {
            return fsi.getCASImpl().createFS(this.index.get(resultAddr));
        }
        return null;
    }

    public int size() {
        return this.index.size();
    }

    public void deleteFS(FeatureStructure fs) {
        int addr = ((FeatureStructureImpl)fs).getAddress();
        int pos = this.index.indexOf(addr);
        if (pos >= 0) {
            this.index.remove(pos);
        }
    }

    public void remove(int fsRef) {
        int pos = this.index.indexOf(fsRef);
        if (pos >= 0) {
            this.index.remove(pos);
        }
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    private class IntVectorIterator
    implements ComparableIntPointerIterator,
    LowLevelIterator {
        private int itPos = 0;
        private IntComparator comp;
        private int modificationSnapshot;
        private int[] detectIllegalIndexUpdates;
        private int typeCode;

        public boolean isConcurrentModification() {
            return this.modificationSnapshot != this.detectIllegalIndexUpdates[this.typeCode];
        }

        public void resetConcurrentModification() {
            this.modificationSnapshot = this.detectIllegalIndexUpdates[this.typeCode];
        }

        private IntVectorIterator() {
        }

        private IntVectorIterator(IntComparator comp) {
            this();
            this.comp = comp;
        }

        public boolean isValid() {
            return this.itPos >= 0 && this.itPos < FSBagIndex.this.index.size();
        }

        public void moveToFirst() {
            this.itPos = 0;
        }

        public void moveToLast() {
            this.itPos = FSBagIndex.this.index.size() - 1;
        }

        public void moveToNext() {
            ++this.itPos;
        }

        public void moveToPrevious() {
            --this.itPos;
        }

        public int ll_get() {
            if (!this.isValid()) {
                throw new NoSuchElementException();
            }
            return FSBagIndex.this.index.get(this.itPos);
        }

        public Object copy() {
            IntVectorIterator copy = new IntVectorIterator(this.comp);
            copy.itPos = this.itPos;
            return copy;
        }

        public int compareTo(Object o) throws NoSuchElementException {
            return this.comp.compare(this.get(), ((IntVectorIterator)o).get());
        }

        public void moveTo(int i) {
            int position = FSBagIndex.this.find(i);
            this.itPos = position >= 0 ? position : -(position + 1);
        }

        public int get() throws NoSuchElementException {
            return this.ll_get();
        }

        public void inc() {
            this.moveToNext();
        }

        public void dec() {
            this.moveToPrevious();
        }

        public int ll_indexSize() {
            return FSBagIndex.this.size();
        }

        public LowLevelIndex ll_getIndex() {
            return FSBagIndex.this;
        }

        static /* synthetic */ int[] access$402(IntVectorIterator x0, int[] x1) {
            x0.detectIllegalIndexUpdates = x1;
            return x1;
        }
    }
}

